/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.testing;

import java.security.Provider;
import java.security.Security;
import javax.annotation.Nonnull;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class SecurityProviderTestSupport {
    @Nonnull
    @NotEmpty
    public static final String BC_PROVIDER_NAME = "BC";
    @Nonnull
    @NotEmpty
    public static final String SUNEC_PROVIDER_NAME = "SunEC";
    private boolean hadBCOriginally = Security.getProvider("BC") != null;

    public void loadBC() {
        if (!this.haveBC()) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }

    public void unloadBC() {
        if (!this.hadBCOriginally && this.haveBC()) {
            Security.removeProvider(BC_PROVIDER_NAME);
        }
    }

    public boolean haveBC() {
        return Security.getProvider(BC_PROVIDER_NAME) != null;
    }

    public boolean haveSunEC() {
        return Security.getProvider(SUNEC_PROVIDER_NAME) != null;
    }

    public boolean isOpenJDK() {
        return System.getProperty("java.runtime.name", "").startsWith("OpenJDK") || System.getProperty("java.vm.name", "").startsWith("OpenJDK");
    }
}

