/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.storage.impl.client;

import com.google.common.escape.Escaper;
import com.google.common.net.UrlEscapers;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.AbstractIdentifiedInitializableComponent;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.NonnullSupplier;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.action.AbstractProfileAction;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.storage.impl.client.ClientStorageSaveContext;
import org.opensaml.storage.impl.client.ClientStorageService;
import org.opensaml.storage.impl.client.ClientStorageServiceOperation;
import org.slf4j.Logger;

public class SaveCookieBackedClientStorageServices
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SaveCookieBackedClientStorageServices.class);
    @Nonnull
    private Map<String, ClientStorageService> storageServices = CollectionSupport.emptyMap();
    @Nullable
    private ClientStorageSaveContext clientStorageSaveCtx;
    @Nonnull
    private Escaper escaper = UrlEscapers.urlFormParameterEscaper();

    public void setStorageServices(@Nullable Collection<ClientStorageService> services) {
        this.checkSetterPreconditions();
        this.storageServices = services != null ? (Map)((NonnullSupplier)services.stream().collect(CollectionSupport.nonnullCollector(Collectors.toUnmodifiableMap(AbstractIdentifiedInitializableComponent::ensureId, ss -> ss)))).get() : CollectionSupport.emptyMap();
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        if (this.storageServices.isEmpty()) {
            this.log.debug("{} No ClientStorageServices supplied, nothing to do", (Object)this.getLogPrefix());
            return false;
        }
        this.clientStorageSaveCtx = (ClientStorageSaveContext)profileRequestContext.getSubcontext(ClientStorageSaveContext.class);
        if (this.clientStorageSaveCtx == null) {
            this.log.debug("{} No ClientStorageSaveContext found", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        assert (this.clientStorageSaveCtx != null);
        if (!this.clientStorageSaveCtx.isSourceRequired(ClientStorageService.ClientStorageSource.COOKIE)) {
            this.log.debug("{} No cookie operations required", (Object)this.getLogPrefix());
            assert (this.clientStorageSaveCtx != null);
            profileRequestContext.removeSubcontext((BaseContext)this.clientStorageSaveCtx);
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        assert (this.clientStorageSaveCtx != null);
        for (ClientStorageServiceOperation operation : this.clientStorageSaveCtx.getStorageOperations()) {
            ClientStorageService storageService = this.storageServices.get(operation.getStorageServiceID());
            if (storageService == null) {
                this.log.error("{} ClientStorageService with ID '{}' missing from configuration", (Object)this.getLogPrefix(), (Object)operation.getStorageServiceID());
                continue;
            }
            if (operation.getValue() != null) {
                this.log.debug("{} Saving data for ClientStorageService '{}' to cookie named '{}'", new Object[]{this.getLogPrefix(), operation.getStorageServiceID(), operation.getKey()});
                storageService.getCookieManager().addCookie(operation.getKey(), this.escaper.escape(operation.getValue()));
                continue;
            }
            this.log.debug("{} Clearing data for ClientStorageService '{}' from cookie named '{}'", new Object[]{this.getLogPrefix(), operation.getStorageServiceID(), operation.getKey()});
            storageService.getCookieManager().unsetCookie(operation.getKey());
        }
        assert (this.clientStorageSaveCtx != null);
        profileRequestContext.removeSubcontext((BaseContext)this.clientStorageSaveCtx);
    }
}

