/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.storage.impl.client;

import jakarta.servlet.http.HttpServletRequest;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.action.AbstractProfileAction;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.storage.impl.client.ClientStorageSaveContext;
import org.opensaml.storage.impl.client.ClientStorageService;
import org.opensaml.storage.impl.client.ClientStorageServiceOperation;
import org.slf4j.Logger;

public class LogLocalStorageSaveResults
extends AbstractProfileAction {
    @Nonnull
    @NotEmpty
    public static final String SUCCESS_FORM_FIELD = "shib_idp_ls_success";
    @Nonnull
    @NotEmpty
    public static final String EXCEPTION_FORM_FIELD = "shib_idp_ls_exception";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(LogLocalStorageSaveResults.class);
    @Nullable
    private ClientStorageSaveContext clientStorageSaveCtx;

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.clientStorageSaveCtx = (ClientStorageSaveContext)profileRequestContext.getSubcontext(ClientStorageSaveContext.class);
        return this.clientStorageSaveCtx != null;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        HttpServletRequest request = this.getHttpServletRequest();
        if (request == null) {
            this.log.error("{} HttpServletRequest not available", (Object)this.getLogPrefix());
            return;
        }
        assert (this.clientStorageSaveCtx != null);
        for (ClientStorageServiceOperation operation : this.clientStorageSaveCtx.getStorageOperations()) {
            if (operation.getStorageSource() != ClientStorageService.ClientStorageSource.HTML_LOCAL_STORAGE) continue;
            String param = request.getParameter("shib_idp_ls_success." + operation.getKey());
            if (param != null || Boolean.valueOf(param).booleanValue()) {
                this.log.debug("{} Save to local storage for StorageService '{}' succeeded", (Object)this.getLogPrefix(), (Object)operation.getStorageServiceID());
                continue;
            }
            param = request.getParameter("shib_idp_ls_exception." + operation.getKey());
            this.log.warn("{} Save to local storage for StorageService '{}' failed: {}", new Object[]{this.getLogPrefix(), operation.getStorageServiceID(), param});
        }
    }
}

