/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.storage.impl;

import com.unboundid.ldap.listener.InMemoryDirectoryServer;
import com.unboundid.ldap.listener.InMemoryDirectoryServerConfig;
import com.unboundid.ldap.listener.InMemoryListenerConfig;
import com.unboundid.ldap.sdk.LDAPException;
import java.io.IOException;
import java.time.Duration;
import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.ldaptive.DefaultConnectionFactory;
import org.ldaptive.LdapAttribute;
import org.ldaptive.pool.BlockingConnectionPool;
import org.ldaptive.pool.ConnectionPool;
import org.ldaptive.pool.PooledConnectionFactory;
import org.opensaml.storage.StorageRecord;
import org.opensaml.storage.impl.LDAPStorageService;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class LDAPStorageServiceTest {
    protected LDAPStorageService storageService;
    private InMemoryDirectoryServer directoryServer;
    private final String context = "cn=Principal,ou=people,dc=shibboleth,dc=net";

    @BeforeClass
    protected void setUp() throws ComponentInitializationException, LDAPException {
        InMemoryDirectoryServerConfig config = new InMemoryDirectoryServerConfig(new String[]{"dc=shibboleth,dc=net"});
        config.setListenerConfigs(new InMemoryListenerConfig[]{InMemoryListenerConfig.createLDAPConfig((String)"default", (int)10389)});
        config.addAdditionalBindCredentials("cn=Directory Manager", "password");
        this.directoryServer = new InMemoryDirectoryServer(config);
        this.directoryServer.importFromLDIF(true, "src/test/resources/org/opensaml/storage/impl/LDAPStorageServiceTest.ldif");
        this.directoryServer.startListening();
        this.storageService = this.getStorageService();
        this.storageService.initialize();
    }

    @AfterClass
    protected void tearDown() {
        this.storageService.destroy();
        this.directoryServer.shutDown(true);
    }

    @Nonnull
    protected PooledConnectionFactory getPooledConnectionFactory() {
        return new PooledConnectionFactory((ConnectionPool)new BlockingConnectionPool(new DefaultConnectionFactory("ldap://localhost:10389")));
    }

    @Nonnull
    protected LDAPStorageService getStorageService() {
        LDAPStorageService ss = new LDAPStorageService(this.getPooledConnectionFactory(), new LdapAttribute[]{new LdapAttribute("objectClass", new String[]{"inetOrgPerson", "organizationalPerson", "person", "top"}), new LdapAttribute("cn", new String[]{"Principal"}), new LdapAttribute("sn", new String[]{"Lastname"})});
        ss.setId("test");
        return ss;
    }

    @Test
    public void throwException() throws IOException {
        try {
            this.storageService.create("cn=Principal,ou=people,dc=shibboleth,dc=net", "mail", "principal@shibboleth.net", Long.valueOf(5000L));
            Assert.fail((String)"Should have thrown exception");
        }
        catch (UnsupportedOperationException e) {
            Assert.assertEquals(e.getClass(), UnsupportedOperationException.class);
        }
        try {
            this.storageService.read("cn=Principal,ou=people,dc=shibboleth,dc=net", "mail", 3L);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (UnsupportedOperationException e) {
            Assert.assertEquals(e.getClass(), UnsupportedOperationException.class);
        }
        try {
            this.storageService.update("cn=Principal,ou=people,dc=shibboleth,dc=net", "mail", "principal@shibboleth.net", Long.valueOf(10000L));
            Assert.fail((String)"Should have thrown exception");
        }
        catch (UnsupportedOperationException e) {
            Assert.assertEquals(e.getClass(), UnsupportedOperationException.class);
        }
        try {
            this.storageService.updateWithVersion(2L, "cn=Principal,ou=people,dc=shibboleth,dc=net", "mail", "principal@shibboleth.net", Long.valueOf(10000L));
            Assert.fail((String)"Should have thrown exception");
        }
        catch (UnsupportedOperationException e) {
            Assert.assertEquals(e.getClass(), UnsupportedOperationException.class);
        }
        catch (Exception e) {
            Assert.fail((String)"Threw exception", (Throwable)e);
        }
        try {
            this.storageService.updateExpiration("cn=Principal,ou=people,dc=shibboleth,dc=net", "mail", Long.valueOf(8000L));
            Assert.fail((String)"Should have thrown exception");
        }
        catch (UnsupportedOperationException e) {
            Assert.assertEquals(e.getClass(), UnsupportedOperationException.class);
        }
        try {
            this.storageService.updateContextExpiration("cn=Principal,ou=people,dc=shibboleth,dc=net", Long.valueOf(15000L));
            Assert.fail((String)"Should have thrown exception");
        }
        catch (UnsupportedOperationException e) {
            Assert.assertEquals(e.getClass(), UnsupportedOperationException.class);
        }
    }

    @Test
    public void create() throws IOException {
        this.storageService.create("cn=Principal,ou=people,dc=shibboleth,dc=net", "mail", "principal@shibboleth.net", null);
        StorageRecord rec = this.storageService.read("cn=Principal,ou=people,dc=shibboleth,dc=net", "mail");
        Assert.assertNotNull((Object)rec);
        Assert.assertEquals((String)rec.getValue(), (String)"principal@shibboleth.net");
        this.storageService.update("cn=Principal,ou=people,dc=shibboleth,dc=net", "mail", "principal2@shibboleth.net", null);
        rec = this.storageService.read("cn=Principal,ou=people,dc=shibboleth,dc=net", "mail");
        Assert.assertNotNull((Object)rec);
        Assert.assertEquals((String)rec.getValue(), (String)"principal2@shibboleth.net");
        this.storageService.create("cn=Principal,ou=people,dc=shibboleth,dc=net", "mail", "principal3@shibboleth.net", null);
        this.storageService.update("cn=Principal,ou=people,dc=shibboleth,dc=net", "description", "test user", null);
        rec = this.storageService.read("cn=Principal,ou=people,dc=shibboleth,dc=net", "description");
        Assert.assertNotNull((Object)rec);
        Assert.assertEquals((String)rec.getValue(), (String)"test user");
        this.storageService.delete("cn=Principal,ou=people,dc=shibboleth,dc=net", "description");
        rec = this.storageService.read("cn=Principal,ou=people,dc=shibboleth,dc=net", "description");
        Assert.assertNull((Object)rec);
        rec = this.storageService.read("cn=Principal,ou=people,dc=shibboleth,dc=net", "mail");
        Assert.assertNotNull((Object)rec);
        Assert.assertEquals((String)rec.getValue(), (String)"principal3@shibboleth.net");
        this.storageService.deleteContext("cn=Principal,ou=people,dc=shibboleth,dc=net");
        rec = this.storageService.read("cn=Principal,ou=people,dc=shibboleth,dc=net", "mail");
        Assert.assertNull((Object)rec);
    }

    @Test
    public void invalidConfig() {
        LDAPStorageService ss = new LDAPStorageService(this.getPooledConnectionFactory(), new LdapAttribute[0]);
        ss.setCleanupInterval(Duration.ofSeconds(1L));
        try {
            ss.initialize();
            Assert.fail((String)"Storage service should have failed to initialize");
        }
        catch (ComponentInitializationException componentInitializationException) {
            // empty catch block
        }
        ss.destroy();
    }

    @Test
    public void validConfig() throws ComponentInitializationException {
        LDAPStorageService ss = new LDAPStorageService(this.getPooledConnectionFactory(), new LdapAttribute[0]);
        ss.setId("test");
        ss.initialize();
        ss.destroy();
    }
}

