/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.storage.impl.memcached;

import java.nio.charset.StandardCharsets;
import net.spy.memcached.CachedData;
import net.spy.memcached.transcoders.Transcoder;
import org.cryptacular.util.ByteUtil;
import org.opensaml.storage.impl.memcached.MemcachedStorageRecord;

public class StorageRecordTranscoder
implements Transcoder<MemcachedStorageRecord<?>> {
    private static final int MAX_SIZE = 0x100000;

    public boolean asyncDecode(CachedData d) {
        return false;
    }

    public CachedData encode(MemcachedStorageRecord<?> o) {
        byte[] value = o.getValue().getBytes(StandardCharsets.UTF_8);
        byte[] encoded = new byte[value.length + 8];
        ByteUtil.toBytes((long)(o.getExpiration() == null ? 0L : o.getExpiration()), (byte[])encoded, (int)0);
        System.arraycopy(value, 0, encoded, 8, value.length);
        return new CachedData(0, encoded, 0x100000);
    }

    public MemcachedStorageRecord<?> decode(CachedData d) {
        byte[] bytes = d.getData();
        String value = new String(bytes, 8, bytes.length - 8, StandardCharsets.UTF_8);
        long exp = (long)bytes[0] << 56 | ((long)bytes[1] & 0xFFL) << 48 | ((long)bytes[2] & 0xFFL) << 40 | ((long)bytes[3] & 0xFFL) << 32 | ((long)bytes[4] & 0xFFL) << 24 | ((long)bytes[5] & 0xFFL) << 16 | ((long)bytes[6] & 0xFFL) << 8 | (long)bytes[7] & 0xFFL;
        return new MemcachedStorageRecord(value, exp == 0L ? null : Long.valueOf(exp));
    }

    public int getMaxSize() {
        return 0x100000;
    }
}

