/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.storage.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.TypedQuery;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.Positive;
import net.shibboleth.utilities.java.support.collection.Pair;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.storage.AbstractStorageService;
import org.opensaml.storage.StorageRecord;
import org.opensaml.storage.VersionMismatchException;
import org.opensaml.storage.impl.JPAStorageRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPAStorageService
extends AbstractStorageService {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(JPAStorageService.class);
    @Nonnull
    private final EntityManagerFactory entityManagerFactory;

    public JPAStorageService(@Nonnull EntityManagerFactory factory) {
        this.entityManagerFactory = (EntityManagerFactory)Constraint.isNotNull((Object)factory, (String)"EntityManagerFactory cannot be null");
        this.setContextSize(255);
        this.setKeySize(255);
        this.setValueSize(255);
    }

    protected void doDestroy() {
        if (this.entityManagerFactory.isOpen()) {
            this.entityManagerFactory.close();
        }
        super.doDestroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean create(@Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key, @Nonnull @NotEmpty String value, @Nullable @Positive Long expiration) throws IOException {
        EntityManager manager = null;
        EntityTransaction transaction = null;
        try {
            manager = this.entityManagerFactory.createEntityManager();
            JPAStorageRecord entity = (JPAStorageRecord)((Object)manager.find(JPAStorageRecord.class, (Object)new JPAStorageRecord.RecordId(context, key)));
            if (entity != null) {
                Long exp = entity.getExpiration();
                if (exp == null || System.currentTimeMillis() < exp) {
                    boolean bl = false;
                    return bl;
                }
                this.delete(context, key);
            }
            transaction = manager.getTransaction();
            transaction.begin();
            entity = new JPAStorageRecord();
            entity.setContext(context);
            entity.setKey(key);
            entity.setValue(value);
            entity.setExpiration(expiration);
            manager.persist((Object)entity);
            transaction.commit();
            this.log.debug("Inserted record '{}' in context '{}' with expiration '{}'", new Object[]{key, context, expiration});
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            this.log.error("Error creating record '{}' in context '{}' with expiration '{}'", new Object[]{key, context, expiration, e});
            if (transaction != null && transaction.isActive()) {
                transaction.rollback();
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (manager != null && manager.isOpen()) {
                manager.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @NonnullElements
    public List<StorageRecord> readAll() throws IOException {
        EntityManager manager = null;
        try {
            manager = this.entityManagerFactory.createEntityManager();
            List<StorageRecord> list = this.executeNamedQuery(manager, "JPAStorageRecord.findAll", null, StorageRecord.class);
            return list;
        }
        finally {
            if (manager != null && manager.isOpen()) {
                manager.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @NonnullElements
    public List<StorageRecord> readAll(@Nonnull @NotEmpty String context) throws IOException {
        EntityManager manager = null;
        try {
            manager = this.entityManagerFactory.createEntityManager();
            HashMap params = Maps.newHashMap();
            params.put("context", context);
            List<StorageRecord> list = this.executeNamedQuery(manager, "JPAStorageRecord.findByContext", params, StorageRecord.class);
            return list;
        }
        finally {
            if (manager != null && manager.isOpen()) {
                manager.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @NonnullElements
    public List<String> readContexts() throws IOException {
        EntityManager manager = null;
        try {
            manager = this.entityManagerFactory.createEntityManager();
            List<String> list = this.executeNamedQuery(manager, "JPAStorageRecord.findAllContexts", null, String.class);
            return list;
        }
        finally {
            if (manager != null && manager.isOpen()) {
                manager.close();
            }
        }
    }

    @Nullable
    public StorageRecord read(@Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key) throws IOException {
        return (StorageRecord)this.readImpl(context, key, null).getSecond();
    }

    @Nonnull
    public Pair<Long, StorageRecord> read(@Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key, @Positive long version) throws IOException {
        return this.readImpl(context, key, version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    protected Pair<Long, StorageRecord> readImpl(@Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key, @Positive Long version) throws IOException {
        Pair pair;
        EntityManager manager = null;
        try {
            manager = this.entityManagerFactory.createEntityManager();
            JPAStorageRecord entity = (JPAStorageRecord)((Object)manager.find(JPAStorageRecord.class, (Object)new JPAStorageRecord.RecordId(context, key)));
            if (entity == null) {
                this.log.debug("Read failed, key '{}' not found in context '{}'", (Object)key, (Object)context);
                Pair pair2 = new Pair();
                return pair2;
            }
            Long exp = entity.getExpiration();
            if (exp != null && System.currentTimeMillis() >= exp) {
                this.log.debug("Read failed, key '{}' expired in context '{}'", (Object)key, (Object)context);
                Pair pair3 = new Pair();
                return pair3;
            }
            if (version != null && entity.getVersion() == version.longValue()) {
                pair = new Pair((Object)version, null);
                return pair;
            }
            pair = new Pair((Object)entity.getVersion(), (Object)entity);
            return pair;
        }
        catch (Exception e) {
            this.log.error("Error reading record '{}' in context '{}'", new Object[]{key, context, e});
            pair = new Pair();
            return pair;
        }
        finally {
            if (manager != null && manager.isOpen()) {
                manager.close();
            }
        }
    }

    public boolean update(@Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key, @Nonnull @NotEmpty String value, @Nullable @Positive Long expiration) throws IOException {
        try {
            return this.updateImpl(null, context, key, value, expiration) != null;
        }
        catch (VersionMismatchException e) {
            throw new IllegalStateException("Unexpected exception thrown by update.", e);
        }
    }

    @Nullable
    public Long updateWithVersion(@Positive long version, @Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key, @Nonnull @NotEmpty String value, @Nullable @Positive Long expiration) throws IOException, VersionMismatchException {
        return this.updateImpl(version, context, key, value, expiration);
    }

    public boolean updateExpiration(@Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key, @Nullable @Positive Long expiration) throws IOException {
        try {
            return this.updateImpl(null, context, key, null, expiration) != null;
        }
        catch (VersionMismatchException e) {
            throw new IllegalStateException("Unexpected exception thrown by update.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected Long updateImpl(@Nullable Long version, @Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key, @Nonnull @NotEmpty String value, @Nullable @Positive Long expiration) throws IOException, VersionMismatchException {
        Long l;
        EntityManager manager = null;
        EntityTransaction transaction = null;
        try {
            manager = this.entityManagerFactory.createEntityManager();
            JPAStorageRecord entity = (JPAStorageRecord)((Object)manager.find(JPAStorageRecord.class, (Object)new JPAStorageRecord.RecordId(context, key)));
            if (entity == null) {
                this.log.debug("Update failed, key '{}' not found in context '{}'", (Object)key, (Object)context);
                Long l2 = null;
                return l2;
            }
            Long exp = entity.getExpiration();
            if (exp != null && System.currentTimeMillis() >= exp) {
                this.log.debug("Update failed, key '{}' expired in context '{}'", (Object)key, (Object)context);
                Long l3 = null;
                return l3;
            }
            if (version != null && entity.getVersion() != version.longValue()) {
                throw new VersionMismatchException();
            }
            transaction = manager.getTransaction();
            transaction.begin();
            if (value != null) {
                entity.setValue(value);
                entity.incrementVersion();
            }
            entity.setExpiration(expiration);
            manager.merge((Object)entity);
            transaction.commit();
            this.log.debug("Updated record '{}' in context '{}' with expiration '{}'", new Object[]{key, context, expiration});
            l = entity.getVersion();
            return l;
        }
        catch (VersionMismatchException e) {
            throw e;
        }
        catch (Exception e) {
            this.log.error("Error updating record '{}' in context '{}'", new Object[]{key, context, e});
            if (transaction != null && transaction.isActive()) {
                transaction.rollback();
            }
            l = null;
            return l;
        }
        finally {
            if (manager != null && manager.isOpen()) {
                manager.close();
            }
        }
    }

    public boolean deleteWithVersion(@Positive long version, @Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key) throws IOException, VersionMismatchException {
        return this.deleteImpl(version, context, key);
    }

    public boolean delete(@Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key) throws IOException {
        try {
            return this.deleteImpl(null, context, key);
        }
        catch (VersionMismatchException e) {
            throw new IllegalStateException("Unexpected exception thrown by delete.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean deleteImpl(@Nullable @Positive Long version, @Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key) throws IOException, VersionMismatchException {
        EntityManager manager = null;
        EntityTransaction transaction = null;
        try {
            manager = this.entityManagerFactory.createEntityManager();
            JPAStorageRecord entity = (JPAStorageRecord)((Object)manager.find(JPAStorageRecord.class, (Object)new JPAStorageRecord.RecordId(context, key)));
            if (entity == null) {
                this.log.debug("Deleting record '{}' in context '{}'....key not found", (Object)key, (Object)context);
                boolean bl = false;
                return bl;
            }
            if (version != null && entity.getVersion() != version.longValue()) {
                throw new VersionMismatchException();
            }
            transaction = manager.getTransaction();
            transaction.begin();
            manager.remove((Object)entity);
            transaction.commit();
            this.log.debug("Deleted record '{}' in context '{}'", (Object)key, (Object)context);
            boolean bl = true;
            return bl;
        }
        catch (VersionMismatchException e) {
            throw e;
        }
        catch (Exception e) {
            this.log.error("Error deleting record '{}' in context '{}'", new Object[]{key, context, e});
            if (transaction != null && transaction.isActive()) {
                transaction.rollback();
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (manager != null && manager.isOpen()) {
                manager.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateContextExpiration(@Nonnull @NotEmpty String context, @Nullable @Positive Long expiration) throws IOException {
        EntityManager manager = null;
        EntityTransaction transaction = null;
        try {
            manager = this.entityManagerFactory.createEntityManager();
            HashMap params = Maps.newHashMap();
            params.put("context", context);
            params.put("now", System.currentTimeMillis());
            List<JPAStorageRecord> entities = this.executeNamedQuery(manager, "JPAStorageRecord.findActiveByContext", params, JPAStorageRecord.class);
            if (!entities.isEmpty()) {
                transaction = manager.getTransaction();
                transaction.begin();
                for (JPAStorageRecord entity : entities) {
                    entity.setExpiration(expiration);
                }
                transaction.commit();
                this.log.debug("Updated expiration of valid records in context '{}' to '{}'", (Object)context, (Object)expiration);
            }
        }
        catch (Exception e) {
            this.log.error("Error updating context expiration in context '{}'", (Object)context, (Object)e);
            if (transaction != null && transaction.isActive()) {
                transaction.rollback();
            }
        }
        finally {
            if (manager != null && manager.isOpen()) {
                manager.close();
            }
        }
    }

    public void deleteContext(@Nonnull @NotEmpty String context) throws IOException {
        this.deleteContextImpl(context, null);
        this.log.debug("Deleted all entities in context '{}'", (Object)context);
    }

    public void reap(@Nonnull @NotEmpty String context) throws IOException {
        this.deleteContextImpl(context, System.currentTimeMillis());
        this.log.debug("Reaped all entities in context '{}'", (Object)context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteContextImpl(@Nonnull @NotEmpty String context, @Nonnull Long expiration) throws IOException {
        EntityManager manager = null;
        EntityTransaction transaction = null;
        try {
            manager = this.entityManagerFactory.createEntityManager();
            HashMap params = Maps.newHashMap();
            params.put("context", context);
            List<JPAStorageRecord> entities = this.executeNamedQuery(manager, "JPAStorageRecord.findByContext", params, JPAStorageRecord.class);
            if (!entities.isEmpty()) {
                transaction = manager.getTransaction();
                transaction.begin();
                for (JPAStorageRecord entity : entities) {
                    if (expiration != null && (entity.getExpiration() == null || entity.getExpiration() > expiration)) continue;
                    manager.remove((Object)entity);
                    this.log.trace("Deleted entity {}", (Object)entity);
                }
                transaction.commit();
            }
        }
        catch (Exception e) {
            this.log.error("Error deleting context '{}'", (Object)context, (Object)e);
            if (transaction != null && transaction.isActive()) {
                transaction.rollback();
            }
        }
        finally {
            if (manager != null && manager.isOpen()) {
                manager.close();
            }
        }
    }

    private <T> List<T> executeNamedQuery(@Nonnull EntityManager manager, @Nonnull @NotEmpty String query, @Nonnull Map<String, Object> params, @Nonnull Class<T> clazz) {
        ArrayList results = Lists.newArrayList();
        try {
            TypedQuery queryResults = manager.createNamedQuery(query, clazz);
            if (params != null && !params.isEmpty()) {
                for (Map.Entry<String, Object> entry : params.entrySet()) {
                    queryResults.setParameter(entry.getKey(), entry.getValue());
                }
            }
            results.addAll(queryResults.getResultList());
        }
        catch (Exception e) {
            this.log.error("Error executing named query", (Throwable)e);
        }
        return results;
    }

    @Nullable
    protected TimerTask getCleanupTask() {
        return new TimerTask(){

            @Override
            public void run() {
                JPAStorageService.this.log.info("Running cleanup task");
                Long now = System.currentTimeMillis();
                List<String> contexts = null;
                try {
                    contexts = JPAStorageService.this.readContexts();
                }
                catch (IOException e) {
                    JPAStorageService.this.log.error("Error reading contexts", (Throwable)e);
                }
                if (contexts != null && !contexts.isEmpty()) {
                    for (String context : contexts) {
                        try {
                            JPAStorageService.this.deleteContextImpl(context, now);
                        }
                        catch (IOException e) {
                            JPAStorageService.this.log.error("Error deleting records in context '{}' for timestamp '{}'", new Object[]{context, now, e});
                        }
                    }
                }
            }
        };
    }
}

