/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.spring.credential;

import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.crypto.SecretKey;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resource.Resource;
import org.cryptacular.util.KeyPairUtil;
import org.opensaml.security.crypto.KeySupport;
import org.opensaml.spring.credential.AbstractBasicCredentialFactoryBean;
import org.slf4j.Logger;
import org.springframework.beans.factory.BeanCreationException;

public class BasicResourceCredentialFactoryBean
extends AbstractBasicCredentialFactoryBean {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(BasicResourceCredentialFactoryBean.class);
    @Nullable
    private Resource publicKeyInfo;
    @Nullable
    private Resource privateKeyInfo;
    @Nullable
    private Resource secretKeyInfo;

    @Nullable
    public Resource getPublicKeyInfo() {
        return this.publicKeyInfo;
    }

    public void setPublicKeyInfo(@Nullable Resource info) {
        this.publicKeyInfo = info;
    }

    @Nullable
    public Resource getPrivateKeyInfo() {
        return this.privateKeyInfo;
    }

    public void setPrivateKeyInfo(@Nullable Resource info) {
        this.privateKeyInfo = info;
    }

    @Nullable
    public Resource getSecretKeyInfo() {
        return this.secretKeyInfo;
    }

    public void setSecretKeyInfo(@Nullable Resource info) {
        this.secretKeyInfo = info;
    }

    @Override
    @Nullable
    protected PublicKey getPublicKey() {
        PublicKey publicKey;
        block9: {
            Resource pkinfo = this.getPublicKeyInfo();
            if (null == pkinfo) {
                return null;
            }
            InputStream is = pkinfo.getInputStream();
            try {
                publicKey = KeyPairUtil.readPublicKey((InputStream)is);
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    this.log.error("{}: Could not decode public key: {}", (Object)this.getConfigDescription(), (Object)e.getMessage());
                    throw new BeanCreationException("Could not decode public key", (Throwable)e);
                }
            }
            is.close();
        }
        return publicKey;
    }

    @Override
    @Nullable
    protected PrivateKey getPrivateKey() {
        PrivateKey privateKey;
        block9: {
            Resource pkinfo = this.getPrivateKeyInfo();
            if (null == pkinfo) {
                return null;
            }
            InputStream is = pkinfo.getInputStream();
            try {
                privateKey = KeySupport.decodePrivateKey((InputStream)is, (char[])this.getPrivateKeyPassword());
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | KeyException e) {
                    this.log.error("{}: Could not decode private key: {}", (Object)this.getConfigDescription(), (Object)e.getMessage());
                    throw new BeanCreationException("Could not decode private key", (Throwable)e);
                }
            }
            is.close();
        }
        return privateKey;
    }

    @Override
    @Nullable
    protected SecretKey getSecretKey() {
        SecretKey secretKey;
        block10: {
            Resource skinfo = this.getSecretKeyInfo();
            if (null == skinfo) {
                return null;
            }
            InputStream is = skinfo.getInputStream();
            try {
                String alg = this.getSecretKeyAlgorithm();
                if (alg == null) {
                    throw new KeyException("Key algorithm was null");
                }
                secretKey = KeySupport.decodeSecretKey((byte[])this.decodeSecretKey(ByteStreams.toByteArray((InputStream)is)), (String)alg);
                if (is == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | KeyException e) {
                    this.log.error("{}: Could not decode secret key: {}", (Object)this.getConfigDescription(), (Object)e.getMessage());
                    throw new BeanCreationException("Could not decode secret key", (Throwable)e);
                }
            }
            is.close();
        }
        return secretKey;
    }
}

