/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.soap.wstrust.impl;

import javax.xml.namespace.QName;
import org.joda.time.DateTime;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBuilder;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.Marshaller;
import org.opensaml.core.xml.io.Unmarshaller;
import org.opensaml.core.xml.schema.XSAny;
import org.opensaml.core.xml.schema.XSBooleanValue;
import org.opensaml.core.xml.schema.impl.XSAnyBuilder;
import org.opensaml.core.xml.schema.impl.XSAnyMarshaller;
import org.opensaml.core.xml.schema.impl.XSAnyUnmarshaller;
import org.opensaml.soap.WSBaseTestCase;
import org.opensaml.soap.wssecurity.Created;
import org.opensaml.soap.wssecurity.Password;
import org.opensaml.soap.wssecurity.Timestamp;
import org.opensaml.soap.wssecurity.Username;
import org.opensaml.soap.wssecurity.UsernameToken;
import org.opensaml.soap.wstrust.AllowPostdating;
import org.opensaml.soap.wstrust.AuthenticationType;
import org.opensaml.soap.wstrust.Authenticator;
import org.opensaml.soap.wstrust.BinaryExchange;
import org.opensaml.soap.wstrust.BinarySecret;
import org.opensaml.soap.wstrust.CancelTarget;
import org.opensaml.soap.wstrust.CanonicalizationAlgorithm;
import org.opensaml.soap.wstrust.Challenge;
import org.opensaml.soap.wstrust.Claims;
import org.opensaml.soap.wstrust.Code;
import org.opensaml.soap.wstrust.CombinedHash;
import org.opensaml.soap.wstrust.ComputedKey;
import org.opensaml.soap.wstrust.ComputedKeyAlgorithm;
import org.opensaml.soap.wstrust.Delegatable;
import org.opensaml.soap.wstrust.DelegateTo;
import org.opensaml.soap.wstrust.RequestSecurityToken;
import org.opensaml.soap.wstrust.RequestType;
import org.opensaml.soap.wstrust.TokenType;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class WSTrustObjectsTestCase
extends WSBaseTestCase {
    private static final QName TEST_CLAIMS_QNAME = new QName("urn:test:claims:ns", "TestClaim", "tc");

    @BeforeMethod
    protected void setUp() throws Exception {
        XMLObjectProviderRegistrySupport.registerObjectProvider((QName)TEST_CLAIMS_QNAME, (XMLObjectBuilder)new XSAnyBuilder(), (Marshaller)new XSAnyMarshaller(), (Unmarshaller)new XSAnyUnmarshaller());
    }

    @Test
    public void testAllowPostdating() throws Exception {
        AllowPostdating allowPostdating = (AllowPostdating)this.buildXMLObject(AllowPostdating.ELEMENT_NAME);
        this.marshallAndUnmarshall(allowPostdating);
    }

    @Test
    public void testAuthenticationType() throws Exception {
        AuthenticationType authenticationType = (AuthenticationType)this.buildXMLObject(AuthenticationType.ELEMENT_NAME);
        authenticationType.setValue("urn:mace:switch.ch:SWITCHaai:loa:3");
        this.marshallAndUnmarshall(authenticationType);
    }

    @Test
    public void testAuthenticator() throws Exception {
        Authenticator authenticator = (Authenticator)this.buildXMLObject(Authenticator.ELEMENT_NAME);
        CombinedHash combinedHash = this.createCombinedHash("asdfasdfasdASDFASDFDASasdfasASd");
        authenticator.setCombinedHash(combinedHash);
        this.marshallAndUnmarshall(authenticator);
    }

    @Test
    public void testBinaryExchange() throws Exception {
        BinaryExchange binaryExchange = (BinaryExchange)this.buildXMLObject(BinaryExchange.ELEMENT_NAME);
        binaryExchange.setValueType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3");
        binaryExchange.setValue("BASE64BINARY_X509_DATA...");
        this.marshallAndUnmarshall(binaryExchange);
    }

    @Test
    public void testBinarySecret() throws Exception {
        BinarySecret binarySecret = (BinarySecret)this.buildXMLObject(BinarySecret.ELEMENT_NAME);
        binarySecret.setType("http://docs.oasis-open.org/ws-sx/ws-trust/200512/SymmetricKey");
        binarySecret.setValue("BASE64BINARY_SYMMETRICKEY_DATA...\n...");
        this.marshallAndUnmarshall(binarySecret);
    }

    @Test
    public void testCancelTarget() throws Exception {
        CancelTarget cancelTarget = (CancelTarget)this.buildXMLObject(CancelTarget.ELEMENT_NAME);
        UsernameToken usernameToken = this.createUsernameToken("testuser", "testpassword");
        cancelTarget.setUnknownXMLObject((XMLObject)usernameToken);
        this.marshallAndUnmarshall(cancelTarget);
    }

    @Test
    public void testCanonicalizationAlgorithm() throws Exception {
        CanonicalizationAlgorithm canonicalizationAlgorithm = (CanonicalizationAlgorithm)this.buildXMLObject(CanonicalizationAlgorithm.ELEMENT_NAME);
        canonicalizationAlgorithm.setValue("CanonicalizationAlgorithmValue");
        this.marshallAndUnmarshall(canonicalizationAlgorithm);
    }

    @Test
    public void testChallenge() throws Exception {
        Challenge challenge = (Challenge)this.buildXMLObject(Challenge.ELEMENT_NAME);
        challenge.setValue("CHALLENGE_VALUE");
        this.marshallAndUnmarshall(challenge);
    }

    @Test
    public void testClaims() throws Exception {
        Claims claims = this.createClaims();
        this.marshallAndUnmarshall(claims);
    }

    @Test
    public void testCode() throws Exception {
        Code code = (Code)this.buildXMLObject(Code.ELEMENT_NAME);
        code.setValue("http://docs.oasis-open.org/ws-sx/ws-trust/200512/status/valid");
        this.marshallAndUnmarshall(code);
    }

    @Test
    public void testCombinedHash() throws Exception {
        CombinedHash combinedHash = this.createCombinedHash("ADSFJAKSLDFJASLKDFJALSKJkljasfiaskfjJASDFKLASdlf");
        this.marshallAndUnmarshall(combinedHash);
    }

    @Test
    public void testComputedKey() throws Exception {
        ComputedKey computedKey = (ComputedKey)this.buildXMLObject(ComputedKey.ELEMENT_NAME);
        computedKey.setValue("http://docs.oasis-open.org/ws-sx/ws-trust/200512/CK/PSHA1");
        this.marshallAndUnmarshall(computedKey);
    }

    @Test
    public void testComputedKeyAlgorithm() throws Exception {
        ComputedKeyAlgorithm computedKeyAlgorithm = (ComputedKeyAlgorithm)this.buildXMLObject(ComputedKeyAlgorithm.ELEMENT_NAME);
        computedKeyAlgorithm.setValue("ComputedKeyAlgorithmValue");
        this.marshallAndUnmarshall(computedKeyAlgorithm);
    }

    @Test
    public void testDelegatable() throws Exception {
        Delegatable delegatable = (Delegatable)this.buildXMLObject(Delegatable.ELEMENT_NAME);
        XSBooleanValue value = delegatable.getValue();
        Assert.assertFalse((boolean)value.getValue());
        this.marshallAndUnmarshall(delegatable);
        delegatable = (Delegatable)this.buildXMLObject(Delegatable.ELEMENT_NAME);
        delegatable.setValue(new XSBooleanValue(Boolean.valueOf(true), false));
        value = delegatable.getValue();
        Assert.assertTrue((boolean)value.getValue());
        this.marshallAndUnmarshall(delegatable);
    }

    @Test
    public void testDelegateTo() throws Exception {
        DelegateTo delegateTo = (DelegateTo)this.buildXMLObject(DelegateTo.ELEMENT_NAME);
        delegateTo.setUnknownXMLObject((XMLObject)this.createUsernameToken("delegateUser", "delegatePassord"));
        this.marshallAndUnmarshall(delegateTo);
    }

    @Test
    public void testEncryption() throws Exception {
    }

    @Test
    public void testEncryptionAlgorithm() throws Exception {
    }

    @Test
    public void testEncryptWith() throws Exception {
    }

    @Test
    public void testEntropy() throws Exception {
    }

    @Test
    public void testForwardable() throws Exception {
    }

    @Test
    public void testIssuedTokens() throws Exception {
    }

    @Test
    public void testIssuer() throws Exception {
    }

    @Test
    public void testKeyExchangeToken() throws Exception {
    }

    @Test
    public void testKeySize() throws Exception {
    }

    @Test
    public void testKeyType() throws Exception {
    }

    @Test
    public void testKeyWrapAlgorithm() throws Exception {
    }

    @Test
    public void testLifetime() throws Exception {
    }

    @Test
    public void testOnBehalfOf() throws Exception {
    }

    @Test
    public void testParticipant() throws Exception {
    }

    @Test
    public void testPrimary() throws Exception {
    }

    @Test
    public void testProofEncryption() throws Exception {
    }

    @Test
    public void testReason() throws Exception {
    }

    @Test
    public void testRenewing() throws Exception {
    }

    @Test
    public void testRenewTarget() throws Exception {
    }

    @Test
    public void testRequestedAttachedReference() throws Exception {
    }

    @Test
    public void testRequestedProofToken() throws Exception {
    }

    @Test
    public void testRequestedSecurityToken() throws Exception {
    }

    @Test
    public void testRequestedTokenCancelled() throws Exception {
    }

    @Test
    public void testRequestedUnattachedReference() throws Exception {
    }

    @Test
    public void testKET() throws Exception {
    }

    @Test
    public void testRequestSecurityToken() throws Exception {
        RequestSecurityToken rst = (RequestSecurityToken)this.buildXMLObject(RequestSecurityToken.ELEMENT_NAME);
        String context = "Context-" + System.currentTimeMillis();
        rst.setContext(context);
        RequestType requestType = (RequestType)this.buildXMLObject(RequestType.ELEMENT_NAME);
        requestType.setValue("http://docs.oasis-open.org/ws-sx/ws-trust/200512/Issue");
        rst.getUnknownXMLObjects().add(requestType);
        TokenType tokenType = (TokenType)this.buildXMLObject(TokenType.ELEMENT_NAME);
        tokenType.setValue("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0");
        rst.getUnknownXMLObjects().add(tokenType);
        Claims claims = this.createClaims();
        rst.getUnknownXMLObjects().add(claims);
        Timestamp timestamp = this.createTimestamp();
        rst.getUnknownXMLObjects().add(timestamp);
        this.marshallAndUnmarshall(rst);
        rst = (RequestSecurityToken)this.unmarshallElement("/org/opensaml/soap/wstrust/impl/RequestSecurityToken.xml");
        rst.releaseDOM();
        this.marshallAndUnmarshall(rst);
    }

    @Test
    public void testRequestSecurityTokenCollection() throws Exception {
    }

    @Test
    public void testRequestSecurityTokenResponse() throws Exception {
    }

    @Test
    public void testRequestSecurityTokenResponseCollection() throws Exception {
    }

    @Test
    public void testRequestType() throws Exception {
    }

    @Test
    public void testSignatureAlgorithm() throws Exception {
    }

    @Test
    public void testSignChallenge() throws Exception {
    }

    @Test
    public void testSignChallengeResponse() throws Exception {
    }

    @Test
    public void testSignWith() throws Exception {
    }

    @Test
    public void testStatus() throws Exception {
    }

    @Test
    public void testTokenType() throws Exception {
    }

    @Test
    public void testUseKey() throws Exception {
    }

    @Test
    public void testValidateTarget() throws Exception {
    }

    protected Claims createClaims() throws Exception {
        Claims claims = (Claims)this.buildXMLObject(Claims.ELEMENT_NAME);
        claims.setDialect("urn:test:claims:some-test-dialect");
        XSAny claimData = (XSAny)this.getBuilder(TEST_CLAIMS_QNAME).buildObject(TEST_CLAIMS_QNAME);
        claimData.setTextContent("urn:test:claims:attribute-bundle-Foo");
        claims.getUnknownXMLObjects().add(claimData);
        return claims;
    }

    protected Timestamp createTimestamp() throws Exception {
        Timestamp timestamp = (Timestamp)this.buildXMLObject(Timestamp.ELEMENT_NAME);
        Created created = (Created)this.buildXMLObject(Created.ELEMENT_NAME);
        created.setDateTime(new DateTime());
        timestamp.setCreated(created);
        return timestamp;
    }

    protected CombinedHash createCombinedHash(String value) throws Exception {
        CombinedHash combinedHash = (CombinedHash)this.buildXMLObject(CombinedHash.ELEMENT_NAME);
        if (value == null) {
            combinedHash.setValue("BASE64BINARY_CombinedHASH..");
        } else {
            combinedHash.setValue(value);
        }
        return combinedHash;
    }

    protected UsernameToken createUsernameToken(String user, String pass) throws Exception {
        UsernameToken usernameToken = (UsernameToken)this.buildXMLObject(UsernameToken.ELEMENT_NAME);
        Username username = (Username)this.buildXMLObject(Username.ELEMENT_NAME);
        username.setValue(user);
        Password password = (Password)this.buildXMLObject(Password.ELEMENT_NAME);
        password.setValue(pass);
        Created created = (Created)this.buildXMLObject(Created.ELEMENT_NAME);
        created.setDateTime(new DateTime());
        String id = "UsernameToken-" + System.currentTimeMillis();
        usernameToken.setWSUId(id);
        usernameToken.setUsername(username);
        usernameToken.getUnknownXMLObjects().add(password);
        usernameToken.getUnknownXMLObjects().add(created);
        return usernameToken;
    }
}

