/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.soap.wspolicy.impl;

import javax.xml.namespace.QName;
import org.opensaml.core.xml.XMLObjectBuilder;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.Marshaller;
import org.opensaml.core.xml.io.Unmarshaller;
import org.opensaml.core.xml.schema.XSAny;
import org.opensaml.core.xml.schema.impl.XSAnyBuilder;
import org.opensaml.core.xml.schema.impl.XSAnyMarshaller;
import org.opensaml.core.xml.schema.impl.XSAnyUnmarshaller;
import org.opensaml.soap.WSBaseTestCase;
import org.opensaml.soap.wspolicy.All;
import org.opensaml.soap.wspolicy.AppliesTo;
import org.opensaml.soap.wspolicy.ExactlyOne;
import org.opensaml.soap.wspolicy.Policy;
import org.opensaml.soap.wspolicy.PolicyAttachment;
import org.opensaml.soap.wspolicy.PolicyReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class WSPolicyObjectsTestCase
extends WSBaseTestCase {
    public Logger log = LoggerFactory.getLogger(WSPolicyObjectsTestCase.class);
    private static final QName TEST_ELEMENT_QNAME = new QName("urn:test:ns", "WildcardTest", "wct");

    @BeforeMethod
    protected void setUp() throws Exception {
        XMLObjectProviderRegistrySupport.registerObjectProvider((QName)TEST_ELEMENT_QNAME, (XMLObjectBuilder)new XSAnyBuilder(), (Marshaller)new XSAnyMarshaller(), (Unmarshaller)new XSAnyUnmarshaller());
    }

    @Test
    public void testAll() throws Exception {
        All all = (All)this.buildXMLObject(All.ELEMENT_NAME);
        all.getPolicies().add((Policy)this.buildXMLObject(Policy.ELEMENT_NAME));
        all.getAlls().add((All)this.buildXMLObject(All.ELEMENT_NAME));
        all.getExactlyOnes().add((ExactlyOne)this.buildXMLObject(ExactlyOne.ELEMENT_NAME));
        all.getPolicyReferences().add((PolicyReference)this.buildXMLObject(PolicyReference.ELEMENT_NAME));
        all.getPolicyReferences().add((PolicyReference)this.buildXMLObject(PolicyReference.ELEMENT_NAME));
        all.getPolicies().add((Policy)this.buildXMLObject(Policy.ELEMENT_NAME));
        all.getAlls().add((All)this.buildXMLObject(All.ELEMENT_NAME));
        all.getAlls().add((All)this.buildXMLObject(All.ELEMENT_NAME));
        all.getExactlyOnes().add((ExactlyOne)this.buildXMLObject(ExactlyOne.ELEMENT_NAME));
        this.marshallAndUnmarshall(all);
    }

    @Test
    public void testAppliesTo() throws Exception {
        AppliesTo appliesTo = (AppliesTo)this.buildXMLObject(AppliesTo.ELEMENT_NAME);
        QName wildAttribName = new QName("urn:test:ns:foo", "SomeAttribute", "test");
        appliesTo.getUnknownAttributes().put(wildAttribName, "foobar");
        QName wildAttribName2 = new QName("urn:test:ns:foo2", "AnotherAttribute", "test2");
        appliesTo.getUnknownAttributes().put(wildAttribName2, "another-foobar");
        XSAny testElement = (XSAny)this.getBuilder(TEST_ELEMENT_QNAME).buildObject(TEST_ELEMENT_QNAME);
        testElement.setTextContent("urn:test:some-obscure-data");
        appliesTo.getUnknownXMLObjects().add(testElement);
        testElement = (XSAny)this.getBuilder(TEST_ELEMENT_QNAME).buildObject(TEST_ELEMENT_QNAME);
        testElement.setTextContent("urn:test:some-other-obscure-data");
        appliesTo.getUnknownXMLObjects().add(testElement);
        this.marshallAndUnmarshall(appliesTo);
    }

    @Test
    public void testExactlyOne() throws Exception {
        ExactlyOne exactlyOne = (ExactlyOne)this.buildXMLObject(ExactlyOne.ELEMENT_NAME);
        exactlyOne.getPolicies().add((Policy)this.buildXMLObject(Policy.ELEMENT_NAME));
        exactlyOne.getAlls().add((All)this.buildXMLObject(All.ELEMENT_NAME));
        exactlyOne.getExactlyOnes().add((ExactlyOne)this.buildXMLObject(ExactlyOne.ELEMENT_NAME));
        exactlyOne.getPolicyReferences().add((PolicyReference)this.buildXMLObject(PolicyReference.ELEMENT_NAME));
        exactlyOne.getPolicyReferences().add((PolicyReference)this.buildXMLObject(PolicyReference.ELEMENT_NAME));
        exactlyOne.getPolicies().add((Policy)this.buildXMLObject(Policy.ELEMENT_NAME));
        exactlyOne.getAlls().add((All)this.buildXMLObject(All.ELEMENT_NAME));
        exactlyOne.getAlls().add((All)this.buildXMLObject(All.ELEMENT_NAME));
        exactlyOne.getExactlyOnes().add((ExactlyOne)this.buildXMLObject(ExactlyOne.ELEMENT_NAME));
        this.marshallAndUnmarshall(exactlyOne);
    }

    @Test
    public void testPolicy() throws Exception {
        Policy policy = (Policy)this.buildXMLObject(Policy.ELEMENT_NAME);
        policy.setName("urn:test:policy-name-foo");
        policy.setWSUId("abc123");
        QName wildAttribName = new QName("urn:test:ns:foo", "SomeAttribute", "test");
        policy.getUnknownAttributes().put(wildAttribName, "foobar");
        policy.getPolicies().add((Policy)this.buildXMLObject(Policy.ELEMENT_NAME));
        policy.getAlls().add((All)this.buildXMLObject(All.ELEMENT_NAME));
        policy.getExactlyOnes().add((ExactlyOne)this.buildXMLObject(ExactlyOne.ELEMENT_NAME));
        policy.getPolicyReferences().add((PolicyReference)this.buildXMLObject(PolicyReference.ELEMENT_NAME));
        policy.getPolicyReferences().add((PolicyReference)this.buildXMLObject(PolicyReference.ELEMENT_NAME));
        policy.getPolicies().add((Policy)this.buildXMLObject(Policy.ELEMENT_NAME));
        policy.getAlls().add((All)this.buildXMLObject(All.ELEMENT_NAME));
        policy.getAlls().add((All)this.buildXMLObject(All.ELEMENT_NAME));
        policy.getExactlyOnes().add((ExactlyOne)this.buildXMLObject(ExactlyOne.ELEMENT_NAME));
        this.marshallAndUnmarshall(policy);
    }

    @Test
    public void testPolicyAttachment() throws Exception {
        PolicyAttachment policyAttachment = (PolicyAttachment)this.buildXMLObject(PolicyAttachment.ELEMENT_NAME);
        QName wildAttribName = new QName("urn:test:ns:foo", "SomeAttribute", "test");
        policyAttachment.getUnknownAttributes().put(wildAttribName, "foobar");
        QName wildAttribName2 = new QName("urn:test:ns:foo2", "AnotherAttribute", "test2");
        policyAttachment.getUnknownAttributes().put(wildAttribName2, "another-foobar");
        policyAttachment.setAppliesTo((AppliesTo)this.buildXMLObject(AppliesTo.ELEMENT_NAME));
        policyAttachment.getPolicies().add((Policy)this.buildXMLObject(Policy.ELEMENT_NAME));
        policyAttachment.getPolicies().add((Policy)this.buildXMLObject(Policy.ELEMENT_NAME));
        policyAttachment.getPolicyReferences().add((PolicyReference)this.buildXMLObject(PolicyReference.ELEMENT_NAME));
        policyAttachment.getPolicies().add((Policy)this.buildXMLObject(Policy.ELEMENT_NAME));
        policyAttachment.getPolicyReferences().add((PolicyReference)this.buildXMLObject(PolicyReference.ELEMENT_NAME));
        XSAny testElement = (XSAny)this.getBuilder(TEST_ELEMENT_QNAME).buildObject(TEST_ELEMENT_QNAME);
        testElement.setTextContent("urn:test:some-obscure-data");
        policyAttachment.getUnknownXMLObjects().add(testElement);
        testElement = (XSAny)this.getBuilder(TEST_ELEMENT_QNAME).buildObject(TEST_ELEMENT_QNAME);
        testElement.setTextContent("urn:test:some-other-obscure-data");
        policyAttachment.getUnknownXMLObjects().add(testElement);
        this.marshallAndUnmarshall(policyAttachment);
    }

    @Test
    public void testPolicyReference() throws Exception {
        PolicyReference policyReference = (PolicyReference)this.buildXMLObject(PolicyReference.ELEMENT_NAME);
        policyReference.setURI("urn:test:policyRefFoo");
        policyReference.setDigest("digestdata");
        policyReference.setDigestAlgorithm("http://schemas.xmlsoap.org/ws/2004/09/policy/Sha1Exc");
        QName wildAttribName = new QName("urn:test:ns:foo", "SomeAttribute", "test");
        policyReference.getUnknownAttributes().put(wildAttribName, "foobar");
        QName wildAttribName2 = new QName("urn:test:ns:foo2", "AnotherAttribute", "test2");
        policyReference.getUnknownAttributes().put(wildAttribName2, "another-foobar");
        this.marshallAndUnmarshall(policyReference);
    }
}

