/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.soap.wsaddressing.messaging.impl;

import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.soap.SOAPMessagingBaseTestCase;
import org.opensaml.soap.messaging.SOAPMessagingSupport;
import org.opensaml.soap.wsaddressing.MessageID;
import org.opensaml.soap.wsaddressing.messaging.WSAddressingContext;
import org.opensaml.soap.wsaddressing.messaging.impl.ExtractMessageIDHandler;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ExtractMessageIDHandlerTest
extends SOAPMessagingBaseTestCase {
    private ExtractMessageIDHandler handler;

    @BeforeMethod
    protected void setUp() throws ComponentInitializationException {
        this.handler = new ExtractMessageIDHandler();
    }

    @Test
    public void testHeaderPresent() throws ComponentInitializationException, MessageHandlerException {
        MessageID messageID = (MessageID)this.buildXMLObject(MessageID.ELEMENT_NAME);
        messageID.setValue("abc123");
        SOAPMessagingSupport.addHeaderBlock(this.getMessageContext(), (XMLObject)messageID);
        this.handler.initialize();
        this.handler.invoke(this.getMessageContext());
        Assert.assertEquals((String)((WSAddressingContext)this.getMessageContext().getSubcontext(WSAddressingContext.class, true)).getMessageIDURI(), (String)"abc123");
        Assert.assertTrue((boolean)SOAPMessagingSupport.checkUnderstoodHeader(this.getMessageContext(), (XMLObject)messageID));
    }

    @Test
    public void testHeaderAbsent() throws ComponentInitializationException, MessageHandlerException {
        this.handler.initialize();
        this.handler.invoke(this.getMessageContext());
        Assert.assertNull((Object)this.getMessageContext().getSubcontext(WSAddressingContext.class, false));
        Assert.assertTrue((boolean)SOAPMessagingSupport.getInboundSOAPContext(this.getMessageContext()).getUnderstoodHeaders().isEmpty());
    }
}

