/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.messaging.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.AbstractMessageHandler;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.security.SecurityException;
import org.opensaml.security.trust.TrustEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseTrustEngineSecurityHandler<TokenType, MessageType>
extends AbstractMessageHandler<MessageType> {
    private final Logger log = LoggerFactory.getLogger(BaseTrustEngineSecurityHandler.class);
    private TrustEngine<TokenType> trustEngine;

    protected TrustEngine<TokenType> getTrustEngine() {
        return this.trustEngine;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
    }

    protected boolean doPreInvoke(MessageContext<MessageType> messageContext) throws MessageHandlerException {
        TrustEngine<TokenType> engine = this.resolveTrustEngine(messageContext);
        if (engine == null) {
            throw new MessageHandlerException("TrustEngine could not be resolved from MessageContext");
        }
        this.trustEngine = engine;
        return super.doPreInvoke(messageContext);
    }

    @Nullable
    protected abstract TrustEngine<TokenType> resolveTrustEngine(MessageContext<MessageType> var1);

    @Nonnull
    protected abstract CriteriaSet buildCriteriaSet(String var1, MessageContext<MessageType> var2) throws MessageHandlerException;

    protected boolean evaluate(TokenType token, String entityID, MessageContext<MessageType> messageContext) throws MessageHandlerException {
        CriteriaSet criteriaSet = this.buildCriteriaSet(entityID, messageContext);
        if (criteriaSet == null) {
            this.log.error("{} Returned criteria set was null, can not perform trust engine evaluation of token", (Object)this.getLogPrefix());
            throw new MessageHandlerException("Returned criteria set was null");
        }
        return this.evaluate(token, criteriaSet);
    }

    protected boolean evaluate(TokenType token, CriteriaSet criteriaSet) throws MessageHandlerException {
        try {
            return this.getTrustEngine().validate(token, criteriaSet);
        }
        catch (SecurityException e) {
            this.log.error("{} There was an error evaluating the request's token using the trust engine", (Object)this.getLogPrefix(), (Object)e);
            throw new MessageHandlerException("Error during trust engine evaluation of the token", (Exception)((Object)e));
        }
    }
}

