/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.crypto.ec;

import java.security.KeyPairGenerator;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.opensaml.security.crypto.ec.BaseNamedCurveTest;
import org.opensaml.security.crypto.ec.ECSupport;
import org.opensaml.security.crypto.ec.EnhancedECParameterSpec;
import org.testng.Assert;
import org.testng.annotations.Test;

public class EnhancedECParameterSpecTest
extends BaseNamedCurveTest {
    @Test(dataProvider="namedCurves")
    public void hashCodeAndEquals(String name) throws Exception {
        ECParameterSpec controlInput = ECSupport.convert((ECNamedCurveParameterSpec)ECNamedCurveTable.getParameterSpec((String)name));
        Assert.assertNotNull((Object)controlInput);
        EnhancedECParameterSpec control = new EnhancedECParameterSpec(controlInput);
        for (int i = 0; i < 25; ++i) {
            KeyPairGenerator kpg = KeyPairGenerator.getInstance("EC");
            kpg.initialize(new ECGenParameterSpec(name));
            EnhancedECParameterSpec target = new EnhancedECParameterSpec(((ECPublicKey)ECPublicKey.class.cast(kpg.generateKeyPair().getPublic())).getParams());
            Assert.assertNotSame((Object)target.getOriginal(), (Object)control.getOriginal());
            Assert.assertNotEquals((Object)target.getOriginal(), (Object)control.getOriginal());
            Assert.assertNotSame((Object)target, (Object)control);
            Assert.assertEquals((Object)target, (Object)control);
            Assert.assertEquals((int)target.hashCode(), (int)target.hashCode());
        }
    }
}

