/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.metadata.impl;

import com.google.common.base.Strings;
import javax.annotation.Nonnull;
import net.shibboleth.shared.xml.DOMTypeSupport;
import org.opensaml.core.xml.AttributeExtensibleXMLObject;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.saml.common.AbstractSAMLObjectUnmarshaller;
import org.opensaml.saml.saml2.metadata.AdditionalMetadataLocation;
import org.opensaml.saml.saml2.metadata.AffiliationDescriptor;
import org.opensaml.saml.saml2.metadata.ContactPerson;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.Extensions;
import org.opensaml.saml.saml2.metadata.Organization;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.opensaml.xmlsec.signature.Signature;
import org.w3c.dom.Attr;

public class EntityDescriptorUnmarshaller
extends AbstractSAMLObjectUnmarshaller {
    protected void processChildElement(@Nonnull XMLObject parentObject, @Nonnull XMLObject childObject) throws UnmarshallingException {
        EntityDescriptor entityDescriptor = (EntityDescriptor)parentObject;
        if (childObject instanceof Extensions) {
            entityDescriptor.setExtensions((Extensions)childObject);
        } else if (childObject instanceof Signature) {
            entityDescriptor.setSignature((Signature)childObject);
        } else if (childObject instanceof RoleDescriptor) {
            entityDescriptor.getRoleDescriptors().add((RoleDescriptor)childObject);
        } else if (childObject instanceof AffiliationDescriptor) {
            entityDescriptor.setAffiliationDescriptor((AffiliationDescriptor)childObject);
        } else if (childObject instanceof Organization) {
            entityDescriptor.setOrganization((Organization)childObject);
        } else if (childObject instanceof ContactPerson) {
            entityDescriptor.getContactPersons().add((ContactPerson)childObject);
        } else if (childObject instanceof AdditionalMetadataLocation) {
            entityDescriptor.getAdditionalMetadataLocations().add((AdditionalMetadataLocation)childObject);
        } else {
            super.processChildElement(parentObject, childObject);
        }
    }

    protected void processAttribute(@Nonnull XMLObject xmlObject, @Nonnull Attr attribute) throws UnmarshallingException {
        EntityDescriptor entityDescriptor = (EntityDescriptor)xmlObject;
        if (attribute.getNamespaceURI() == null) {
            if (attribute.getLocalName().equals("entityID")) {
                entityDescriptor.setEntityID(attribute.getValue());
            } else if (attribute.getLocalName().equals("ID")) {
                entityDescriptor.setID(attribute.getValue());
                attribute.getOwnerElement().setIdAttributeNode(attribute, true);
            } else if (attribute.getLocalName().equals("validUntil") && !Strings.isNullOrEmpty((String)attribute.getValue())) {
                entityDescriptor.setValidUntil(DOMTypeSupport.stringToInstant((String)attribute.getValue()));
            } else if (attribute.getLocalName().equals("cacheDuration")) {
                entityDescriptor.setCacheDuration(DOMTypeSupport.stringToDuration((String)attribute.getValue()));
            } else {
                super.processAttribute(xmlObject, attribute);
            }
        } else {
            this.processUnknownAttribute((AttributeExtensibleXMLObject)entityDescriptor, attribute);
        }
    }
}

