/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.filter.impl;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.component.AbstractInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.ext.saml2mdattr.EntityAttributes;
import org.opensaml.saml.metadata.resolver.filter.FilterException;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilter;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilterContext;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.metadata.EntitiesDescriptor;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.Extensions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityAttributesFilter
extends AbstractInitializableComponent
implements MetadataFilter {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(EntityAttributesFilter.class);
    @Nonnull
    @NonnullElements
    private Multimap<Predicate<EntityDescriptor>, Attribute> applyMap;
    @Nullable
    private Predicate<Attribute> attributeFilter;
    @Nonnull
    private final SAMLObjectBuilder<Extensions> extBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(Extensions.DEFAULT_ELEMENT_NAME);
    @Nonnull
    private final SAMLObjectBuilder<EntityAttributes> entityAttributesBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(EntityAttributes.DEFAULT_ELEMENT_NAME);

    public EntityAttributesFilter() {
        this.applyMap = ArrayListMultimap.create();
    }

    public void setRules(@Nonnull @NonnullElements Map<Predicate<EntityDescriptor>, Collection<Attribute>> rules) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        Constraint.isNotNull(rules, (String)"Rules map cannot be null");
        this.applyMap = ArrayListMultimap.create((int)rules.size(), (int)1);
        for (Map.Entry<Predicate<EntityDescriptor>, Collection<Attribute>> entry : rules.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            this.applyMap.putAll(entry.getKey(), List.copyOf(entry.getValue()));
        }
    }

    public void setAttributeFilter(@Nullable Predicate<Attribute> condition) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.attributeFilter = condition;
    }

    @Nullable
    public XMLObject filter(@Nullable XMLObject metadata, @Nonnull MetadataFilterContext context) throws FilterException {
        if (metadata == null) {
            return null;
        }
        if (metadata instanceof EntitiesDescriptor) {
            this.filterEntitiesDescriptor((EntitiesDescriptor)metadata);
        } else {
            this.filterEntityDescriptor((EntityDescriptor)metadata);
        }
        return metadata;
    }

    protected void filterEntityDescriptor(@Nonnull EntityDescriptor descriptor) {
        if (this.attributeFilter != null) {
            this.applyFilter(descriptor);
        }
        for (Map.Entry entry : this.applyMap.asMap().entrySet()) {
            List entityAttributesCollection;
            if (((Collection)entry.getValue()).isEmpty() || !((Predicate)entry.getKey()).test(descriptor)) continue;
            Extensions extensions = descriptor.getExtensions();
            if (extensions == null) {
                extensions = (Extensions)this.extBuilder.buildObject();
                descriptor.setExtensions(extensions);
            }
            if ((entityAttributesCollection = extensions.getUnknownXMLObjects(EntityAttributes.DEFAULT_ELEMENT_NAME)).isEmpty()) {
                entityAttributesCollection.add(this.entityAttributesBuilder.buildObject());
            }
            EntityAttributes entityAttributes = (EntityAttributes)entityAttributesCollection.iterator().next();
            for (Attribute attribute : (Collection)entry.getValue()) {
                try {
                    this.log.info("Adding EntityAttribute ({}) to EntityDescriptor ({})", (Object)attribute.getName(), (Object)descriptor.getEntityID());
                    Attribute copy = (Attribute)XMLObjectSupport.cloneXMLObject((XMLObject)attribute);
                    entityAttributes.getAttributes().add(copy);
                }
                catch (MarshallingException | UnmarshallingException e) {
                    this.log.error("Error cloning Attribute", e);
                }
            }
        }
    }

    protected void filterEntitiesDescriptor(@Nonnull EntitiesDescriptor descriptor) {
        for (EntitiesDescriptor group : descriptor.getEntitiesDescriptors()) {
            this.filterEntitiesDescriptor(group);
        }
        for (EntityDescriptor entity : descriptor.getEntityDescriptors()) {
            this.filterEntityDescriptor(entity);
        }
    }

    @Nullable
    private void applyFilter(@Nonnull EntityDescriptor descriptor) {
        List entityAttributesCollection;
        Extensions ext = descriptor.getExtensions();
        if (ext != null && !(entityAttributesCollection = ext.getUnknownXMLObjects(EntityAttributes.DEFAULT_ELEMENT_NAME)).isEmpty()) {
            EntityAttributes entityAttributes = (EntityAttributes)entityAttributesCollection.iterator().next();
            List attributes = entityAttributes.getEntityAttributesChildren();
            Iterator iter = attributes.iterator();
            while (iter.hasNext()) {
                SAMLObject attribute = (SAMLObject)iter.next();
                if (!(attribute instanceof Attribute) || this.attributeFilter.test((Attribute)attribute)) continue;
                this.log.warn("Filtering pre-existing attribute '{}' from entity '{}'", (Object)((Attribute)attribute).getName(), (Object)descriptor.getEntityID());
                iter.remove();
            }
        }
    }
}

