/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.filter.impl;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.component.AbstractInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.ext.saml2alg.DigestMethod;
import org.opensaml.saml.ext.saml2alg.SigningMethod;
import org.opensaml.saml.metadata.resolver.filter.FilterException;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilter;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilterContext;
import org.opensaml.saml.saml2.metadata.EncryptionMethod;
import org.opensaml.saml.saml2.metadata.EntitiesDescriptor;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.Extensions;
import org.opensaml.saml.saml2.metadata.KeyDescriptor;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.opensaml.security.credential.UsageType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlgorithmFilter
extends AbstractInitializableComponent
implements MetadataFilter {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AlgorithmFilter.class);
    @Nonnull
    @NonnullElements
    private Multimap<Predicate<EntityDescriptor>, XMLObject> applyMap;
    @Nonnull
    private final SAMLObjectBuilder<Extensions> extBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(Extensions.DEFAULT_ELEMENT_NAME);

    public AlgorithmFilter() {
        this.applyMap = ArrayListMultimap.create();
    }

    public void setRules(@Nonnull @NonnullElements Map<Predicate<EntityDescriptor>, Collection<XMLObject>> rules) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        Constraint.isNotNull(rules, (String)"Rules map cannot be null");
        this.applyMap = ArrayListMultimap.create((int)rules.size(), (int)1);
        for (Map.Entry<Predicate<EntityDescriptor>, Collection<XMLObject>> entry : rules.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            this.applyMap.putAll(entry.getKey(), List.copyOf(entry.getValue()));
        }
    }

    @Nullable
    public XMLObject filter(@Nullable XMLObject metadata, @Nonnull MetadataFilterContext context) throws FilterException {
        if (metadata == null) {
            return null;
        }
        if (metadata instanceof EntitiesDescriptor) {
            this.filterEntitiesDescriptor((EntitiesDescriptor)metadata);
        } else {
            this.filterEntityDescriptor((EntityDescriptor)metadata);
        }
        return metadata;
    }

    protected void filterEntityDescriptor(@Nonnull EntityDescriptor descriptor) {
        for (Map.Entry entry : this.applyMap.asMap().entrySet()) {
            if (((Collection)entry.getValue()).isEmpty() || !((Predicate)entry.getKey()).test(descriptor)) continue;
            for (XMLObject xmlObject : (Collection)entry.getValue()) {
                try {
                    if (xmlObject instanceof DigestMethod) {
                        this.log.info("Adding DigestMethod ({}) to EntityDescriptor ({})", (Object)((DigestMethod)xmlObject).getAlgorithm(), (Object)descriptor.getEntityID());
                        this.getExtensions(descriptor).getUnknownXMLObjects().add(XMLObjectSupport.cloneXMLObject((XMLObject)xmlObject));
                        continue;
                    }
                    if (xmlObject instanceof SigningMethod) {
                        this.log.info("Adding SigningMethod ({}) to EntityDescriptor ({})", (Object)((SigningMethod)xmlObject).getAlgorithm(), (Object)descriptor.getEntityID());
                        this.getExtensions(descriptor).getUnknownXMLObjects().add(XMLObjectSupport.cloneXMLObject((XMLObject)xmlObject));
                        continue;
                    }
                    if (!(xmlObject instanceof EncryptionMethod)) continue;
                    this.log.info("Adding EncryptionMethod ({}) to EntityDescriptor ({})", (Object)((EncryptionMethod)xmlObject).getAlgorithm(), (Object)descriptor.getEntityID());
                    this.addEncryptionMethod(descriptor, (EncryptionMethod)xmlObject);
                }
                catch (MarshallingException | UnmarshallingException e) {
                    this.log.error("Error cloning XMLObject", e);
                }
            }
        }
    }

    protected void filterEntitiesDescriptor(@Nonnull EntitiesDescriptor descriptor) {
        for (EntitiesDescriptor group : descriptor.getEntitiesDescriptors()) {
            this.filterEntitiesDescriptor(group);
        }
        for (EntityDescriptor entity : descriptor.getEntityDescriptors()) {
            this.filterEntityDescriptor(entity);
        }
    }

    @Nonnull
    protected Extensions getExtensions(@Nonnull EntityDescriptor descriptor) {
        Extensions extensions = descriptor.getExtensions();
        if (extensions == null) {
            extensions = (Extensions)this.extBuilder.buildObject();
            descriptor.setExtensions(extensions);
        }
        return extensions;
    }

    protected void addEncryptionMethod(@Nonnull EntityDescriptor descriptor, @Nonnull EncryptionMethod encryptionMethod) {
        for (RoleDescriptor role : descriptor.getRoleDescriptors()) {
            for (KeyDescriptor key : role.getKeyDescriptors()) {
                if (key.getUse() != null && key.getUse() == UsageType.SIGNING) continue;
                try {
                    key.getEncryptionMethods().add((EncryptionMethod)XMLObjectSupport.cloneXMLObject((XMLObject)encryptionMethod));
                }
                catch (MarshallingException | UnmarshallingException e) {
                    this.log.error("Error cloning XMLObject", e);
                }
            }
        }
    }
}

