/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.wssecurity.messaging.impl;

import com.google.common.base.Function;
import java.io.File;
import java.net.URISyntaxException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Set;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import net.shibboleth.utilities.java.support.collection.Pair;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.core.xml.XMLObjectBaseTestCase;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.saml.common.assertion.ValidationContext;
import org.opensaml.saml.common.messaging.context.SAMLSelfEntityContext;
import org.opensaml.saml.criterion.EntityRoleCriterion;
import org.opensaml.saml.criterion.ProtocolCriterion;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml.saml2.profile.SAML2ActionTestingSupport;
import org.opensaml.saml.saml2.wssecurity.messaging.impl.DefaultSAML20AssertionValidationContextBuilder;
import org.opensaml.saml.saml2.wssecurity.messaging.impl.SAML20AssertionTokenValidationInput;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.criteria.UsageCriterion;
import org.opensaml.security.x509.X509Support;
import org.springframework.mock.web.MockHttpServletRequest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class DefaultSAML20AssertionValidationContextBuilderTest
extends XMLObjectBaseTestCase {
    private DefaultSAML20AssertionValidationContextBuilder builder;
    private SAML20AssertionTokenValidationInput input;
    private String issuerEntityID = "https://idp.example.org";
    private String rpEntityID = "https://rp.example.com";
    private String requestURL = "https://rp.example.com/wss/saml";
    private String remoteAddr = "10.1.2.3";
    private X509Certificate clientTLSCert;

    @BeforeMethod
    protected void setUp() throws URISyntaxException, CertificateException {
        this.builder = new DefaultSAML20AssertionValidationContextBuilder();
        this.input = new SAML20AssertionTokenValidationInput(this.buildMessageContext(), this.buildHttpServletRequest(), this.buildAssertion());
    }

    @Test
    public void testDefaults() {
        ValidationContext context = this.builder.apply(this.input);
        Assert.assertNotNull((Object)context);
        Assert.assertEquals(context.getStaticParameters().get("saml2.SignatureRequired"), (Object)Boolean.TRUE);
        CriteriaSet signatureCriteriaSet = (CriteriaSet)context.getStaticParameters().get("saml2.SignatureValidationCriteriaSet");
        Assert.assertEquals((int)signatureCriteriaSet.size(), (int)2);
        Assert.assertTrue((boolean)signatureCriteriaSet.contains(EntityIdCriterion.class));
        Assert.assertEquals((String)((EntityIdCriterion)signatureCriteriaSet.get(EntityIdCriterion.class)).getEntityId(), (String)this.issuerEntityID);
        Assert.assertTrue((boolean)signatureCriteriaSet.contains(UsageCriterion.class));
        Assert.assertEquals((Object)((UsageCriterion)signatureCriteriaSet.get(UsageCriterion.class)).getUsage(), (Object)UsageType.SIGNING);
        Assert.assertEquals(context.getStaticParameters().get("saml2.SubjectConfirmation.HoK.PresenterCertificate"), (Object)this.clientTLSCert);
        Assert.assertEquals(context.getStaticParameters().get("saml2.SubjectConfirmation.HoK.PresenterKey"), null);
        Set validRecipients = (Set)context.getStaticParameters().get("saml2.SubjectConfirmation.ValidRecipients");
        Assert.assertEquals((int)validRecipients.size(), (int)2);
        Assert.assertTrue((boolean)validRecipients.contains(this.requestURL));
        Assert.assertTrue((boolean)validRecipients.contains(this.rpEntityID));
        Set validAudiences = (Set)context.getStaticParameters().get("saml2.Conditions.ValidAudiences");
        Assert.assertEquals((int)validAudiences.size(), (int)1);
        Assert.assertTrue((boolean)validAudiences.contains(this.rpEntityID));
    }

    @Test
    public void testCustom() {
        this.builder.setSignatureRequired(false);
        this.builder.setSignatureCriteriaSetFunction((Function)new Function<Pair<MessageContext, Assertion>, CriteriaSet>(){

            @Nullable
            public CriteriaSet apply(@Nullable Pair<MessageContext, Assertion> input) {
                CriteriaSet criteria = new CriteriaSet();
                criteria.add((Object)new EntityRoleCriterion(IDPSSODescriptor.DEFAULT_ELEMENT_NAME));
                criteria.add((Object)new ProtocolCriterion("urn:oasis:names:tc:SAML:2.0:protocol"));
                return criteria;
            }
        });
        ValidationContext context = this.builder.apply(this.input);
        Assert.assertNotNull((Object)context);
        Assert.assertEquals(context.getStaticParameters().get("saml2.SignatureRequired"), (Object)Boolean.FALSE);
        CriteriaSet signatureCriteriaSet = (CriteriaSet)context.getStaticParameters().get("saml2.SignatureValidationCriteriaSet");
        Assert.assertEquals((int)signatureCriteriaSet.size(), (int)4);
        Assert.assertTrue((boolean)signatureCriteriaSet.contains(EntityIdCriterion.class));
        Assert.assertEquals((String)((EntityIdCriterion)signatureCriteriaSet.get(EntityIdCriterion.class)).getEntityId(), (String)this.issuerEntityID);
        Assert.assertTrue((boolean)signatureCriteriaSet.contains(UsageCriterion.class));
        Assert.assertEquals((Object)((UsageCriterion)signatureCriteriaSet.get(UsageCriterion.class)).getUsage(), (Object)UsageType.SIGNING);
        Assert.assertTrue((boolean)signatureCriteriaSet.contains(EntityRoleCriterion.class));
        Assert.assertEquals((Object)((EntityRoleCriterion)signatureCriteriaSet.get(EntityRoleCriterion.class)).getRole(), (Object)IDPSSODescriptor.DEFAULT_ELEMENT_NAME);
        Assert.assertTrue((boolean)signatureCriteriaSet.contains(ProtocolCriterion.class));
        Assert.assertEquals((String)((ProtocolCriterion)signatureCriteriaSet.get(ProtocolCriterion.class)).getProtocol(), (String)"urn:oasis:names:tc:SAML:2.0:protocol");
        Assert.assertEquals(context.getStaticParameters().get("saml2.SubjectConfirmation.HoK.PresenterCertificate"), (Object)this.clientTLSCert);
        Assert.assertEquals(context.getStaticParameters().get("saml2.SubjectConfirmation.HoK.PresenterKey"), null);
        Set validRecipients = (Set)context.getStaticParameters().get("saml2.SubjectConfirmation.ValidRecipients");
        Assert.assertEquals((int)validRecipients.size(), (int)2);
        Assert.assertTrue((boolean)validRecipients.contains(this.requestURL));
        Assert.assertTrue((boolean)validRecipients.contains(this.rpEntityID));
        Set validAudiences = (Set)context.getStaticParameters().get("saml2.Conditions.ValidAudiences");
        Assert.assertEquals((int)validAudiences.size(), (int)1);
        Assert.assertTrue((boolean)validAudiences.contains(this.rpEntityID));
    }

    private MessageContext<?> buildMessageContext() {
        MessageContext messageContext = new MessageContext();
        ((SAMLSelfEntityContext)messageContext.getSubcontext(SAMLSelfEntityContext.class, true)).setEntityId(this.rpEntityID);
        return messageContext;
    }

    private HttpServletRequest buildHttpServletRequest() throws URISyntaxException, CertificateException {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setScheme("https");
        request.setServerName("rp.example.com");
        request.setServerPort(443);
        request.setRequestURI("/wss/saml");
        request.setRemoteAddr(this.remoteAddr);
        File presenterCertFile = new File(((Object)((Object)this)).getClass().getResource("/org/opensaml/saml/saml2/wssecurity/messaging/impl/presenter.crt").toURI());
        this.clientTLSCert = X509Support.decodeCertificate((File)presenterCertFile);
        request.setAttribute("javax.servlet.request.X509Certificate", (Object)new X509Certificate[]{this.clientTLSCert});
        return request;
    }

    private Assertion buildAssertion() {
        Assertion assertion = SAML2ActionTestingSupport.buildAssertion();
        assertion.setSubject(SAML2ActionTestingSupport.buildSubject((String)"barney"));
        assertion.setIssuer(SAML2ActionTestingSupport.buildIssuer((String)this.issuerEntityID));
        return assertion;
    }
}

