/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.profile.impl;

import com.google.common.base.Strings;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.core.OpenSAMLInitBaseTestCase;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.profile.RequestContextBuilder;
import org.opensaml.profile.action.ActionTestingSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.opensaml.saml.saml2.core.EncryptedAttribute;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.profile.SAML2ActionTestingSupport;
import org.opensaml.saml.saml2.profile.context.EncryptionContext;
import org.opensaml.saml.saml2.profile.impl.EncryptAttributes;
import org.opensaml.xmlsec.EncryptionParameters;
import org.opensaml.xmlsec.algorithm.AlgorithmSupport;
import org.opensaml.xmlsec.encryption.support.EncryptionException;
import org.opensaml.xmlsec.keyinfo.impl.BasicKeyInfoGeneratorFactory;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class EncryptAttributesTest
extends OpenSAMLInitBaseTestCase {
    private SAMLObjectBuilder<Attribute> builder;
    private EncryptionParameters encParams;
    private ProfileRequestContext<Object, Response> prc;
    private EncryptAttributes action;

    @BeforeClass
    public void setUpClass() {
        this.builder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(Attribute.DEFAULT_ELEMENT_NAME);
    }

    @BeforeMethod
    public void setUp() throws NoSuchAlgorithmException, NoSuchProviderException {
        BasicKeyInfoGeneratorFactory generator = new BasicKeyInfoGeneratorFactory();
        generator.setEmitPublicKeyValue(true);
        this.encParams = new EncryptionParameters();
        this.encParams.setDataEncryptionAlgorithm("http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        this.encParams.setDataKeyInfoGenerator(generator.newInstance());
        this.encParams.setKeyTransportEncryptionAlgorithm("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p");
        this.encParams.setKeyTransportEncryptionCredential(AlgorithmSupport.generateKeyPairAndCredential((String)"http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p", (int)1024, (boolean)false));
        this.encParams.setKeyTransportKeyInfoGenerator(generator.newInstance());
        this.prc = new RequestContextBuilder().buildProfileRequestContext();
        ((EncryptionContext)this.prc.getOutboundMessageContext().getSubcontext(EncryptionContext.class, true)).setAttributeEncryptionParameters(this.encParams);
        this.action = new EncryptAttributes();
    }

    @Test
    public void testEmptyMessage() throws ComponentInitializationException {
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent(this.prc);
        this.prc.getOutboundMessageContext().setMessage((Object)SAML2ActionTestingSupport.buildResponse());
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent(this.prc);
    }

    @Test
    public void testEncryptedAttributes() throws EncryptionException, ComponentInitializationException, MarshallingException {
        Response response = SAML2ActionTestingSupport.buildResponse();
        this.prc.getOutboundMessageContext().setMessage((Object)response);
        response.getAssertions().add(SAML2ActionTestingSupport.buildAssertion());
        AttributeStatement statement = SAML2ActionTestingSupport.buildAttributeStatement();
        ((Assertion)response.getAssertions().get(0)).getAttributeStatements().add(statement);
        statement.getAttributes().add(this.builder.buildObject());
        statement.getAttributes().add(this.builder.buildObject());
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent(this.prc);
        Assert.assertEquals((int)statement.getEncryptedAttributes().size(), (int)2);
        EncryptedAttribute encTarget = (EncryptedAttribute)statement.getEncryptedAttributes().get(0);
        Assert.assertEquals((String)encTarget.getEncryptedData().getType(), (String)"http://www.w3.org/2001/04/xmlenc#Element", (String)"Type attribute");
        Assert.assertEquals((String)encTarget.getEncryptedData().getEncryptionMethod().getAlgorithm(), (String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc", (String)"Algorithm attribute");
        Assert.assertNotNull((Object)encTarget.getEncryptedData().getKeyInfo(), (String)"KeyInfo");
        Assert.assertEquals((int)encTarget.getEncryptedData().getKeyInfo().getEncryptedKeys().size(), (int)1, (String)"Number of EncryptedKeys");
        Assert.assertFalse((boolean)Strings.isNullOrEmpty((String)encTarget.getEncryptedData().getID()), (String)"EncryptedData ID attribute was empty");
    }

    @Test
    public void testFailure() throws EncryptionException, ComponentInitializationException, MarshallingException {
        Response response = SAML2ActionTestingSupport.buildResponse();
        this.prc.getOutboundMessageContext().setMessage((Object)response);
        response.getAssertions().add(SAML2ActionTestingSupport.buildAssertion());
        AttributeStatement statement = SAML2ActionTestingSupport.buildAttributeStatement();
        ((Assertion)response.getAssertions().get(0)).getAttributeStatements().add(statement);
        statement.getAttributes().add(this.builder.buildObject());
        statement.getAttributes().add(this.builder.buildObject());
        this.action.initialize();
        this.encParams.setKeyTransportEncryptionCredential(null);
        this.action.execute(this.prc);
        ActionTestingSupport.assertEvent(this.prc, (Object)"UnableToEncrypt");
        Assert.assertEquals((int)statement.getAttributes().size(), (int)2);
        Assert.assertEquals((int)statement.getEncryptedAttributes().size(), (int)0);
    }
}

