/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.metadata.impl;

import java.util.ArrayList;
import java.util.Collection;
import javax.xml.namespace.QName;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.chrono.ISOChronology;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.saml.saml2.metadata.AssertionIDRequestService;
import org.opensaml.saml.saml2.metadata.AuthzService;
import org.opensaml.saml.saml2.metadata.Extensions;
import org.opensaml.saml.saml2.metadata.NameIDFormat;
import org.opensaml.saml.saml2.metadata.PDPDescriptor;
import org.opensaml.saml.saml2.metadata.impl.PDPDescriptorBuilder;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class PDPDescriptorTest
extends XMLObjectProviderBaseTestCase {
    protected ArrayList<String> expectedSupportedProtocol;
    protected long expectedCacheDuration;
    protected DateTime expectedValidUntil;
    protected String expectedErrorURL;

    public PDPDescriptorTest() {
        this.singleElementFile = "/org/opensaml/saml/saml2/metadata/impl/PDPDescriptor.xml";
        this.singleElementOptionalAttributesFile = "/org/opensaml/saml/saml2/metadata/impl/PDPDescriptorOptionalAttributes.xml";
        this.childElementsFile = "/org/opensaml/saml/saml2/metadata/impl/PDPDescriptorChildElements.xml";
    }

    @BeforeMethod
    protected void setUp() throws Exception {
        this.expectedSupportedProtocol = new ArrayList();
        this.expectedSupportedProtocol.add("urn:foo:bar");
        this.expectedSupportedProtocol.add("urn:fooz:baz");
        this.expectedCacheDuration = 90000L;
        this.expectedValidUntil = new DateTime(2005, 12, 7, 10, 21, 0, 0, (Chronology)ISOChronology.getInstanceUTC());
        this.expectedErrorURL = "http://example.org";
    }

    @Test
    public void testSingleElementUnmarshall() {
        PDPDescriptor descriptor = (PDPDescriptor)this.unmarshallElement(this.singleElementFile);
        Assert.assertEquals((Collection)descriptor.getSupportedProtocols(), this.expectedSupportedProtocol, (String)"Supported protocols not equal to expected value");
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
        PDPDescriptor descriptor = (PDPDescriptor)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        Assert.assertEquals((long)descriptor.getCacheDuration(), (long)this.expectedCacheDuration, (String)"Cache duration was not expected value");
        Assert.assertEquals((Object)descriptor.getValidUntil(), (Object)this.expectedValidUntil, (String)"ValidUntil was not expected value");
        Assert.assertEquals((String)descriptor.getErrorURL(), (String)this.expectedErrorURL, (String)"ErrorURL was not expected value");
    }

    @Test
    public void testChildElementsUnmarshall() {
        PDPDescriptor descriptor = (PDPDescriptor)this.unmarshallElement(this.childElementsFile);
        Assert.assertNotNull((Object)descriptor.getExtensions(), (String)"<Extensions>");
        Assert.assertEquals((int)descriptor.getKeyDescriptors().size(), (int)0, (String)"KeyDescriptor");
        Assert.assertEquals((int)descriptor.getAuthzServices().size(), (int)3, (String)"AuthzService count");
        Assert.assertEquals((int)descriptor.getEndpoints(AuthzService.DEFAULT_ELEMENT_NAME).size(), (int)3, (String)"AuthzService count");
        Assert.assertEquals((int)descriptor.getAssertionIDRequestServices().size(), (int)2, (String)"AssertionIDRequestService count");
        Assert.assertEquals((int)descriptor.getEndpoints(AssertionIDRequestService.DEFAULT_ELEMENT_NAME).size(), (int)2, (String)"AssertionIDRequestService count");
        Assert.assertNull((Object)descriptor.getEndpoints(PDPDescriptor.DEFAULT_ELEMENT_NAME));
        Assert.assertEquals((int)descriptor.getEndpoints().size(), (int)5, (String)"EndPoints");
        Assert.assertEquals((int)descriptor.getNameIDFormats().size(), (int)1, (String)"NameIDFormat count");
    }

    @Test
    public void testSingleElementMarshall() {
        PDPDescriptor descriptor = new PDPDescriptorBuilder().buildObject();
        for (String protocol : this.expectedSupportedProtocol) {
            descriptor.addSupportedProtocol(protocol);
        }
        this.assertXMLEquals(this.expectedDOM, (XMLObject)descriptor);
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
        QName qname = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "PDPDescriptor", "md");
        PDPDescriptor descriptor = (PDPDescriptor)this.buildXMLObject(qname);
        for (String protocol : this.expectedSupportedProtocol) {
            descriptor.addSupportedProtocol(protocol);
        }
        descriptor.setCacheDuration(Long.valueOf(this.expectedCacheDuration));
        descriptor.setValidUntil(this.expectedValidUntil);
        descriptor.setErrorURL(this.expectedErrorURL);
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)descriptor);
    }

    @Test
    public void testChildElementsMarshall() {
        QName qname = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "PDPDescriptor", "md");
        PDPDescriptor descriptor = (PDPDescriptor)this.buildXMLObject(qname);
        QName extensionsQName = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "Extensions", "md");
        descriptor.setExtensions((Extensions)this.buildXMLObject(extensionsQName));
        QName authzQName = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "AuthzService", "md");
        for (int i = 0; i < 3; ++i) {
            descriptor.getAuthzServices().add((AuthzService)this.buildXMLObject(authzQName));
        }
        QName assertIDReqQName = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "AssertionIDRequestService", "md");
        for (int i = 0; i < 2; ++i) {
            descriptor.getAssertionIDRequestServices().add((AssertionIDRequestService)this.buildXMLObject(assertIDReqQName));
        }
        QName nameIDFormatQName = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "NameIDFormat", "md");
        descriptor.getNameIDFormats().add((NameIDFormat)this.buildXMLObject(nameIDFormatQName));
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)descriptor);
    }
}

