/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.metadata.impl;

import javax.xml.namespace.QName;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.util.AttributeMap;
import org.opensaml.saml.saml2.metadata.Extensions;
import org.opensaml.saml.saml2.metadata.Organization;
import org.opensaml.saml.saml2.metadata.OrganizationDisplayName;
import org.opensaml.saml.saml2.metadata.OrganizationName;
import org.opensaml.saml.saml2.metadata.OrganizationURL;
import org.opensaml.saml.saml2.metadata.impl.OrganizationBuilder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class OrganizationTest
extends XMLObjectProviderBaseTestCase {
    protected QName[] unknownAttributeNames = new QName[]{new QName("urn:foo:bar", "bar", "foo")};
    protected String[] unknownAttributeValues = new String[]{"fred"};

    public OrganizationTest() {
        this.singleElementFile = "/org/opensaml/saml/saml2/metadata/impl/Organization.xml";
        this.childElementsFile = "/org/opensaml/saml/saml2/metadata/impl/OrganizationChildElements.xml";
        this.singleElementUnknownAttributesFile = "/org/opensaml/saml/saml2/metadata/impl/OrganizationUnknownAttributes.xml";
    }

    @Test
    public void testSingleElementUnmarshall() {
        Organization org = (Organization)this.unmarshallElement(this.singleElementFile);
        Assert.assertEquals((int)org.getDisplayNames().size(), (int)0, (String)"Display names");
    }

    @Test
    public void testSingleElementUnknownAttributesUnmarshall() {
        Organization org = (Organization)this.unmarshallElement(this.singleElementUnknownAttributesFile);
        AttributeMap attributes = org.getUnknownAttributes();
        Assert.assertEquals((int)attributes.entrySet().size(), (int)this.unknownAttributeNames.length);
        for (int i = 0; i < this.unknownAttributeNames.length; ++i) {
            Assert.assertEquals((String)attributes.get((Object)this.unknownAttributeNames[i]), (String)this.unknownAttributeValues[i]);
        }
    }

    @Test
    public void testChildElementsUnmarshall() {
        Organization org = (Organization)this.unmarshallElement(this.childElementsFile);
        Assert.assertNotNull((Object)org.getExtensions(), (String)"Extensions");
        Assert.assertEquals((int)org.getOrganizationNames().size(), (int)3, (String)"OrganizationName count");
        Assert.assertEquals((int)org.getDisplayNames().size(), (int)2, (String)"DisplayNames count");
        Assert.assertEquals((int)org.getURLs().size(), (int)1, (String)"URL count");
    }

    @Test
    public void testSingleElementMarshall() {
        Organization org = (Organization)this.buildXMLObject(Organization.DEFAULT_ELEMENT_NAME);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)org);
    }

    @Test
    public void testSingleElementUnknownAttributesMarshall() {
        Organization org = new OrganizationBuilder().buildObject();
        for (int i = 0; i < this.unknownAttributeNames.length; ++i) {
            org.getUnknownAttributes().put(this.unknownAttributeNames[i], this.unknownAttributeValues[i]);
        }
        this.assertXMLEquals(this.expectedUnknownAttributesDOM, (XMLObject)org);
    }

    @Test
    public void testChildElementsMarshall() {
        int i;
        Organization org = (Organization)this.buildXMLObject(Organization.DEFAULT_ELEMENT_NAME);
        QName extensionsQName = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "Extensions", "md");
        org.setExtensions((Extensions)this.buildXMLObject(extensionsQName));
        for (i = 0; i < 3; ++i) {
            org.getOrganizationNames().add((OrganizationName)this.buildXMLObject(OrganizationName.DEFAULT_ELEMENT_NAME));
        }
        for (i = 0; i < 2; ++i) {
            org.getDisplayNames().add((OrganizationDisplayName)this.buildXMLObject(OrganizationDisplayName.DEFAULT_ELEMENT_NAME));
        }
        org.getURLs().add((OrganizationURL)this.buildXMLObject(OrganizationURL.DEFAULT_ELEMENT_NAME));
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)org);
    }
}

