/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.metadata.impl;

import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.saml.saml2.metadata.AuthnQueryService;
import org.opensaml.saml.saml2.metadata.impl.AuthnQueryServiceBuilder;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AuthnQueryServiceTest
extends XMLObjectProviderBaseTestCase {
    protected String expectedBinding;
    protected String expectedLocation;
    protected String expectedResponseLocation;

    public AuthnQueryServiceTest() {
        this.singleElementFile = "/org/opensaml/saml/saml2/metadata/impl/AuthnQueryService.xml";
        this.singleElementOptionalAttributesFile = "/org/opensaml/saml/saml2/metadata/impl/AuthnQueryServiceOptionalAttributes.xml";
    }

    @BeforeMethod
    protected void setUp() throws Exception {
        this.expectedBinding = "urn:binding:foo";
        this.expectedLocation = "example.org";
        this.expectedResponseLocation = "example.org/response";
    }

    @Test
    public void testSingleElementUnmarshall() {
        AuthnQueryService service = (AuthnQueryService)this.unmarshallElement(this.singleElementFile);
        Assert.assertEquals((String)service.getBinding(), (String)this.expectedBinding, (String)"Binding URI was not expected value");
        Assert.assertEquals((String)service.getLocation(), (String)this.expectedLocation, (String)"Location was not expected value");
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
        AuthnQueryService service = (AuthnQueryService)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        Assert.assertEquals((String)service.getBinding(), (String)this.expectedBinding, (String)"Binding URI was not expected value");
        Assert.assertEquals((String)service.getLocation(), (String)this.expectedLocation, (String)"Location was not expected value");
        Assert.assertEquals((String)service.getResponseLocation(), (String)this.expectedResponseLocation, (String)"ResponseLocation was not expected value");
    }

    @Test
    public void testSingleElementMarshall() {
        AuthnQueryService service = new AuthnQueryServiceBuilder().buildObject();
        service.setBinding(this.expectedBinding);
        service.setLocation(this.expectedLocation);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)service);
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
        AuthnQueryService service = (AuthnQueryService)this.buildXMLObject(AuthnQueryService.DEFAULT_ELEMENT_NAME);
        service.setBinding(this.expectedBinding);
        service.setLocation(this.expectedLocation);
        service.setResponseLocation(this.expectedResponseLocation);
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)service);
    }
}

