/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.encryption;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import org.opensaml.core.xml.XMLObjectBaseTestCase;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.opensaml.saml.saml2.core.EncryptedAssertion;
import org.opensaml.saml.saml2.core.EncryptedAttribute;
import org.opensaml.saml.saml2.core.EncryptedID;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.NewEncryptedID;
import org.opensaml.saml.saml2.core.NewID;
import org.opensaml.saml.saml2.encryption.Encrypter;
import org.opensaml.xmlsec.algorithm.AlgorithmSupport;
import org.opensaml.xmlsec.encryption.support.DataEncryptionParameters;
import org.opensaml.xmlsec.encryption.support.EncryptionException;
import org.opensaml.xmlsec.encryption.support.KeyEncryptionParameters;
import org.opensaml.xmlsec.keyinfo.KeyInfoGenerator;
import org.opensaml.xmlsec.keyinfo.impl.StaticKeyInfoGenerator;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.opensaml.xmlsec.signature.KeyName;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class SimpleEncryptionTest
extends XMLObjectBaseTestCase {
    private Encrypter encrypter;
    private DataEncryptionParameters encParams;
    private KeyEncryptionParameters kekParamsRSA;
    private List<KeyEncryptionParameters> kekParamsList;
    private KeyInfo keyInfo;
    private String algoURI = "http://www.w3.org/2001/04/xmlenc#aes128-cbc";
    private String expectedKeyName = "SuperSecretKey";
    private String kekURIRSA = "http://www.w3.org/2001/04/xmlenc#rsa-1_5";

    @BeforeMethod
    protected void setUp() throws Exception {
        this.encParams = new DataEncryptionParameters();
        this.encParams.setAlgorithm(this.algoURI);
        this.encParams.setEncryptionCredential(AlgorithmSupport.generateSymmetricKeyAndCredential((String)this.algoURI));
        this.kekParamsRSA = new KeyEncryptionParameters();
        this.kekParamsRSA.setAlgorithm(this.kekURIRSA);
        this.kekParamsRSA.setEncryptionCredential(AlgorithmSupport.generateKeyPairAndCredential((String)this.kekURIRSA, (int)1024, (boolean)false));
        this.kekParamsList = new ArrayList<KeyEncryptionParameters>();
        this.keyInfo = (KeyInfo)this.buildXMLObject(KeyInfo.DEFAULT_ELEMENT_NAME);
    }

    @Test
    public void testAssertion() {
        Assertion target = (Assertion)this.unmarshallElement("/org/opensaml/saml/saml2/encryption/Assertion.xml");
        KeyName keyName = (KeyName)this.buildXMLObject(KeyName.DEFAULT_ELEMENT_NAME);
        keyName.setValue(this.expectedKeyName);
        this.keyInfo.getKeyNames().add(keyName);
        this.encParams.setKeyInfoGenerator((KeyInfoGenerator)new StaticKeyInfoGenerator(this.keyInfo));
        this.encrypter = new Encrypter(this.encParams, this.kekParamsList);
        EncryptedAssertion encTarget = null;
        EncryptedAssertion encObject = null;
        try {
            encObject = this.encrypter.encrypt(target);
        }
        catch (EncryptionException e) {
            Assert.fail((String)("Object encryption failed: " + (Object)((Object)e)));
        }
        Assert.assertNotNull((Object)encObject, (String)"Encrypted object was null");
        Assert.assertTrue((boolean)(encObject instanceof EncryptedAssertion), (String)"Encrypted object was not an instance of the expected type");
        encTarget = encObject;
        Assert.assertEquals((String)encTarget.getEncryptedData().getType(), (String)"http://www.w3.org/2001/04/xmlenc#Element", (String)"Type attribute");
        Assert.assertEquals((String)encTarget.getEncryptedData().getEncryptionMethod().getAlgorithm(), (String)this.algoURI, (String)"Algorithm attribute");
        Assert.assertNotNull((Object)encTarget.getEncryptedData().getKeyInfo(), (String)"KeyInfo");
        Assert.assertEquals((String)((KeyName)encTarget.getEncryptedData().getKeyInfo().getKeyNames().get(0)).getValue(), (String)this.expectedKeyName, (String)"KeyName");
        Assert.assertEquals((int)encTarget.getEncryptedData().getKeyInfo().getEncryptedKeys().size(), (int)0, (String)"Number of EncryptedKeys");
        Assert.assertFalse((boolean)Strings.isNullOrEmpty((String)encTarget.getEncryptedData().getID()), (String)"EncryptedData ID attribute was empty");
    }

    @Test
    public void testAssertionAsID() {
        Assertion target = (Assertion)this.unmarshallElement("/org/opensaml/saml/saml2/encryption/Assertion.xml");
        KeyName keyName = (KeyName)this.buildXMLObject(KeyName.DEFAULT_ELEMENT_NAME);
        keyName.setValue(this.expectedKeyName);
        this.keyInfo.getKeyNames().add(keyName);
        this.encParams.setKeyInfoGenerator((KeyInfoGenerator)new StaticKeyInfoGenerator(this.keyInfo));
        this.encrypter = new Encrypter(this.encParams, this.kekParamsList);
        EncryptedID encTarget = null;
        EncryptedID encObject = null;
        try {
            encObject = this.encrypter.encryptAsID(target);
        }
        catch (EncryptionException e) {
            Assert.fail((String)("Object encryption failed: " + (Object)((Object)e)));
        }
        Assert.assertNotNull((Object)encObject, (String)"Encrypted object was null");
        Assert.assertTrue((boolean)(encObject instanceof EncryptedID), (String)"Encrypted object was not an instance of the expected type");
        encTarget = encObject;
        Assert.assertEquals((String)encTarget.getEncryptedData().getType(), (String)"http://www.w3.org/2001/04/xmlenc#Element", (String)"Type attribute");
        Assert.assertEquals((String)encTarget.getEncryptedData().getEncryptionMethod().getAlgorithm(), (String)this.algoURI, (String)"Algorithm attribute");
        Assert.assertNotNull((Object)encTarget.getEncryptedData().getKeyInfo(), (String)"KeyInfo");
        Assert.assertEquals((String)((KeyName)encTarget.getEncryptedData().getKeyInfo().getKeyNames().get(0)).getValue(), (String)this.expectedKeyName, (String)"KeyName");
        Assert.assertEquals((int)encTarget.getEncryptedData().getKeyInfo().getEncryptedKeys().size(), (int)0, (String)"Number of EncryptedKeys");
        Assert.assertFalse((boolean)Strings.isNullOrEmpty((String)encTarget.getEncryptedData().getID()), (String)"EncryptedData ID attribute was empty");
    }

    @Test
    public void testNameID() {
        Assertion assertion = (Assertion)this.unmarshallElement("/org/opensaml/saml/saml2/encryption/Assertion.xml");
        NameID target = assertion.getSubject().getNameID();
        KeyName keyName = (KeyName)this.buildXMLObject(KeyName.DEFAULT_ELEMENT_NAME);
        keyName.setValue(this.expectedKeyName);
        this.keyInfo.getKeyNames().add(keyName);
        this.encParams.setKeyInfoGenerator((KeyInfoGenerator)new StaticKeyInfoGenerator(this.keyInfo));
        this.encrypter = new Encrypter(this.encParams, this.kekParamsList);
        EncryptedID encTarget = null;
        EncryptedID encObject = null;
        try {
            encObject = this.encrypter.encrypt(target);
        }
        catch (EncryptionException e) {
            Assert.fail((String)("Object encryption failed: " + (Object)((Object)e)));
        }
        Assert.assertNotNull((Object)encObject, (String)"Encrypted object was null");
        Assert.assertTrue((boolean)(encObject instanceof EncryptedID), (String)"Encrypted object was not an instance of the expected type");
        encTarget = encObject;
        Assert.assertEquals((String)encTarget.getEncryptedData().getType(), (String)"http://www.w3.org/2001/04/xmlenc#Element", (String)"Type attribute");
        Assert.assertEquals((String)encTarget.getEncryptedData().getEncryptionMethod().getAlgorithm(), (String)this.algoURI, (String)"Algorithm attribute");
        Assert.assertNotNull((Object)encTarget.getEncryptedData().getKeyInfo(), (String)"KeyInfo");
        Assert.assertEquals((String)((KeyName)encTarget.getEncryptedData().getKeyInfo().getKeyNames().get(0)).getValue(), (String)this.expectedKeyName, (String)"KeyName");
        Assert.assertEquals((int)encTarget.getEncryptedData().getKeyInfo().getEncryptedKeys().size(), (int)0, (String)"Number of EncryptedKeys");
        Assert.assertFalse((boolean)Strings.isNullOrEmpty((String)encTarget.getEncryptedData().getID()), (String)"EncryptedData ID attribute was empty");
    }

    @Test
    public void testAttribute() {
        Assertion assertion = (Assertion)this.unmarshallElement("/org/opensaml/saml/saml2/encryption/Assertion.xml");
        Attribute target = (Attribute)((AttributeStatement)assertion.getAttributeStatements().get(0)).getAttributes().get(0);
        KeyName keyName = (KeyName)this.buildXMLObject(KeyName.DEFAULT_ELEMENT_NAME);
        keyName.setValue(this.expectedKeyName);
        this.keyInfo.getKeyNames().add(keyName);
        this.encParams.setKeyInfoGenerator((KeyInfoGenerator)new StaticKeyInfoGenerator(this.keyInfo));
        this.encrypter = new Encrypter(this.encParams, this.kekParamsList);
        EncryptedAttribute encTarget = null;
        EncryptedAttribute encObject = null;
        try {
            encObject = this.encrypter.encrypt(target);
        }
        catch (EncryptionException e) {
            Assert.fail((String)("Object encryption failed: " + (Object)((Object)e)));
        }
        Assert.assertNotNull((Object)encObject, (String)"Encrypted object was null");
        Assert.assertTrue((boolean)(encObject instanceof EncryptedAttribute), (String)"Encrypted object was not an instance of the expected type");
        encTarget = encObject;
        Assert.assertEquals((String)encTarget.getEncryptedData().getType(), (String)"http://www.w3.org/2001/04/xmlenc#Element", (String)"Type attribute");
        Assert.assertEquals((String)encTarget.getEncryptedData().getEncryptionMethod().getAlgorithm(), (String)this.algoURI, (String)"Algorithm attribute");
        Assert.assertNotNull((Object)encTarget.getEncryptedData().getKeyInfo(), (String)"KeyInfo");
        Assert.assertEquals((String)((KeyName)encTarget.getEncryptedData().getKeyInfo().getKeyNames().get(0)).getValue(), (String)this.expectedKeyName, (String)"KeyName");
        Assert.assertEquals((int)encTarget.getEncryptedData().getKeyInfo().getEncryptedKeys().size(), (int)0, (String)"Number of EncryptedKeys");
        Assert.assertFalse((boolean)Strings.isNullOrEmpty((String)encTarget.getEncryptedData().getID()), (String)"EncryptedData ID attribute was empty");
    }

    @Test
    public void testNewID() {
        NewID target = (NewID)this.buildXMLObject(NewID.DEFAULT_ELEMENT_NAME);
        target.setNewID("SomeNewID");
        KeyName keyName = (KeyName)this.buildXMLObject(KeyName.DEFAULT_ELEMENT_NAME);
        keyName.setValue(this.expectedKeyName);
        this.keyInfo.getKeyNames().add(keyName);
        this.encParams.setKeyInfoGenerator((KeyInfoGenerator)new StaticKeyInfoGenerator(this.keyInfo));
        this.encrypter = new Encrypter(this.encParams, this.kekParamsList);
        NewEncryptedID encTarget = null;
        NewEncryptedID encObject = null;
        try {
            encObject = this.encrypter.encrypt(target);
        }
        catch (EncryptionException e) {
            Assert.fail((String)("Object encryption failed: " + (Object)((Object)e)));
        }
        Assert.assertNotNull((Object)encObject, (String)"Encrypted object was null");
        Assert.assertTrue((boolean)(encObject instanceof NewEncryptedID), (String)"Encrypted object was not an instance of the expected type");
        encTarget = encObject;
        Assert.assertEquals((String)encTarget.getEncryptedData().getType(), (String)"http://www.w3.org/2001/04/xmlenc#Element", (String)"Type attribute");
        Assert.assertEquals((String)encTarget.getEncryptedData().getEncryptionMethod().getAlgorithm(), (String)this.algoURI, (String)"Algorithm attribute");
        Assert.assertNotNull((Object)encTarget.getEncryptedData().getKeyInfo(), (String)"KeyInfo");
        Assert.assertEquals((String)((KeyName)encTarget.getEncryptedData().getKeyInfo().getKeyNames().get(0)).getValue(), (String)this.expectedKeyName, (String)"KeyName");
        Assert.assertEquals((int)encTarget.getEncryptedData().getKeyInfo().getEncryptedKeys().size(), (int)0, (String)"Number of EncryptedKeys");
        Assert.assertFalse((boolean)Strings.isNullOrEmpty((String)encTarget.getEncryptedData().getID()), (String)"EncryptedData ID attribute was empty");
    }

    @Test
    public void testReuse() {
        Assertion assertion = (Assertion)this.unmarshallElement("/org/opensaml/saml/saml2/encryption/Assertion.xml");
        Attribute target = (Attribute)((AttributeStatement)assertion.getAttributeStatements().get(0)).getAttributes().get(0);
        Attribute target2 = (Attribute)((AttributeStatement)assertion.getAttributeStatements().get(0)).getAttributes().get(1);
        KeyName keyName = (KeyName)this.buildXMLObject(KeyName.DEFAULT_ELEMENT_NAME);
        keyName.setValue(this.expectedKeyName);
        this.keyInfo.getKeyNames().add(keyName);
        this.encParams.setKeyInfoGenerator((KeyInfoGenerator)new StaticKeyInfoGenerator(this.keyInfo));
        this.encrypter = new Encrypter(this.encParams, this.kekParamsList);
        EncryptedAttribute encObject = null;
        try {
            encObject = this.encrypter.encrypt(target);
        }
        catch (EncryptionException e) {
            Assert.fail((String)("Object encryption failed: " + (Object)((Object)e)));
        }
        Assert.assertNotNull((Object)encObject, (String)"Encrypted object was null");
        Assert.assertTrue((boolean)(encObject instanceof EncryptedAttribute), (String)"Encrypted object was not an instance of the expected type");
        EncryptedAttribute encObject2 = null;
        try {
            encObject2 = this.encrypter.encrypt(target2);
        }
        catch (EncryptionException e) {
            Assert.fail((String)("Object encryption failed: " + (Object)((Object)e)));
        }
        Assert.assertNotNull((Object)encObject2, (String)"Encrypted object was null");
        Assert.assertTrue((boolean)(encObject2 instanceof EncryptedAttribute), (String)"Encrypted object was not an instance of the expected type");
    }

    @Test
    public void testAutoKeyGen() {
        Assertion target = (Assertion)this.unmarshallElement("/org/opensaml/saml/saml2/encryption/Assertion.xml");
        this.encParams.setEncryptionCredential(null);
        this.kekParamsList.add(this.kekParamsRSA);
        this.encrypter = new Encrypter(this.encParams, this.kekParamsList);
        EncryptedAssertion encObject = null;
        try {
            encObject = this.encrypter.encrypt(target);
        }
        catch (EncryptionException e) {
            Assert.fail((String)("Object encryption failed: " + (Object)((Object)e)));
        }
        Assert.assertNotNull((Object)encObject, (String)"Encrypted object was null");
        Assert.assertTrue((boolean)(encObject instanceof EncryptedAssertion), (String)"Encrypted object was not an instance of the expected type");
    }

    @Test
    public void testAutoKeyGenNoKEK() {
        Assertion target = (Assertion)this.unmarshallElement("/org/opensaml/saml/saml2/encryption/Assertion.xml");
        this.encParams.setEncryptionCredential(null);
        this.kekParamsList.clear();
        this.encrypter = new Encrypter(this.encParams, this.kekParamsList);
        try {
            this.encrypter.encrypt(target);
            Assert.fail((String)"Object encryption should have failed: no KEK supplied with auto key generation for data encryption");
        }
        catch (EncryptionException encryptionException) {
            // empty catch block
        }
    }
}

