/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.ecp.impl;

import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.saml.saml2.core.SubjectConfirmationData;
import org.opensaml.saml.saml2.ecp.SubjectConfirmation;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class SubjectConfirmationTest
extends XMLObjectProviderBaseTestCase {
    private String expectedMethod;
    private String expectedSOAP11Actor;
    private Boolean expectedSOAP11MustUnderstand;

    public SubjectConfirmationTest() {
        this.singleElementFile = "/org/opensaml/saml/saml2/ecp/impl/SubjectConfirmation.xml";
        this.childElementsFile = "/org/opensaml/saml/saml2/ecp/impl/SubjectConfirmationChildElements.xml";
    }

    @BeforeMethod
    protected void setUp() throws Exception {
        this.expectedMethod = "conf method";
        this.expectedSOAP11Actor = "https://soap11actor.example.org";
        this.expectedSOAP11MustUnderstand = true;
    }

    @Test
    public void testSingleElementUnmarshall() {
        SubjectConfirmation subjectConfirmation = (SubjectConfirmation)this.unmarshallElement(this.singleElementFile);
        String method = subjectConfirmation.getMethod();
        Assert.assertEquals((String)this.expectedMethod, (String)method, (String)"Method not as expected");
        Assert.assertEquals((Object)this.expectedSOAP11MustUnderstand, (Object)subjectConfirmation.isSOAP11MustUnderstand(), (String)"SOAP mustUnderstand had unxpected value");
        Assert.assertEquals((String)this.expectedSOAP11Actor, (String)subjectConfirmation.getSOAP11Actor(), (String)"SOAP actor had unxpected value");
    }

    @Test
    public void testSingleElementMarshall() {
        SubjectConfirmation subjectConfirmation = (SubjectConfirmation)this.buildXMLObject(SubjectConfirmation.DEFAULT_ELEMENT_NAME);
        subjectConfirmation.setSOAP11Actor(this.expectedSOAP11Actor);
        subjectConfirmation.setSOAP11MustUnderstand(this.expectedSOAP11MustUnderstand);
        subjectConfirmation.setMethod(this.expectedMethod);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)subjectConfirmation);
    }

    @Test
    public void testChildElementsUnmarshall() {
        SubjectConfirmation subjectConfirmation = (SubjectConfirmation)this.unmarshallElement(this.childElementsFile);
        Assert.assertNotNull((Object)subjectConfirmation.getSubjectConfirmationData(), (String)"SubjectConfirmationData element not present");
    }

    @Test
    public void testChildElementsMarshall() {
        SubjectConfirmation subjectConfirmation = (SubjectConfirmation)this.buildXMLObject(SubjectConfirmation.DEFAULT_ELEMENT_NAME);
        subjectConfirmation.setSOAP11Actor(this.expectedSOAP11Actor);
        subjectConfirmation.setSOAP11MustUnderstand(this.expectedSOAP11MustUnderstand);
        subjectConfirmation.setMethod(this.expectedMethod);
        subjectConfirmation.setSubjectConfirmationData((SubjectConfirmationData)this.buildXMLObject(SubjectConfirmationData.DEFAULT_ELEMENT_NAME));
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)subjectConfirmation);
    }
}

