/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.core.impl;

import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.AssertionIDRef;
import org.opensaml.saml.saml2.core.AssertionURIRef;
import org.opensaml.saml.saml2.core.EncryptedAssertion;
import org.opensaml.saml.saml2.core.Evidence;
import org.testng.Assert;
import org.testng.annotations.Test;

public class EvidenceTest
extends XMLObjectProviderBaseTestCase {
    private int assertionIDRefCount = 3;
    private int assertionURIRefCount = 4;
    private int assertionCount = 2;
    private int encryptedAssertionCount = 2;

    public EvidenceTest() {
        this.singleElementFile = "/org/opensaml/saml/saml2/core/impl/Evidence.xml";
        this.childElementsFile = "/org/opensaml/saml/saml2/core/impl/EvidenceChildElements.xml";
    }

    @Test
    public void testSingleElementUnmarshall() {
        Evidence evidence = (Evidence)this.unmarshallElement(this.singleElementFile);
        Assert.assertNotNull((Object)evidence);
    }

    @Test
    public void testChildElementsUnmarshall() {
        Evidence evidence = (Evidence)this.unmarshallElement(this.childElementsFile);
        Assert.assertEquals((int)evidence.getAssertionIDReferences().size(), (int)this.assertionIDRefCount, (String)"AssertionIDRef count not as expected");
        Assert.assertEquals((int)evidence.getAssertionURIReferences().size(), (int)this.assertionURIRefCount, (String)"AssertionURIRef count not as expected");
        Assert.assertEquals((int)evidence.getAssertions().size(), (int)this.assertionCount, (String)"Assertion count not as expected");
        Assert.assertEquals((int)evidence.getEncryptedAssertions().size(), (int)this.encryptedAssertionCount, (String)"EncryptedAssertion count not as expected");
    }

    @Test
    public void testSingleElementMarshall() {
        Evidence evidence = (Evidence)this.buildXMLObject(Evidence.DEFAULT_ELEMENT_NAME);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)evidence);
    }

    @Test
    public void testChildElementsMarshall() {
        Evidence evidence = (Evidence)this.buildXMLObject(Evidence.DEFAULT_ELEMENT_NAME);
        evidence.getAssertionIDReferences().add((AssertionIDRef)this.buildXMLObject(AssertionIDRef.DEFAULT_ELEMENT_NAME));
        evidence.getAssertionIDReferences().add((AssertionIDRef)this.buildXMLObject(AssertionIDRef.DEFAULT_ELEMENT_NAME));
        evidence.getAssertionURIReferences().add((AssertionURIRef)this.buildXMLObject(AssertionURIRef.DEFAULT_ELEMENT_NAME));
        evidence.getAssertionIDReferences().add((AssertionIDRef)this.buildXMLObject(AssertionIDRef.DEFAULT_ELEMENT_NAME));
        evidence.getAssertionURIReferences().add((AssertionURIRef)this.buildXMLObject(AssertionURIRef.DEFAULT_ELEMENT_NAME));
        evidence.getAssertionURIReferences().add((AssertionURIRef)this.buildXMLObject(AssertionURIRef.DEFAULT_ELEMENT_NAME));
        evidence.getAssertionURIReferences().add((AssertionURIRef)this.buildXMLObject(AssertionURIRef.DEFAULT_ELEMENT_NAME));
        evidence.getAssertions().add((Assertion)this.buildXMLObject(Assertion.DEFAULT_ELEMENT_NAME));
        evidence.getEncryptedAssertions().add((EncryptedAssertion)this.buildXMLObject(EncryptedAssertion.DEFAULT_ELEMENT_NAME));
        evidence.getEncryptedAssertions().add((EncryptedAssertion)this.buildXMLObject(EncryptedAssertion.DEFAULT_ELEMENT_NAME));
        evidence.getAssertions().add((Assertion)this.buildXMLObject(Assertion.DEFAULT_ELEMENT_NAME));
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)evidence);
    }
}

