/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.core.impl;

import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.saml.saml2.core.EncryptedAssertion;
import org.opensaml.xmlsec.encryption.EncryptedData;
import org.opensaml.xmlsec.encryption.EncryptedKey;
import org.testng.Assert;
import org.testng.annotations.Test;

public class EncryptedAssertionTest
extends XMLObjectProviderBaseTestCase {
    private int encryptedKeyCount = 3;

    public EncryptedAssertionTest() {
        this.singleElementFile = "/org/opensaml/saml/saml2/core/impl/EncryptedAssertion.xml";
        this.childElementsFile = "/org/opensaml/saml/saml2/core/impl/EncryptedAssertionChildElements.xml";
    }

    @Test
    public void testSingleElementUnmarshall() {
        EncryptedAssertion encElement = (EncryptedAssertion)this.unmarshallElement(this.singleElementFile);
        Assert.assertNotNull((Object)encElement);
        Assert.assertNull((Object)encElement.getEncryptedData(), (String)"EncryptedData child element");
        Assert.assertEquals((int)encElement.getEncryptedKeys().size(), (int)0, (String)"# of EncryptedKey children");
    }

    @Test
    public void testChildElementsUnmarshall() {
        EncryptedAssertion encElement = (EncryptedAssertion)this.unmarshallElement(this.childElementsFile);
        Assert.assertNotNull((Object)encElement, (String)"EncryptedAssertion was null");
        Assert.assertNotNull((Object)encElement.getEncryptedData(), (String)"EncryptedData child element");
        Assert.assertEquals((int)encElement.getEncryptedKeys().size(), (int)this.encryptedKeyCount, (String)"# of EncryptedKey children");
    }

    @Test
    public void testSingleElementMarshall() {
        EncryptedAssertion encElement = (EncryptedAssertion)this.buildXMLObject(EncryptedAssertion.DEFAULT_ELEMENT_NAME);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)encElement);
    }

    @Test
    public void testChildElementsMarshall() {
        EncryptedAssertion encElement = (EncryptedAssertion)this.buildXMLObject(EncryptedAssertion.DEFAULT_ELEMENT_NAME);
        encElement.setEncryptedData((EncryptedData)this.buildXMLObject(EncryptedData.DEFAULT_ELEMENT_NAME));
        for (int i = 0; i < this.encryptedKeyCount; ++i) {
            encElement.getEncryptedKeys().add((EncryptedKey)this.buildXMLObject(EncryptedKey.DEFAULT_ELEMENT_NAME));
        }
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)encElement);
    }
}

