/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.core.impl;

import javax.xml.namespace.QName;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.saml2.core.AssertionIDRef;
import org.opensaml.saml.saml2.core.AssertionIDRequest;
import org.opensaml.saml.saml2.core.impl.AssertionIDRequestBuilder;
import org.opensaml.saml.saml2.core.impl.RequestTestBase;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AssertionIDRequestTest
extends RequestTestBase {
    private int expectedNumAssertionIDRefs;

    public AssertionIDRequestTest() {
        this.singleElementFile = "/org/opensaml/saml/saml2/core/impl/AssertionIDRequest.xml";
        this.singleElementOptionalAttributesFile = "/org/opensaml/saml/saml2/core/impl/AssertionIDRequestOptionalAttributes.xml";
        this.childElementsFile = "/org/opensaml/saml/saml2/core/impl/AssertionIDRequestChildElements.xml";
    }

    @Override
    @BeforeMethod
    protected void setUp() throws Exception {
        super.setUp();
        this.expectedNumAssertionIDRefs = 3;
    }

    @Override
    @Test
    public void testSingleElementMarshall() {
        QName qname = new QName("urn:oasis:names:tc:SAML:2.0:protocol", "AssertionIDRequest", "saml2p");
        AssertionIDRequest req = (AssertionIDRequest)this.buildXMLObject(qname);
        super.populateRequiredAttributes((SAMLObject)req);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)req);
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
        QName qname = new QName("urn:oasis:names:tc:SAML:2.0:protocol", "AssertionIDRequest", "saml2p");
        AssertionIDRequest req = (AssertionIDRequest)this.buildXMLObject(qname);
        super.populateRequiredAttributes((SAMLObject)req);
        super.populateOptionalAttributes((SAMLObject)req);
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)req);
    }

    @Test
    public void testChildElementsMarshall() {
        AssertionIDRequestBuilder builder = (AssertionIDRequestBuilder)builderFactory.getBuilder(AssertionIDRequest.DEFAULT_ELEMENT_NAME);
        AssertionIDRequest req = builder.buildObject();
        super.populateChildElements((SAMLObject)req);
        QName assertionIDRefQName = new QName("urn:oasis:names:tc:SAML:2.0:assertion", "AssertionIDRef", "saml2");
        for (int i = 0; i < this.expectedNumAssertionIDRefs; ++i) {
            req.getAssertionIDRefs().add((AssertionIDRef)this.buildXMLObject(assertionIDRefQName));
        }
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)req);
    }

    @Override
    @Test
    public void testSingleElementUnmarshall() {
        AssertionIDRequest req = (AssertionIDRequest)this.unmarshallElement(this.singleElementFile);
        super.helperTestSingleElementUnmarshall((SAMLObject)req);
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
        AssertionIDRequest req = (AssertionIDRequest)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        super.helperTestSingleElementOptionalAttributesUnmarshall((SAMLObject)req);
    }

    @Test
    public void testChildElementsUnmarshall() {
        AssertionIDRequest req = (AssertionIDRequest)this.unmarshallElement(this.childElementsFile);
        super.helperTestChildElementsUnmarshall((SAMLObject)req);
        Assert.assertEquals((int)req.getAssertionIDRefs().size(), (int)this.expectedNumAssertionIDRefs, (String)"AssertionIDRef count");
    }
}

