/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.binding.security.impl;

import org.opensaml.core.xml.XMLObjectBaseTestCase;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.messaging.context.SAMLBindingContext;
import org.opensaml.saml.common.messaging.context.SAMLMetadataContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.saml2.binding.security.impl.SAML2AuthnRequestsSignedSecurityHandler;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class SAML2AuthnRequestsSignedSecurityHandlerTest
extends XMLObjectBaseTestCase {
    private SAML2AuthnRequestsSignedSecurityHandler handler;
    private MessageContext<SAMLObject> messageContext;
    private final String issuer = "urn:test:issuer";
    private SPSSODescriptor spssoDescriptor;

    @BeforeMethod
    protected void setUp() throws Exception {
        this.handler = new SAML2AuthnRequestsSignedSecurityHandler();
        this.handler.initialize();
        this.spssoDescriptor = (SPSSODescriptor)this.buildXMLObject(SPSSODescriptor.DEFAULT_ELEMENT_NAME);
        this.spssoDescriptor.setAuthnRequestsSigned(Boolean.valueOf(false));
        this.messageContext = new MessageContext();
        ((SAMLPeerEntityContext)this.messageContext.getSubcontext(SAMLPeerEntityContext.class, true)).setEntityId("urn:test:issuer");
        ((SAMLMetadataContext)((SAMLPeerEntityContext)this.messageContext.getSubcontext(SAMLPeerEntityContext.class, true)).getSubcontext(SAMLMetadataContext.class, true)).setRoleDescriptor((RoleDescriptor)this.spssoDescriptor);
    }

    @Test
    public void testNotSignedAndNotRequired() throws MessageHandlerException {
        AuthnRequest authnRequest = (AuthnRequest)this.unmarshallElement("/org/opensaml/saml/saml2/binding/AuthnRequest.xml");
        this.messageContext.setMessage((Object)authnRequest);
        this.handler.invoke(this.messageContext);
    }

    @Test(expectedExceptions={MessageHandlerException.class})
    public void testNotSignedAndRequired() throws MessageHandlerException {
        AuthnRequest authnRequest = (AuthnRequest)this.unmarshallElement("/org/opensaml/saml/saml2/binding/AuthnRequest.xml");
        this.messageContext.setMessage((Object)authnRequest);
        this.spssoDescriptor.setAuthnRequestsSigned(Boolean.valueOf(true));
        this.handler.invoke(this.messageContext);
    }

    @Test
    public void testSignedAndNotRequired() throws MessageHandlerException {
        AuthnRequest authnRequest = (AuthnRequest)this.unmarshallElement("/org/opensaml/saml/saml2/binding/AuthnRequest-Signed.xml");
        this.messageContext.setMessage((Object)authnRequest);
        this.handler.invoke(this.messageContext);
    }

    @Test
    public void testSignedAndRequired() throws MessageHandlerException {
        AuthnRequest authnRequest = (AuthnRequest)this.unmarshallElement("/org/opensaml/saml/saml2/binding/AuthnRequest-Signed.xml");
        this.messageContext.setMessage((Object)authnRequest);
        this.spssoDescriptor.setAuthnRequestsSigned(Boolean.valueOf(true));
        this.handler.invoke(this.messageContext);
    }

    @Test
    public void testSimpleSignedAndRequired() throws MessageHandlerException {
        AuthnRequest authnRequest = (AuthnRequest)this.unmarshallElement("/org/opensaml/saml/saml2/binding/AuthnRequest.xml");
        this.messageContext.setMessage((Object)authnRequest);
        this.spssoDescriptor.setAuthnRequestsSigned(Boolean.valueOf(true));
        ((SAMLBindingContext)this.messageContext.getSubcontext(SAMLBindingContext.class, true)).setHasBindingSignature(true);
        this.handler.invoke(this.messageContext);
    }
}

