/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.binding.decoding.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import javax.servlet.http.HttpServletRequest;
import net.shibboleth.utilities.java.support.codec.Base64Support;
import net.shibboleth.utilities.java.support.xml.SerializeSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBaseTestCase;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.opensaml.messaging.encoder.MessageEncodingException;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.binding.SAMLBindingSupport;
import org.opensaml.saml.saml2.binding.decoding.impl.HTTPRedirectDeflateDecoder;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.opensaml.saml.saml2.core.Response;
import org.springframework.mock.web.MockHttpServletRequest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import org.w3c.dom.Node;

public class HTTPRedirectDeflateDecoderTest
extends XMLObjectBaseTestCase {
    private String expectedRelayValue = "relay";
    private HTTPRedirectDeflateDecoder decoder;
    private MockHttpServletRequest httpRequest;

    @BeforeMethod
    protected void setUp() throws Exception {
        this.httpRequest = new MockHttpServletRequest();
        this.httpRequest.setMethod("GET");
        this.httpRequest.setParameter("RelayState", this.expectedRelayValue);
        this.decoder = new HTTPRedirectDeflateDecoder();
        this.decoder.setParserPool(parserPool);
        this.decoder.setHttpServletRequest((HttpServletRequest)this.httpRequest);
        this.decoder.initialize();
    }

    @Test
    public void testResponseDecoding() throws MessageDecodingException {
        this.httpRequest.setParameter("SAMLResponse", "fZAxa8NADIX3/opDe3yXLG2F7VASCoF2qdMM3Y6LkhrOp8PSlfz8uqYdvBTeIMHT08ert7chmi8apefUwLpyYCgFPvfp2sD78Xn1ANv2rhY/xIxvJJmTkNmTaJ+8zkefqhmtpZsfcqSKxyuYw76BC/M0iBQ6JFGfdMp/vHcrt550dA5nVc65DzCnP4TND8IElQTnpw2UMSF76QWTH0hQA3ZPry84OTGPrBw4QvuL2KnXIsttx2cyJx8L/R8msxu7EgKJgG1ruwy1yxrabw==");
        this.populateRequestURL(this.httpRequest, "http://example.org");
        this.decoder.decode();
        MessageContext messageContext = this.decoder.getMessageContext();
        Assert.assertTrue((boolean)(messageContext.getMessage() instanceof Response));
        Assert.assertEquals((String)SAMLBindingSupport.getRelayState((MessageContext)messageContext), (String)this.expectedRelayValue);
    }

    @Test
    public void testRequestDecoding() throws MessageDecodingException, MessageEncodingException, MarshallingException {
        AuthnRequest samlRequest = (AuthnRequest)this.unmarshallElement("/org/opensaml/saml/saml2/binding/AuthnRequest.xml");
        samlRequest.setDestination(null);
        this.httpRequest.setParameter("SAMLRequest", this.encodeMessage((SAMLObject)samlRequest));
        this.decoder.decode();
        MessageContext messageContext = this.decoder.getMessageContext();
        Assert.assertTrue((boolean)(messageContext.getMessage() instanceof RequestAbstractType));
        Assert.assertEquals((String)SAMLBindingSupport.getRelayState((MessageContext)messageContext), (String)this.expectedRelayValue);
    }

    @Test
    public void testExplicitDefaultSAMLEncoding() throws MessageDecodingException, MessageEncodingException, MarshallingException {
        AuthnRequest samlRequest = (AuthnRequest)this.unmarshallElement("/org/opensaml/saml/saml2/binding/AuthnRequest.xml");
        samlRequest.setDestination(null);
        this.httpRequest.setParameter("SAMLRequest", this.encodeMessage((SAMLObject)samlRequest));
        this.httpRequest.setParameter("SAMLEncoding", "urn:oasis:names:tc:SAML:2.0:bindings:URL-Encoding:DEFLATE");
        this.decoder.decode();
        MessageContext messageContext = this.decoder.getMessageContext();
        Assert.assertTrue((boolean)(messageContext.getMessage() instanceof RequestAbstractType));
        Assert.assertEquals((String)SAMLBindingSupport.getRelayState((MessageContext)messageContext), (String)this.expectedRelayValue);
    }

    @Test(expectedExceptions={MessageDecodingException.class})
    public void testUnsupportedSAMLEncoding() throws MessageDecodingException, MessageEncodingException, MarshallingException {
        AuthnRequest samlRequest = (AuthnRequest)this.unmarshallElement("/org/opensaml/saml/saml2/binding/AuthnRequest.xml");
        samlRequest.setDestination(null);
        this.httpRequest.setParameter("SAMLRequest", this.encodeMessage((SAMLObject)samlRequest));
        this.httpRequest.setParameter("SAMLEncoding", "urn:test:encoding:bogus");
        this.decoder.decode();
    }

    private void populateRequestURL(MockHttpServletRequest request, String requestURL) {
        URL url = null;
        try {
            url = new URL(requestURL);
        }
        catch (MalformedURLException e) {
            Assert.fail((String)("Malformed URL: " + e.getMessage()));
        }
        request.setScheme(url.getProtocol());
        request.setServerName(url.getHost());
        if (url.getPort() != -1) {
            request.setServerPort(url.getPort());
        } else if ("https".equalsIgnoreCase(url.getProtocol())) {
            request.setServerPort(443);
        } else if ("http".equalsIgnoreCase(url.getProtocol())) {
            request.setServerPort(80);
        }
        request.setRequestURI(url.getPath());
        request.setQueryString(url.getQuery());
    }

    protected String encodeMessage(SAMLObject message) throws MessageEncodingException, MarshallingException {
        try {
            marshallerFactory.getMarshaller((XMLObject)message).marshall((XMLObject)message);
            String messageStr = SerializeSupport.nodeToString((Node)message.getDOM());
            ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
            Deflater deflater = new Deflater(8, true);
            DeflaterOutputStream deflaterStream = new DeflaterOutputStream((OutputStream)bytesOut, deflater);
            deflaterStream.write(messageStr.getBytes("UTF-8"));
            deflaterStream.finish();
            return Base64Support.encode((byte[])bytesOut.toByteArray(), (boolean)false);
        }
        catch (IOException e) {
            throw new MessageEncodingException("Unable to DEFLATE and Base64 encode SAML message", (Exception)e);
        }
    }
}

