/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.assertion.impl;

import java.net.URISyntaxException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.util.Map;
import org.opensaml.saml.common.assertion.AssertionValidationException;
import org.opensaml.saml.common.assertion.ValidationContext;
import org.opensaml.saml.common.assertion.ValidationResult;
import org.opensaml.saml.saml2.assertion.BaseAssertionValidationTest;
import org.opensaml.saml.saml2.assertion.impl.HolderOfKeySubjectConfirmationValidator;
import org.opensaml.saml.saml2.core.KeyInfoConfirmationDataType;
import org.opensaml.saml.saml2.core.SubjectConfirmation;
import org.opensaml.saml.saml2.core.SubjectConfirmationData;
import org.opensaml.xmlsec.keyinfo.KeyInfoSupport;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class HolderOfKeySubjectConfirmationValidatorTest
extends BaseAssertionValidationTest {
    private HolderOfKeySubjectConfirmationValidator validator;
    private SubjectConfirmation subjectConfirmation;
    private SubjectConfirmationData subjectConfirmationData;
    private KeyInfo keyInfo;
    private X509Certificate cert1;
    private X509Certificate cert2;
    private PublicKey publicKey1;
    private PublicKey publicKey2;

    @BeforeClass
    protected void readCertsAndKeys() throws CertificateException, URISyntaxException {
        this.cert1 = this.getCertificate("subject1.crt");
        this.publicKey1 = this.cert1.getPublicKey();
        this.cert2 = this.getCertificate("subject2.crt");
        this.publicKey2 = this.cert2.getPublicKey();
    }

    @BeforeMethod(dependsOnMethods={"setUpBasicAssertion"})
    protected void setUp() throws NoSuchAlgorithmException, NoSuchProviderException {
        this.validator = new HolderOfKeySubjectConfirmationValidator();
        this.subjectConfirmation = (SubjectConfirmation)this.getAssertion().getSubject().getSubjectConfirmations().get(0);
        this.subjectConfirmation.setMethod("urn:oasis:names:tc:SAML:2.0:cm:holder-of-key");
        this.subjectConfirmationData = this.buildBasicSubjectConfirmationData(KeyInfoConfirmationDataType.TYPE_NAME);
        this.subjectConfirmation.setSubjectConfirmationData(this.subjectConfirmationData);
        this.keyInfo = (KeyInfo)this.buildXMLObject(KeyInfo.DEFAULT_ELEMENT_NAME);
        ((KeyInfoConfirmationDataType)this.subjectConfirmation.getSubjectConfirmationData()).getKeyInfos().add(this.keyInfo);
    }

    @Test
    public void testValidPublicKeyViaKeyValue() throws AssertionValidationException {
        KeyInfoSupport.addPublicKey((KeyInfo)this.keyInfo, (PublicKey)this.publicKey1);
        Map<String, Object> staticParams = this.buildBasicStaticParameters();
        staticParams.put("saml2.SubjectConfirmation.HoK.PresenterKey", this.publicKey1);
        ValidationContext validationContext = new ValidationContext(staticParams);
        Assert.assertEquals((Object)this.validator.validate(this.subjectConfirmation, this.getAssertion(), validationContext), (Object)ValidationResult.VALID);
        Assert.assertSame(validationContext.getDynamicParameters().get("saml2.SubjectConfirmation.HoK.ConfirmedKeyInfo"), (Object)this.keyInfo);
    }

    @Test
    public void testValidPublicKeyViaDEREncodedKeyValue() throws AssertionValidationException, NoSuchAlgorithmException, InvalidKeySpecException {
        KeyInfoSupport.addDEREncodedPublicKey((KeyInfo)this.keyInfo, (PublicKey)this.publicKey1);
        Map<String, Object> staticParams = this.buildBasicStaticParameters();
        staticParams.put("saml2.SubjectConfirmation.HoK.PresenterKey", this.publicKey1);
        ValidationContext validationContext = new ValidationContext(staticParams);
        Assert.assertEquals((Object)this.validator.validate(this.subjectConfirmation, this.getAssertion(), validationContext), (Object)ValidationResult.VALID);
        Assert.assertSame(validationContext.getDynamicParameters().get("saml2.SubjectConfirmation.HoK.ConfirmedKeyInfo"), (Object)this.keyInfo);
    }

    @Test
    public void testInvalidPublicKey() throws AssertionValidationException {
        KeyInfoSupport.addPublicKey((KeyInfo)this.keyInfo, (PublicKey)this.publicKey1);
        Map<String, Object> staticParams = this.buildBasicStaticParameters();
        staticParams.put("saml2.SubjectConfirmation.HoK.PresenterKey", this.publicKey2);
        ValidationContext validationContext = new ValidationContext(staticParams);
        Assert.assertEquals((Object)this.validator.validate(this.subjectConfirmation, this.getAssertion(), validationContext), (Object)ValidationResult.INVALID);
        Assert.assertNull(validationContext.getDynamicParameters().get("saml2.SubjectConfirmation.HoK.ConfirmedKeyInfo"));
    }

    @Test
    public void testValidCert() throws AssertionValidationException, CertificateEncodingException {
        KeyInfoSupport.addCertificate((KeyInfo)this.keyInfo, (X509Certificate)this.cert1);
        Map<String, Object> staticParams = this.buildBasicStaticParameters();
        staticParams.put("saml2.SubjectConfirmation.HoK.PresenterCertificate", this.cert1);
        ValidationContext validationContext = new ValidationContext(staticParams);
        Assert.assertEquals((Object)this.validator.validate(this.subjectConfirmation, this.getAssertion(), validationContext), (Object)ValidationResult.VALID);
        Assert.assertSame(validationContext.getDynamicParameters().get("saml2.SubjectConfirmation.HoK.ConfirmedKeyInfo"), (Object)this.keyInfo);
    }

    @Test
    public void testInvalidCert() throws AssertionValidationException, CertificateEncodingException {
        KeyInfoSupport.addCertificate((KeyInfo)this.keyInfo, (X509Certificate)this.cert1);
        Map<String, Object> staticParams = this.buildBasicStaticParameters();
        ValidationContext validationContext = new ValidationContext(staticParams);
        staticParams.put("saml2.SubjectConfirmation.HoK.PresenterCertificate", this.cert2);
        Assert.assertEquals((Object)this.validator.validate(this.subjectConfirmation, this.getAssertion(), validationContext), (Object)ValidationResult.INVALID);
        Assert.assertNull(validationContext.getDynamicParameters().get("saml2.SubjectConfirmation.HoK.ConfirmedKeyInfo"));
    }

    @Test
    public void testMissingKeyInfos() throws AssertionValidationException {
        this.subjectConfirmationData.getUnknownXMLObjects().clear();
        Map<String, Object> staticParams = this.buildBasicStaticParameters();
        staticParams.put("saml2.SubjectConfirmation.HoK.PresenterKey", this.publicKey1);
        ValidationContext validationContext = new ValidationContext(staticParams);
        Assert.assertEquals((Object)this.validator.validate(this.subjectConfirmation, this.getAssertion(), validationContext), (Object)ValidationResult.INVALID);
        Assert.assertNull(validationContext.getDynamicParameters().get("saml2.SubjectConfirmation.HoK.ConfirmedKeyInfo"));
    }

    @Test
    public void testMissingPresenterParams() throws AssertionValidationException {
        KeyInfoSupport.addPublicKey((KeyInfo)this.keyInfo, (PublicKey)this.publicKey1);
        Map<String, Object> staticParams = this.buildBasicStaticParameters();
        ValidationContext validationContext = new ValidationContext(staticParams);
        Assert.assertEquals((Object)this.validator.validate(this.subjectConfirmation, this.getAssertion(), validationContext), (Object)ValidationResult.INDETERMINATE);
        Assert.assertNull(validationContext.getDynamicParameters().get("saml2.SubjectConfirmation.HoK.ConfirmedKeyInfo"));
    }

    @Test
    public void testInvalidPublicKeyParam() throws AssertionValidationException {
        Map<String, Object> staticParams = this.buildBasicStaticParameters();
        staticParams.put("saml2.SubjectConfirmation.HoK.PresenterKey", "foobar");
        ValidationContext validationContext = new ValidationContext(staticParams);
        Assert.assertEquals((Object)this.validator.validate(this.subjectConfirmation, this.getAssertion(), validationContext), (Object)ValidationResult.INDETERMINATE);
        Assert.assertNull(validationContext.getDynamicParameters().get("saml2.SubjectConfirmation.HoK.ConfirmedKeyInfo"));
    }

    @Test
    public void testInvalidCertParam() throws AssertionValidationException {
        Map<String, Object> staticParams = this.buildBasicStaticParameters();
        staticParams.put("saml2.SubjectConfirmation.HoK.PresenterCertificate", "foobar");
        ValidationContext validationContext = new ValidationContext(staticParams);
        Assert.assertEquals((Object)this.validator.validate(this.subjectConfirmation, this.getAssertion(), validationContext), (Object)ValidationResult.INDETERMINATE);
        Assert.assertNull(validationContext.getDynamicParameters().get("saml2.SubjectConfirmation.HoK.ConfirmedKeyInfo"));
    }

    @Test
    public void testCertAndKeyParamMismatch() throws AssertionValidationException {
        KeyInfoSupport.addPublicKey((KeyInfo)this.keyInfo, (PublicKey)this.publicKey1);
        Map<String, Object> staticParams = this.buildBasicStaticParameters();
        staticParams.put("saml2.SubjectConfirmation.HoK.PresenterKey", this.publicKey1);
        staticParams.put("saml2.SubjectConfirmation.HoK.PresenterCertificate", this.cert2);
        ValidationContext validationContext = new ValidationContext(staticParams);
        Assert.assertEquals((Object)this.validator.validate(this.subjectConfirmation, this.getAssertion(), validationContext), (Object)ValidationResult.INDETERMINATE);
        Assert.assertNull(validationContext.getDynamicParameters().get("saml2.SubjectConfirmation.HoK.ConfirmedKeyInfo"));
    }

    @Test
    public void testNonHOKMethod() throws AssertionValidationException {
        this.subjectConfirmation.setMethod("urn:oasis:names:tc:SAML:2.0:cm:bearer");
        this.subjectConfirmation.setSubjectConfirmationData(this.buildBasicSubjectConfirmationData());
        Map<String, Object> staticParams = this.buildBasicStaticParameters();
        staticParams.put("saml2.SubjectConfirmation.HoK.PresenterKey", this.publicKey1);
        ValidationContext validationContext = new ValidationContext(staticParams);
        Assert.assertEquals((Object)this.validator.validate(this.subjectConfirmation, this.getAssertion(), validationContext), (Object)ValidationResult.INDETERMINATE);
        Assert.assertNull(validationContext.getDynamicParameters().get("saml2.SubjectConfirmation.HoK.ConfirmedKeyInfo"));
    }

    @Test
    public void testNonKeyInfoConfirmationData() throws AssertionValidationException {
        this.subjectConfirmation.setSubjectConfirmationData(this.buildBasicSubjectConfirmationData());
        Map<String, Object> staticParams = this.buildBasicStaticParameters();
        staticParams.put("saml2.SubjectConfirmation.HoK.PresenterKey", this.publicKey1);
        ValidationContext validationContext = new ValidationContext(staticParams);
        Assert.assertEquals((Object)this.validator.validate(this.subjectConfirmation, this.getAssertion(), validationContext), (Object)ValidationResult.INVALID);
        Assert.assertNull(validationContext.getDynamicParameters().get("saml2.SubjectConfirmation.HoK.ConfirmedKeyInfo"));
    }
}

