/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml1.core.impl;

import javax.xml.namespace.QName;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBuilder;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.schema.XSAny;
import org.opensaml.saml.saml1.core.ConfirmationMethod;
import org.opensaml.saml.saml1.core.SubjectConfirmation;
import org.opensaml.saml.saml1.core.impl.SubjectConfirmationImpl;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import org.w3c.dom.Document;

public class SubjectConfirmationTest
extends XMLObjectProviderBaseTestCase {
    private final QName qname;
    private String fullElementsFile;
    private Document expectedFullDOM;

    public SubjectConfirmationTest() {
        this.singleElementFile = "/org/opensaml/saml/saml1/impl/singleSubjectConfirmation.xml";
        this.singleElementOptionalAttributesFile = "/org/opensaml/saml/saml1/impl/singleSubjectConfirmation.xml";
        this.fullElementsFile = "/org/opensaml/saml/saml1/impl/SubjectConfirmationWithChildren.xml";
        this.qname = new QName("urn:oasis:names:tc:SAML:1.0:assertion", "SubjectConfirmation", "saml1");
    }

    @BeforeMethod
    protected void setUp() throws Exception {
        this.expectedFullDOM = parserPool.parse(((Object)((Object)this)).getClass().getResourceAsStream(this.fullElementsFile));
    }

    @Test
    public void testSingleElementUnmarshall() {
        SubjectConfirmation subjectConfirmation = (SubjectConfirmation)this.unmarshallElement(this.singleElementFile);
        Assert.assertEquals((int)subjectConfirmation.getConfirmationMethods().size(), (int)0, (String)"Non zero number of child ConfirmationMethods elements");
        Assert.assertNull((Object)subjectConfirmation.getSubjectConfirmationData(), (String)"Non zero number of child SubjectConfirmationData elements");
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
    }

    @Test
    public void testFullElementsUnmarshall() {
        SubjectConfirmation subjectConfirmation = (SubjectConfirmation)this.unmarshallElement(this.fullElementsFile);
        Assert.assertEquals((int)subjectConfirmation.getConfirmationMethods().size(), (int)2, (String)"Number of ConfirmationMethods");
        Assert.assertNotNull((Object)subjectConfirmation.getSubjectConfirmationData(), (String)"Zero child SubjectConfirmationData elements");
    }

    @Test
    public void testSingleElementMarshall() {
        this.assertXMLEquals(this.expectedDOM, this.buildXMLObject(this.qname));
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
    }

    @Test
    public void testFullElementsMarshall() {
        SubjectConfirmationImpl subjectConfirmation = (SubjectConfirmationImpl)this.buildXMLObject(this.qname);
        QName oqname = new QName("urn:oasis:names:tc:SAML:1.0:assertion", "ConfirmationMethod", "saml1");
        subjectConfirmation.getConfirmationMethods().add((ConfirmationMethod)this.buildXMLObject(oqname));
        subjectConfirmation.getConfirmationMethods().add((ConfirmationMethod)this.buildXMLObject(oqname));
        XMLObjectBuilder proxyBuilder = builderFactory.getBuilderOrThrow(XSAny.TYPE_NAME);
        oqname = new QName("urn:oasis:names:tc:SAML:1.0:assertion", "SubjectConfirmationData", "saml1");
        subjectConfirmation.setSubjectConfirmationData(proxyBuilder.buildObject(oqname));
        this.assertXMLEquals(this.expectedFullDOM, (XMLObject)subjectConfirmation);
    }
}

