/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml1.core.impl;

import java.util.List;
import javax.xml.namespace.QName;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.saml.saml1.core.Action;
import org.opensaml.saml.saml1.core.AuthorizationDecisionQuery;
import org.opensaml.saml.saml1.core.Evidence;
import org.opensaml.saml.saml1.core.Subject;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import org.w3c.dom.Document;

public class AuthorizationDecisionQueryTest
extends XMLObjectProviderBaseTestCase {
    private final QName qname;
    private final String fullElementsFile;
    private Document expectedFullDOM;
    private final String expectedResource;

    public AuthorizationDecisionQueryTest() {
        this.singleElementFile = "/org/opensaml/saml/saml1/impl/singleAuthorizationDecisionQuery.xml";
        this.singleElementOptionalAttributesFile = "/org/opensaml/saml/saml1/impl/singleAuthorizationDecisionQueryAttributes.xml";
        this.fullElementsFile = "/org/opensaml/saml/saml1/impl/AuthorizationDecisionQueryWithChildren.xml";
        this.expectedResource = "resource";
        this.qname = new QName("urn:oasis:names:tc:SAML:1.0:protocol", "AuthorizationDecisionQuery", "saml1p");
    }

    @BeforeMethod
    protected void setUp() throws Exception {
        this.expectedFullDOM = parserPool.parse(((Object)((Object)this)).getClass().getResourceAsStream(this.fullElementsFile));
    }

    @Test
    public void testSingleElementUnmarshall() {
        AuthorizationDecisionQuery authorizationDecisionQuery = (AuthorizationDecisionQuery)this.unmarshallElement(this.singleElementFile);
        Assert.assertNull((Object)authorizationDecisionQuery.getResource(), (String)"Resource attribute present");
        Assert.assertNull((Object)authorizationDecisionQuery.getSubject(), (String)"Subject element present");
        Assert.assertEquals((int)authorizationDecisionQuery.getActions().size(), (int)0, (String)"Count of AttributeDesignator elements");
        Assert.assertNull((Object)authorizationDecisionQuery.getEvidence(), (String)"Evidence element present");
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
        AuthorizationDecisionQuery authorizationDecisionQuery = (AuthorizationDecisionQuery)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        Assert.assertEquals((String)authorizationDecisionQuery.getResource(), (String)this.expectedResource, (String)"Resource attribute");
        Assert.assertNull((Object)authorizationDecisionQuery.getSubject(), (String)"Subject element present");
        Assert.assertEquals((int)authorizationDecisionQuery.getActions().size(), (int)0, (String)"Count of AttributeDesignator elements");
        Assert.assertNull((Object)authorizationDecisionQuery.getEvidence(), (String)"Evidence element present");
    }

    @Test
    public void testFullElementsUnmarshall() {
        AuthorizationDecisionQuery authorizationDecisionQuery = (AuthorizationDecisionQuery)this.unmarshallElement(this.fullElementsFile);
        Assert.assertNotNull((Object)authorizationDecisionQuery.getSubject(), (String)"Subject element present");
        Assert.assertEquals((int)authorizationDecisionQuery.getActions().size(), (int)3, (String)"Count of Action elements");
        Assert.assertNotNull((Object)authorizationDecisionQuery.getEvidence(), (String)"Evidence element present");
    }

    @Test
    public void testSingleElementMarshall() {
        this.assertXMLEquals(this.expectedDOM, this.buildXMLObject(this.qname));
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
        AuthorizationDecisionQuery authorizationDecisionQuery = (AuthorizationDecisionQuery)this.buildXMLObject(this.qname);
        authorizationDecisionQuery.setResource(this.expectedResource);
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)authorizationDecisionQuery);
    }

    @Test
    public void testFullElementsMarshall() {
        AuthorizationDecisionQuery authorizationDecisionQuery = (AuthorizationDecisionQuery)this.buildXMLObject(this.qname);
        authorizationDecisionQuery.setSubject((Subject)this.buildXMLObject(new QName("urn:oasis:names:tc:SAML:1.0:assertion", "Subject", "saml1")));
        QName actionQname = new QName("urn:oasis:names:tc:SAML:1.0:assertion", "Action", "saml1");
        List list = authorizationDecisionQuery.getActions();
        list.add((Action)this.buildXMLObject(actionQname));
        list.add((Action)this.buildXMLObject(actionQname));
        list.add((Action)this.buildXMLObject(actionQname));
        authorizationDecisionQuery.setEvidence((Evidence)this.buildXMLObject(new QName("urn:oasis:names:tc:SAML:1.0:assertion", "Evidence", "saml1")));
        this.assertXMLEquals(this.expectedFullDOM, (XMLObject)authorizationDecisionQuery);
    }
}

