/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml1.core.impl;

import javax.xml.namespace.QName;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.saml.saml1.core.AuthorityBinding;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AuthorityBindingTest
extends XMLObjectProviderBaseTestCase {
    private final QName qname;
    private final QName expectedAuthorityKind = new QName("urn:oasis:names:tc:SAML:1.0:protocol", "AttributeQuery", "saml1p");
    private final String expectedLocation;
    private final String expectedBinding;

    public AuthorityBindingTest() {
        this.expectedLocation = "here";
        this.expectedBinding = "binding";
        this.singleElementFile = "/org/opensaml/saml/saml1/impl/singleAuthorityBinding.xml";
        this.singleElementOptionalAttributesFile = "/org/opensaml/saml/saml1/impl/singleAuthorityBindingAttributes.xml";
        this.qname = new QName("urn:oasis:names:tc:SAML:1.0:assertion", "AuthorityBinding", "saml1");
    }

    @Test
    public void testSingleElementUnmarshall() {
        AuthorityBinding authorityBinding = (AuthorityBinding)this.unmarshallElement(this.singleElementFile);
        Assert.assertNull((Object)authorityBinding.getAuthorityKind(), (String)"AuthorityKind attribute present");
        Assert.assertNull((Object)authorityBinding.getBinding(), (String)"Binding attribute present");
        Assert.assertNull((Object)authorityBinding.getLocation(), (String)"Location attribute present");
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
        AuthorityBinding authorityBinding = (AuthorityBinding)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        Assert.assertEquals((Object)authorityBinding.getAuthorityKind(), (Object)this.expectedAuthorityKind, (String)"AuthorityKind attribute");
        Assert.assertEquals((String)authorityBinding.getBinding(), (String)this.expectedBinding, (String)"Binding attribute");
        Assert.assertEquals((String)authorityBinding.getLocation(), (String)this.expectedLocation, (String)"Location attribute");
    }

    @Test
    public void testSingleElementMarshall() {
        this.assertXMLEquals(this.expectedDOM, this.buildXMLObject(this.qname));
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
        AuthorityBinding authorityBinding = (AuthorityBinding)this.buildXMLObject(this.qname);
        authorityBinding.setAuthorityKind(this.expectedAuthorityKind);
        authorityBinding.setBinding(this.expectedBinding);
        authorityBinding.setLocation(this.expectedLocation);
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)authorityBinding);
    }
}

