/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml1.core.impl;

import javax.xml.namespace.QName;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.saml.saml1.core.AttributeDesignator;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AttributeDesignatorTest
extends XMLObjectProviderBaseTestCase {
    private final QName qname;
    private final String expectedAttributeName;
    private final String expectedAttributeNamespace;

    public AttributeDesignatorTest() {
        this.singleElementFile = "/org/opensaml/saml/saml1/impl/singleAttributeDesignator.xml";
        this.singleElementOptionalAttributesFile = "/org/opensaml/saml/saml1/impl/singleAttributeDesignatorAttributes.xml";
        this.expectedAttributeName = "AttributeName";
        this.expectedAttributeNamespace = "namespace";
        this.qname = new QName("urn:oasis:names:tc:SAML:1.0:assertion", "AttributeDesignator", "saml1");
    }

    @Test
    public void testSingleElementUnmarshall() {
        AttributeDesignator ad = (AttributeDesignator)this.unmarshallElement(this.singleElementFile);
        Assert.assertNull((Object)ad.getAttributeName(), (String)"AttributeName");
        Assert.assertNull((Object)ad.getAttributeNamespace(), (String)"AttributeNamespace");
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
        AttributeDesignator ad = (AttributeDesignator)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        Assert.assertEquals((String)ad.getAttributeName(), (String)this.expectedAttributeName, (String)"AttributeName");
        Assert.assertEquals((String)ad.getAttributeNamespace(), (String)this.expectedAttributeNamespace, (String)"AttributeNamespace");
    }

    @Test
    public void testSingleElementMarshall() {
        this.assertXMLEquals(this.expectedDOM, this.buildXMLObject(this.qname));
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
        AttributeDesignator ad = (AttributeDesignator)this.buildXMLObject(this.qname);
        ad.setAttributeName(this.expectedAttributeName);
        ad.setAttributeNamespace(this.expectedAttributeNamespace);
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)ad);
    }
}

