/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml1.core.impl;

import javax.xml.namespace.QName;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.saml.saml1.core.AssertionArtifact;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AssertionArtifactTest
extends XMLObjectProviderBaseTestCase {
    private final QName qname;
    private final String expectedAssertionArtifact;

    public AssertionArtifactTest() {
        this.singleElementFile = "/org/opensaml/saml/saml1/impl/singleAssertionArtifact.xml";
        this.singleElementOptionalAttributesFile = "/org/opensaml/saml/saml1/impl/singleAssertionArtifactAttribute.xml";
        this.expectedAssertionArtifact = "Test Text";
        this.qname = new QName("urn:oasis:names:tc:SAML:1.0:protocol", "AssertionArtifact", "saml1p");
    }

    @Test
    public void testSingleElementUnmarshall() {
        AssertionArtifact artifact = (AssertionArtifact)this.unmarshallElement(this.singleElementFile);
        Assert.assertNull((Object)artifact.getAssertionArtifact(), (String)"AssertionArtifact contents present");
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
        AssertionArtifact artifact = (AssertionArtifact)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        Assert.assertEquals((String)artifact.getAssertionArtifact(), (String)this.expectedAssertionArtifact, (String)"AssertionArtifact contents present");
    }

    @Test
    public void testSingleElementMarshall() {
        this.assertXMLEquals(this.expectedDOM, this.buildXMLObject(this.qname));
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
        AssertionArtifact artifact = (AssertionArtifact)this.buildXMLObject(this.qname);
        artifact.setAssertionArtifact(this.expectedAssertionArtifact);
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)artifact);
    }
}

