/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.impl;

import com.google.common.base.Function;
import com.google.common.util.concurrent.Uninterruptibles;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.TimeUnit;
import net.shibboleth.utilities.java.support.codec.StringDigester;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBaseTestCase;
import org.opensaml.core.xml.persist.MapLoadSaveManager;
import org.opensaml.saml.metadata.resolver.impl.IdentityEntityIDGenerator;
import org.opensaml.saml.metadata.resolver.impl.LocalDynamicMetadataResolver;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class LocalDynamicMetadataResolverTest
extends XMLObjectBaseTestCase {
    private LocalDynamicMetadataResolver resolver;
    private MapLoadSaveManager<XMLObject> sourceManager;
    private String entityID1;
    private String entityID2;
    private EntityDescriptor entity1;
    private EntityDescriptor entity2;
    private StringDigester sha1Digester;

    @BeforeMethod
    public void setUp() throws NoSuchAlgorithmException, ComponentInitializationException {
        this.sha1Digester = new StringDigester("SHA-1", StringDigester.OutputFormat.HEX_LOWER);
        this.sourceManager = new MapLoadSaveManager();
        this.entityID1 = "urn:test:entity1";
        this.entityID2 = "urn:test:entity2";
        this.entity1 = (EntityDescriptor)this.buildXMLObject(EntityDescriptor.DEFAULT_ELEMENT_NAME);
        this.entity1.setEntityID(this.entityID1);
        this.entity2 = (EntityDescriptor)this.buildXMLObject(EntityDescriptor.DEFAULT_ELEMENT_NAME);
        this.entity2.setEntityID(this.entityID2);
        this.resolver = new LocalDynamicMetadataResolver(this.sourceManager);
        this.resolver.setId("abc123");
        this.resolver.setParserPool(parserPool);
        this.resolver.setNegativeLookupCacheDuration(Long.valueOf(1000L));
        this.resolver.initialize();
    }

    @AfterMethod
    public void tearDown() {
        if (this.resolver != null) {
            this.resolver.destroy();
        }
    }

    @Test
    public void testEmptySource() throws ResolverException {
        Assert.assertNull((Object)this.resolver.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion(this.entityID1)})));
        Assert.assertNull((Object)this.resolver.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion(this.entityID2)})));
    }

    @Test
    public void testBasicResolveLifecycle() throws ResolverException, IOException {
        this.sourceManager.save(this.sha1Digester.apply(this.entityID1), (XMLObject)this.entity1);
        Assert.assertSame((Object)this.resolver.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion(this.entityID1)})), (Object)this.entity1);
        Assert.assertNull((Object)this.resolver.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion(this.entityID2)})));
        this.sourceManager.save(this.sha1Digester.apply(this.entityID2), (XMLObject)this.entity2);
        Uninterruptibles.sleepUninterruptibly((long)(this.resolver.getNegativeLookupCacheDuration() + 150L), (TimeUnit)TimeUnit.MILLISECONDS);
        Assert.assertSame((Object)this.resolver.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion(this.entityID2)})), (Object)this.entity2);
        this.sourceManager.remove(this.sha1Digester.apply(this.entityID1));
        this.sourceManager.remove(this.sha1Digester.apply(this.entityID2));
        Assert.assertNull((Object)this.sourceManager.load(this.sha1Digester.apply(this.entityID1)));
        Assert.assertNull((Object)this.sourceManager.load(this.sha1Digester.apply(this.entityID2)));
        Assert.assertSame((Object)this.resolver.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion(this.entityID1)})), (Object)this.entity1);
        Assert.assertSame((Object)this.resolver.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion(this.entityID2)})), (Object)this.entity2);
    }

    @Test
    public void testConditionalLoadManagerWithClearEntityID() throws IOException, ResolverException, ComponentInitializationException {
        this.sourceManager = new MapLoadSaveManager(true);
        this.resolver = new LocalDynamicMetadataResolver(this.sourceManager);
        this.resolver.setId("abc123");
        this.resolver.setParserPool(parserPool);
        this.resolver.initialize();
        this.sourceManager.save(this.sha1Digester.apply(this.entityID1), (XMLObject)this.entity1);
        Assert.assertSame((Object)this.resolver.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion(this.entityID1)})), (Object)this.entity1);
        Assert.assertSame((Object)this.resolver.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion(this.entityID1)})), (Object)this.entity1);
        this.resolver.clear(this.entityID1);
        Assert.assertNull(this.resolver.getBackingStore().getIndexedDescriptors().get(this.entityID1));
        Assert.assertFalse((boolean)this.resolver.getBackingStore().getOrderedDescriptors().contains(this.entity1));
        Assert.assertSame((Object)this.resolver.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion(this.entityID1)})), (Object)this.entity1);
        Assert.assertSame((Object)this.resolver.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion(this.entityID1)})), (Object)this.entity1);
    }

    @Test
    public void testCtorSourceKeyGenerator() throws ComponentInitializationException, IOException, ResolverException {
        this.resolver.destroy();
        this.resolver = new LocalDynamicMetadataResolver(null, this.sourceManager, (Function)new IdentityEntityIDGenerator());
        this.resolver.setId("abc123");
        this.resolver.setParserPool(parserPool);
        this.resolver.initialize();
        this.sourceManager.save(this.entityID1, (XMLObject)this.entity1);
        Assert.assertSame((Object)this.resolver.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion(this.entityID1)})), (Object)this.entity1);
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testCtorMissingManager() {
        this.resolver = new LocalDynamicMetadataResolver(null);
    }
}

