/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.impl;

import com.google.common.io.Resources;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.httpclient.HttpClientBuilder;
import net.shibboleth.utilities.java.support.repository.RepositorySupport;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.core.xml.XMLObjectBaseTestCase;
import org.opensaml.saml.metadata.resolver.impl.FileBackedHTTPMetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.HTTPMetadataResolverTest;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.security.httpclient.HttpClientSecurityParameters;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class FileBackedHTTPMetadataResolverTest
extends XMLObjectBaseTestCase {
    private HttpClientBuilder httpClientBuilder;
    private String relativeMDResource;
    private String metadataURLHttps;
    private String metadataURLHttp;
    private String badMDURL;
    private String backupFilePath;
    private FileBackedHTTPMetadataResolver metadataProvider;
    private String entityID;
    private CriteriaSet criteriaSet;

    @BeforeMethod
    protected void setUp() throws Exception {
        this.httpClientBuilder = new HttpClientBuilder();
        this.relativeMDResource = "org/opensaml/saml/metadata/resolver/impl/08ced64cddc9f1578598b2cf71ae747b11d11472.xml";
        this.metadataURLHttps = RepositorySupport.buildHTTPSResourceURL((String)"java-opensaml", (String)String.format("opensaml-saml-impl/src/test/resources/%s", this.relativeMDResource));
        this.metadataURLHttp = RepositorySupport.buildHTTPResourceURL((String)"java-opensaml", (String)String.format("opensaml-saml-impl/src/test/resources/%s", this.relativeMDResource), (boolean)false);
        this.entityID = "https://www.example.org/sp";
        this.badMDURL = "http://www.opensaml.org/foo/bar/baz/samlmd";
        this.backupFilePath = System.getProperty("java.io.tmpdir") + System.getProperty("file.separator") + "filebacked-http-metadata.xml";
        this.criteriaSet = new CriteriaSet(new Criterion[]{new EntityIdCriterion(this.entityID)});
    }

    @AfterMethod
    protected void tearDown() throws IOException {
        Path nioBackupFilePath = Paths.get(this.backupFilePath, new String[0]);
        Files.deleteIfExists(nioBackupFilePath);
    }

    @Test
    public void testGetEntityDescriptor() throws Exception {
        this.metadataProvider = new FileBackedHTTPMetadataResolver(this.httpClientBuilder.buildClient(), this.metadataURLHttp, this.backupFilePath);
        this.metadataProvider.setParserPool(parserPool);
        this.metadataProvider.setId("test");
        this.metadataProvider.initialize();
        Assert.assertFalse((boolean)this.metadataProvider.isInitializedFromBackupFile());
        EntityDescriptor descriptor = this.metadataProvider.resolveSingle(this.criteriaSet);
        Assert.assertNotNull((Object)descriptor, (String)"Retrieved entity descriptor was null");
        Assert.assertEquals((String)descriptor.getEntityID(), (String)this.entityID, (String)"Entity's ID does not match requested ID");
    }

    @Test
    public void testFailFastBadURL() throws Exception {
        this.metadataProvider = new FileBackedHTTPMetadataResolver(this.httpClientBuilder.buildClient(), this.badMDURL, this.backupFilePath);
        this.metadataProvider.setFailFastInitialization(true);
        this.metadataProvider.setParserPool(parserPool);
        try {
            this.metadataProvider.initialize();
            Assert.fail((String)"metadata provider claims to have parsed known invalid data");
        }
        catch (ComponentInitializationException componentInitializationException) {
            // empty catch block
        }
    }

    @Test
    public void testNoFailFastBadURL() throws Exception {
        this.metadataProvider = new FileBackedHTTPMetadataResolver(this.httpClientBuilder.buildClient(), this.badMDURL, this.backupFilePath);
        this.metadataProvider.setFailFastInitialization(false);
        this.metadataProvider.setId("test");
        this.metadataProvider.setParserPool(parserPool);
        try {
            this.metadataProvider.initialize();
        }
        catch (ComponentInitializationException e) {
            Assert.fail((String)"Provider failed init with fail-fast=false");
        }
        EntityDescriptor descriptor = this.metadataProvider.resolveSingle(this.criteriaSet);
        Assert.assertNull((Object)descriptor);
    }

    @Test
    public void testFailFastBadBackupFile() throws Exception {
        try {
            this.metadataProvider = new FileBackedHTTPMetadataResolver(this.httpClientBuilder.buildClient(), this.metadataURLHttps, System.getProperty("java.io.tmpdir"));
        }
        catch (ResolverException e) {
            Assert.fail((String)"Provider failed bad backup file in constructor");
        }
        this.metadataProvider.setFailFastInitialization(true);
        this.metadataProvider.setParserPool(parserPool);
        try {
            this.metadataProvider.initialize();
            Assert.fail((String)"Provider passed init with bad backup file, fail-fast=true");
        }
        catch (ComponentInitializationException componentInitializationException) {
            // empty catch block
        }
    }

    @Test
    public void testNoFailFastBadBackupFile() throws Exception {
        try {
            this.metadataProvider = new FileBackedHTTPMetadataResolver(this.httpClientBuilder.buildClient(), this.metadataURLHttp, System.getProperty("java.io.tmpdir"));
        }
        catch (ResolverException e) {
            Assert.fail((String)"Provider failed bad backup file in constructor");
        }
        this.metadataProvider.setFailFastInitialization(false);
        this.metadataProvider.setParserPool(parserPool);
        this.metadataProvider.setId("test");
        try {
            this.metadataProvider.initialize();
            Assert.assertFalse((boolean)this.metadataProvider.isInitializedFromBackupFile());
        }
        catch (ComponentInitializationException e) {
            Assert.fail((String)"Provider failed init with bad backup file, fail-fast=false");
        }
        Assert.assertNotNull((Object)this.metadataProvider.resolveSingle(this.criteriaSet), (String)"Metadata retrieved from backing file was null");
    }

    @Test
    public void testInitFromBackupFile() throws Exception {
        File backupFile = new File(this.backupFilePath);
        try (FileOutputStream backupFileOutputStream = new FileOutputStream(backupFile);){
            Resources.copy((URL)Resources.getResource((String)this.relativeMDResource), (OutputStream)backupFileOutputStream);
        }
        Assert.assertTrue((boolean)backupFile.exists(), (String)"Backup file was not created");
        Assert.assertTrue((backupFile.length() > 0L ? 1 : 0) != 0, (String)"Backup file contains no data");
        this.metadataProvider = new FileBackedHTTPMetadataResolver(this.httpClientBuilder.buildClient(), this.metadataURLHttp, this.backupFilePath);
        this.metadataProvider.setParserPool(parserPool);
        this.metadataProvider.setFailFastInitialization(true);
        this.metadataProvider.setId("test");
        this.metadataProvider.setBackupFileInitNextRefreshDelay(1000L);
        this.metadataProvider.initialize();
        Assert.assertTrue((boolean)this.metadataProvider.isInitializedFromBackupFile());
        DateTime initRefresh = this.metadataProvider.getLastRefresh();
        DateTime initUpdate = this.metadataProvider.getLastUpdate();
        Assert.assertNotNull((Object)this.metadataProvider.resolveSingle(this.criteriaSet), (String)"Metadata inited from backing file was null");
        Thread.sleep(this.metadataProvider.getBackupFileInitNextRefreshDelay() + 5000L);
        Assert.assertTrue((boolean)initRefresh.isBefore((ReadableInstant)this.metadataProvider.getLastRefresh()));
        Assert.assertTrue((boolean)initUpdate.isBefore((ReadableInstant)this.metadataProvider.getLastUpdate()));
        Assert.assertNotNull((Object)this.metadataProvider.resolveSingle(this.criteriaSet), (String)"Metadata retrieved from HTTP refreshed metadata was null");
    }

    @Test
    public void testNoBackupFileLoadWhenMetadataCached() throws Exception {
        File backupFile = new File(this.backupFilePath);
        try (FileOutputStream backupFileOutputStream = new FileOutputStream(backupFile);){
            Resources.copy((URL)Resources.getResource((String)this.relativeMDResource), (OutputStream)backupFileOutputStream);
        }
        Assert.assertTrue((boolean)backupFile.exists(), (String)"Backup file was not created");
        Assert.assertTrue((backupFile.length() > 0L ? 1 : 0) != 0, (String)"Backup file contains no data");
        this.metadataProvider = new FileBackedHTTPMetadataResolver(this.httpClientBuilder.buildClient(), this.badMDURL, this.backupFilePath);
        this.metadataProvider.setParserPool(parserPool);
        this.metadataProvider.setFailFastInitialization(true);
        this.metadataProvider.setId("test");
        this.metadataProvider.initialize();
        Assert.assertTrue((boolean)this.metadataProvider.isInitializedFromBackupFile());
        DateTime initRefresh = this.metadataProvider.getLastRefresh();
        DateTime initUpdate = this.metadataProvider.getLastUpdate();
        Assert.assertNotNull((Object)this.metadataProvider.resolveSingle(this.criteriaSet), (String)"Metadata retrieved from backing file was null");
        Thread.sleep(1000L);
        this.metadataProvider.refresh();
        Assert.assertTrue((boolean)initRefresh.isBefore((ReadableInstant)this.metadataProvider.getLastRefresh()));
        Assert.assertEquals((Object)initUpdate, (Object)this.metadataProvider.getLastUpdate());
        Assert.assertNotNull((Object)this.metadataProvider.resolveSingle(this.criteriaSet), (String)"Metadata retrieved from cached metadata was null");
    }

    @Test
    public void testTrustEngineSocketFactoryNoHTTPSNoTrustEngine() throws Exception {
        this.httpClientBuilder.setTLSSocketFactory(HTTPMetadataResolverTest.buildTrustEngineSocketFactory(false));
        this.metadataProvider = new FileBackedHTTPMetadataResolver(this.httpClientBuilder.buildClient(), this.metadataURLHttps, this.backupFilePath);
        this.metadataProvider.setParserPool(parserPool);
        this.metadataProvider.setId("test");
        this.metadataProvider.initialize();
        EntityDescriptor descriptor = this.metadataProvider.resolveSingle(this.criteriaSet);
        Assert.assertNotNull((Object)descriptor, (String)"Retrieved entity descriptor was null");
        Assert.assertEquals((String)descriptor.getEntityID(), (String)this.entityID, (String)"Entity's ID does not match requested ID");
    }

    @Test
    public void testTrustEngineSocketFactoryNoHTTPSWithTrustEngine() throws Exception {
        this.httpClientBuilder.setTLSSocketFactory(HTTPMetadataResolverTest.buildTrustEngineSocketFactory());
        this.metadataProvider = new FileBackedHTTPMetadataResolver(this.httpClientBuilder.buildClient(), this.metadataURLHttps, this.backupFilePath);
        this.metadataProvider.setParserPool(parserPool);
        this.metadataProvider.setId("test");
        HttpClientSecurityParameters params = new HttpClientSecurityParameters();
        params.setTLSTrustEngine(HTTPMetadataResolverTest.buildExplicitKeyTrustEngine("repo-entity.crt"));
        this.metadataProvider.setHttpClientSecurityParameters(params);
        this.metadataProvider.initialize();
        EntityDescriptor descriptor = this.metadataProvider.resolveSingle(this.criteriaSet);
        Assert.assertNotNull((Object)descriptor, (String)"Retrieved entity descriptor was null");
        Assert.assertEquals((String)descriptor.getEntityID(), (String)this.entityID, (String)"Entity's ID does not match requested ID");
    }

    @Test
    public void testHTTPSNoTrustEngine() throws Exception {
        this.httpClientBuilder.setTLSSocketFactory(HTTPMetadataResolverTest.buildTrustEngineSocketFactory(false));
        this.metadataProvider = new FileBackedHTTPMetadataResolver(this.httpClientBuilder.buildClient(), this.metadataURLHttps, this.backupFilePath);
        this.metadataProvider.setParserPool(parserPool);
        this.metadataProvider.setId("test");
        this.metadataProvider.initialize();
        EntityDescriptor descriptor = this.metadataProvider.resolveSingle(this.criteriaSet);
        Assert.assertNotNull((Object)descriptor, (String)"Retrieved entity descriptor was null");
        Assert.assertEquals((String)descriptor.getEntityID(), (String)this.entityID, (String)"Entity's ID does not match requested ID");
    }

    @Test
    public void testHTTPSTrustEngineExplicitKey() throws Exception {
        this.httpClientBuilder.setTLSSocketFactory(HTTPMetadataResolverTest.buildTrustEngineSocketFactory());
        this.metadataProvider = new FileBackedHTTPMetadataResolver(this.httpClientBuilder.buildClient(), this.metadataURLHttps, this.backupFilePath);
        this.metadataProvider.setParserPool(parserPool);
        this.metadataProvider.setId("test");
        HttpClientSecurityParameters params = new HttpClientSecurityParameters();
        params.setTLSTrustEngine(HTTPMetadataResolverTest.buildExplicitKeyTrustEngine("repo-entity.crt"));
        this.metadataProvider.setHttpClientSecurityParameters(params);
        this.metadataProvider.initialize();
        EntityDescriptor descriptor = this.metadataProvider.resolveSingle(this.criteriaSet);
        Assert.assertNotNull((Object)descriptor, (String)"Retrieved entity descriptor was null");
        Assert.assertEquals((String)descriptor.getEntityID(), (String)this.entityID, (String)"Entity's ID does not match requested ID");
    }

    @Test(expectedExceptions={ComponentInitializationException.class})
    public void testHTTPSTrustEngineInvalidKey() throws Exception {
        this.httpClientBuilder.setTLSSocketFactory(HTTPMetadataResolverTest.buildTrustEngineSocketFactory());
        this.metadataProvider = new FileBackedHTTPMetadataResolver(this.httpClientBuilder.buildClient(), this.metadataURLHttps, this.backupFilePath);
        this.metadataProvider.setParserPool(parserPool);
        this.metadataProvider.setId("test");
        HttpClientSecurityParameters params = new HttpClientSecurityParameters();
        params.setTLSTrustEngine(HTTPMetadataResolverTest.buildExplicitKeyTrustEngine("badKey.crt"));
        this.metadataProvider.setHttpClientSecurityParameters(params);
        this.metadataProvider.initialize();
        EntityDescriptor descriptor = this.metadataProvider.resolveSingle(this.criteriaSet);
        Assert.assertNotNull((Object)descriptor, (String)"Retrieved entity descriptor was null");
        Assert.assertEquals((String)descriptor.getEntityID(), (String)this.entityID, (String)"Entity's ID does not match requested ID");
    }

    @Test(enabled=false)
    public void testHTTPSTrustEngineValidPKIX() throws Exception {
        this.httpClientBuilder.setTLSSocketFactory(HTTPMetadataResolverTest.buildTrustEngineSocketFactory());
        this.metadataProvider = new FileBackedHTTPMetadataResolver(this.httpClientBuilder.buildClient(), this.metadataURLHttps, this.backupFilePath);
        this.metadataProvider.setParserPool(parserPool);
        this.metadataProvider.setId("test");
        HttpClientSecurityParameters params = new HttpClientSecurityParameters();
        params.setTLSTrustEngine(HTTPMetadataResolverTest.buildPKIXTrustEngine("repo-rootCA.crt", null, false));
        this.metadataProvider.setHttpClientSecurityParameters(params);
        this.metadataProvider.initialize();
        EntityDescriptor descriptor = this.metadataProvider.resolveSingle(this.criteriaSet);
        Assert.assertNotNull((Object)descriptor, (String)"Retrieved entity descriptor was null");
        Assert.assertEquals((String)descriptor.getEntityID(), (String)this.entityID, (String)"Entity's ID does not match requested ID");
    }

    @Test(enabled=false)
    public void testHTTPSTrustEngineValidPKIXExplicitName() throws Exception {
        this.httpClientBuilder.setTLSSocketFactory(HTTPMetadataResolverTest.buildTrustEngineSocketFactory());
        this.metadataProvider = new FileBackedHTTPMetadataResolver(this.httpClientBuilder.buildClient(), this.metadataURLHttps, this.backupFilePath);
        this.metadataProvider.setParserPool(parserPool);
        this.metadataProvider.setId("test");
        HttpClientSecurityParameters params = new HttpClientSecurityParameters();
        params.setTLSTrustEngine(HTTPMetadataResolverTest.buildPKIXTrustEngine("repo-rootCA.crt", "test.shibboleth.net", true));
        this.metadataProvider.setHttpClientSecurityParameters(params);
        this.metadataProvider.initialize();
        EntityDescriptor descriptor = this.metadataProvider.resolveSingle(this.criteriaSet);
        Assert.assertNotNull((Object)descriptor, (String)"Retrieved entity descriptor was null");
        Assert.assertEquals((String)descriptor.getEntityID(), (String)this.entityID, (String)"Entity's ID does not match requested ID");
    }

    @Test(expectedExceptions={ComponentInitializationException.class})
    public void testHTTPSTrustEngineInvalidPKIX() throws Exception {
        this.httpClientBuilder.setTLSSocketFactory(HTTPMetadataResolverTest.buildTrustEngineSocketFactory());
        this.metadataProvider = new FileBackedHTTPMetadataResolver(this.httpClientBuilder.buildClient(), this.metadataURLHttps, this.backupFilePath);
        this.metadataProvider.setParserPool(parserPool);
        this.metadataProvider.setId("test");
        HttpClientSecurityParameters params = new HttpClientSecurityParameters();
        params.setTLSTrustEngine(HTTPMetadataResolverTest.buildPKIXTrustEngine("badCA.crt", null, false));
        this.metadataProvider.setHttpClientSecurityParameters(params);
        this.metadataProvider.initialize();
        EntityDescriptor descriptor = this.metadataProvider.resolveSingle(this.criteriaSet);
        Assert.assertNotNull((Object)descriptor, (String)"Retrieved entity descriptor was null");
        Assert.assertEquals((String)descriptor.getEntityID(), (String)this.entityID, (String)"Entity's ID does not match requested ID");
    }

    @Test(expectedExceptions={ComponentInitializationException.class})
    public void testHTTPSTrustEngineValidPKIXInvalidName() throws Exception {
        this.httpClientBuilder.setTLSSocketFactory(HTTPMetadataResolverTest.buildTrustEngineSocketFactory());
        this.metadataProvider = new FileBackedHTTPMetadataResolver(this.httpClientBuilder.buildClient(), this.metadataURLHttps, this.backupFilePath);
        this.metadataProvider.setParserPool(parserPool);
        this.metadataProvider.setId("test");
        HttpClientSecurityParameters params = new HttpClientSecurityParameters();
        params.setTLSTrustEngine(HTTPMetadataResolverTest.buildPKIXTrustEngine("repo-rootCA.crt", "foobar.shibboleth.net", true));
        this.metadataProvider.setHttpClientSecurityParameters(params);
        this.metadataProvider.initialize();
        EntityDescriptor descriptor = this.metadataProvider.resolveSingle(this.criteriaSet);
        Assert.assertNotNull((Object)descriptor, (String)"Retrieved entity descriptor was null");
        Assert.assertEquals((String)descriptor.getEntityID(), (String)this.entityID, (String)"Entity's ID does not match requested ID");
    }

    @Test(expectedExceptions={ComponentInitializationException.class})
    public void testHTTPSTrustEngineWrongSocketFactory() throws Exception {
        this.metadataProvider = new FileBackedHTTPMetadataResolver(this.httpClientBuilder.buildClient(), this.metadataURLHttps, this.backupFilePath);
        this.metadataProvider.setParserPool(parserPool);
        this.metadataProvider.setId("test");
        HttpClientSecurityParameters params = new HttpClientSecurityParameters();
        params.setTLSTrustEngine(HTTPMetadataResolverTest.buildExplicitKeyTrustEngine("repo-entity.crt"));
        this.metadataProvider.setHttpClientSecurityParameters(params);
        this.metadataProvider.initialize();
        EntityDescriptor descriptor = this.metadataProvider.resolveSingle(this.criteriaSet);
        Assert.assertNotNull((Object)descriptor, (String)"Retrieved entity descriptor was null");
        Assert.assertEquals((String)descriptor.getEntityID(), (String)this.entityID, (String)"Entity's ID does not match requested ID");
    }
}

