/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.impl;

import com.google.common.io.BaseEncoding;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.saml.common.binding.artifact.SAMLArtifact;
import org.opensaml.saml.common.binding.artifact.SAMLSourceIDArtifact;
import org.opensaml.saml.common.binding.artifact.SAMLSourceLocationArtifact;
import org.opensaml.saml.criterion.ArtifactCriterion;
import org.opensaml.saml.metadata.resolver.impl.DefaultLocalDynamicSourceKeyGenerator;
import org.opensaml.saml.metadata.resolver.index.impl.SimpleStringCriterion;
import org.opensaml.saml.saml1.binding.artifact.SAML1ArtifactType0002;
import org.opensaml.saml.saml2.binding.artifact.SAML2ArtifactType0004;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class DefaultLocalDynamicSourceKeyGeneratorTest {
    private String controlValue;
    private String controlValueSHA1Hex;
    private byte[] controlValueSHA1Bytes;
    private SAMLSourceIDArtifact sourceIDArtifact;
    private SAMLSourceLocationArtifact sourceLocationArtifact;
    private CriteriaSet criteria;
    private DefaultLocalDynamicSourceKeyGenerator generator;

    @BeforeMethod
    public void setUp() throws NoSuchAlgorithmException {
        this.controlValue = "urn:test:foobar";
        this.controlValueSHA1Hex = "d278c9975472a6b4827b1a8723192b4e99aa969c";
        this.controlValueSHA1Bytes = BaseEncoding.base16().lowerCase().decode((CharSequence)this.controlValueSHA1Hex);
        this.criteria = new CriteriaSet();
        SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
        byte[] messageHandle = new byte[20];
        secureRandom.nextBytes(messageHandle);
        this.sourceIDArtifact = new SAML2ArtifactType0004(new byte[]{0, 0}, this.controlValueSHA1Bytes, messageHandle);
        this.sourceLocationArtifact = new SAML1ArtifactType0002(messageHandle, "https://test.foobar.com/artifactk");
    }

    @Test
    public void testEntityIdCriterion() throws NoSuchAlgorithmException {
        this.generator = new DefaultLocalDynamicSourceKeyGenerator();
        Assert.assertNull((Object)this.generator.apply(null));
        this.criteria.clear();
        Assert.assertNull((Object)this.generator.apply(this.criteria));
        this.criteria.add((Object)new EntityIdCriterion(this.controlValue));
        Assert.assertEquals((String)this.controlValueSHA1Hex, (String)this.generator.apply(this.criteria));
        this.generator = new DefaultLocalDynamicSourceKeyGenerator("metadata-", ".xml", null);
        Assert.assertEquals((String)("metadata-" + this.controlValueSHA1Hex + ".xml"), (String)this.generator.apply(this.criteria));
        this.generator = new DefaultLocalDynamicSourceKeyGenerator("metadata", "xml", ".");
        Assert.assertEquals((String)("metadata." + this.controlValueSHA1Hex + ".xml"), (String)this.generator.apply(this.criteria));
    }

    @Test
    public void testArtifactCriterion() throws NoSuchAlgorithmException {
        this.generator = new DefaultLocalDynamicSourceKeyGenerator();
        Assert.assertNull((Object)this.generator.apply(null));
        this.criteria.clear();
        Assert.assertNull((Object)this.generator.apply(this.criteria));
        this.criteria.add((Object)new ArtifactCriterion((SAMLArtifact)this.sourceIDArtifact));
        Assert.assertEquals((String)this.controlValueSHA1Hex, (String)this.generator.apply(this.criteria));
        this.generator = new DefaultLocalDynamicSourceKeyGenerator("metadata-", ".xml", null);
        Assert.assertEquals((String)("metadata-" + this.controlValueSHA1Hex + ".xml"), (String)this.generator.apply(this.criteria));
        this.generator = new DefaultLocalDynamicSourceKeyGenerator("metadata", "xml", ".");
        Assert.assertEquals((String)("metadata." + this.controlValueSHA1Hex + ".xml"), (String)this.generator.apply(this.criteria));
        this.criteria.clear();
        this.criteria.add((Object)new ArtifactCriterion((SAMLArtifact)this.sourceLocationArtifact));
        Assert.assertNull((Object)this.generator.apply(this.criteria));
    }

    @Test
    public void testUnsupportedCriterion() {
        this.generator = new DefaultLocalDynamicSourceKeyGenerator();
        this.criteria.add((Object)new SimpleStringCriterion("foobar"));
        Assert.assertNull((Object)this.generator.apply(this.criteria));
    }
}

