/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.filter.impl;

import java.io.File;
import java.net.URL;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.chrono.ISOChronology;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBaseTestCase;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilter;
import org.opensaml.saml.metadata.resolver.filter.impl.RequiredValidUntilFilter;
import org.opensaml.saml.metadata.resolver.impl.FilesystemMetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.FilesystemMetadataResolverTest;
import org.opensaml.saml.saml2.metadata.EntitiesDescriptor;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class RequiredValidUntilTest
extends XMLObjectBaseTestCase {
    private File metadataFile;

    @BeforeMethod
    protected void setUp() throws Exception {
        URL mdURL = FilesystemMetadataResolverTest.class.getResource("/org/opensaml/saml/saml2/metadata/simple-metadata.xml");
        this.metadataFile = new File(mdURL.toURI());
    }

    @Test
    public void testRequiredValidUntil() throws Exception {
        RequiredValidUntilFilter filter = new RequiredValidUntilFilter();
        FilesystemMetadataResolver metadataProvider = new FilesystemMetadataResolver(this.metadataFile);
        metadataProvider.setParserPool(parserPool);
        metadataProvider.setId("test");
        metadataProvider.setMetadataFilter((MetadataFilter)filter);
        try {
            metadataProvider.initialize();
        }
        catch (ComponentInitializationException e) {
            Assert.fail((String)"Filter disallowed metadata that contained a proper validUntil attribute");
        }
    }

    @Test
    public void testRequiredValidUntilWithMaxValidity() throws Exception {
        RequiredValidUntilFilter filter = new RequiredValidUntilFilter(1L);
        FilesystemMetadataResolver metadataProvider = new FilesystemMetadataResolver(this.metadataFile);
        metadataProvider.setParserPool(parserPool);
        metadataProvider.setId("test");
        metadataProvider.setMetadataFilter((MetadataFilter)filter);
        try {
            metadataProvider.initialize();
            Assert.fail((String)"Filter accepted metadata with longer than allowed validity period.");
        }
        catch (ComponentInitializationException e) {
            return;
        }
    }

    @Test
    public void testRequiredValidUntilWithMaxValiditySetter() throws Exception {
        RequiredValidUntilFilter filter = new RequiredValidUntilFilter();
        filter.setMaxValidityInterval(1L);
        FilesystemMetadataResolver metadataProvider = new FilesystemMetadataResolver(this.metadataFile);
        metadataProvider.setParserPool(parserPool);
        metadataProvider.setId("test");
        metadataProvider.setMetadataFilter((MetadataFilter)filter);
        try {
            metadataProvider.initialize();
            Assert.fail((String)"Filter accepted metadata with longer than allowed validity period.");
        }
        catch (ComponentInitializationException e) {
            return;
        }
    }

    @Test
    public void testRequiredValidUntilAlreadyPast() throws Exception {
        SAMLObjectBuilder entitiesDescriptorBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(EntitiesDescriptor.TYPE_NAME);
        EntitiesDescriptor descriptor = (EntitiesDescriptor)entitiesDescriptorBuilder.buildObject();
        descriptor.setValidUntil(new DateTime((Chronology)ISOChronology.getInstanceUTC()).minus(10000L));
        RequiredValidUntilFilter filter = new RequiredValidUntilFilter(-1L);
        filter.filter((XMLObject)descriptor);
        filter = new RequiredValidUntilFilter();
        filter.filter((XMLObject)descriptor);
    }
}

