/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.filter.impl;

import com.google.common.base.Predicate;
import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.core.xml.XMLObjectBaseTestCase;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilter;
import org.opensaml.saml.metadata.resolver.filter.impl.NameIDFormatFilter;
import org.opensaml.saml.metadata.resolver.impl.FilesystemMetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.FilesystemMetadataResolverTest;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class NameIDFormatFilterTest
extends XMLObjectBaseTestCase
implements Predicate<EntityDescriptor> {
    private FilesystemMetadataResolver metadataProvider;
    private File mdFile;
    private NameIDFormatFilter metadataFilter;
    private Collection<String> formats;

    @BeforeMethod
    protected void setUp() throws Exception {
        URL mdURL = FilesystemMetadataResolverTest.class.getResource("/org/opensaml/saml/saml2/metadata/InCommon-metadata.xml");
        this.mdFile = new File(mdURL.toURI());
        this.metadataProvider = new FilesystemMetadataResolver(this.mdFile);
        this.metadataProvider.setParserPool(parserPool);
        this.metadataFilter = new NameIDFormatFilter();
        this.formats = Arrays.asList("urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress", "urn:oasis:names:tc:SAML:2.0:nameid-format:kerberos");
    }

    @Test
    public void test() throws ComponentInitializationException, ResolverException {
        this.metadataFilter.setRules(Collections.singletonMap(this, this.formats));
        this.metadataFilter.initialize();
        this.metadataProvider.setMetadataFilter((MetadataFilter)this.metadataFilter);
        this.metadataProvider.setId("test");
        this.metadataProvider.initialize();
        EntityIdCriterion key = new EntityIdCriterion("https://carmenwiki.osu.edu/shibboleth");
        EntityDescriptor entity = this.metadataProvider.resolveSingle(new CriteriaSet(new Criterion[]{key}));
        Assert.assertNotNull((Object)entity);
        Assert.assertEquals((int)entity.getSPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol").getNameIDFormats().size(), (int)3);
        key = new EntityIdCriterion("https://cms.psu.edu/Shibboleth");
        entity = this.metadataProvider.resolveSingle(new CriteriaSet(new Criterion[]{key}));
        Assert.assertNotNull((Object)entity);
        Assert.assertEquals((int)entity.getSPSSODescriptor("urn:oasis:names:tc:SAML:1.1:protocol").getNameIDFormats().size(), (int)1);
    }

    @Test
    public void testWithRemoval() throws ComponentInitializationException, ResolverException {
        this.metadataFilter.setRules(Collections.singletonMap(this, this.formats));
        this.metadataFilter.setRemoveExistingFormats(true);
        this.metadataFilter.initialize();
        this.metadataProvider.setMetadataFilter((MetadataFilter)this.metadataFilter);
        this.metadataProvider.setId("test");
        this.metadataProvider.initialize();
        EntityIdCriterion key = new EntityIdCriterion("https://carmenwiki.osu.edu/shibboleth");
        EntityDescriptor entity = this.metadataProvider.resolveSingle(new CriteriaSet(new Criterion[]{key}));
        Assert.assertNotNull((Object)entity);
        Assert.assertEquals((int)entity.getSPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol").getNameIDFormats().size(), (int)2);
    }

    public boolean apply(EntityDescriptor input) {
        return input.getEntityID().equals("https://carmenwiki.osu.edu/shibboleth");
    }
}

