/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.ext.saml2mdrpi.impl;

import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.chrono.ISOChronology;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.saml.ext.saml2mdrpi.PublicationInfo;
import org.opensaml.saml.ext.saml2mdrpi.UsagePolicy;
import org.testng.Assert;
import org.testng.annotations.Test;

public class PublicationInfoTest
extends XMLObjectProviderBaseTestCase {
    private static String expectedPublisher = "publisher";
    private static String expectedPublicationId = "Ident";
    private static DateTime expectedCreationInstant = new DateTime(2010, 8, 11, 14, 59, 1, 2, (Chronology)ISOChronology.getInstanceUTC());
    private static String[] langs = new String[]{"en", "fr"};
    private static String[] uris = new String[]{"https://www.aai.dfn.de/en/join/", "https://www.example.fr/fr/"};

    public PublicationInfoTest() {
        this.singleElementFile = "/org/opensaml/saml/ext/saml2mdrpi/PublicationInfo.xml";
        this.singleElementOptionalAttributesFile = "/org/opensaml/saml/ext/saml2mdrpi/PublicationInfoOptionalAttr.xml";
        this.childElementsFile = "/org/opensaml/saml/ext/saml2mdrpi/PublicationInfoChildren.xml";
    }

    @Test
    public void testSingleElementUnmarshall() {
        PublicationInfo info = (PublicationInfo)this.unmarshallElement(this.singleElementFile);
        Assert.assertEquals((String)info.getPublisher(), (String)expectedPublisher);
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
        PublicationInfo info = (PublicationInfo)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        Assert.assertEquals((String)info.getPublisher(), (String)expectedPublisher);
        Assert.assertEquals((String)info.getPublicationId(), (String)expectedPublicationId);
        Assert.assertEquals((Object)info.getCreationInstant(), (Object)expectedCreationInstant);
    }

    @Test
    public void testSingleElementMarshall() {
        PublicationInfo info = (PublicationInfo)this.buildXMLObject(PublicationInfo.DEFAULT_ELEMENT_NAME);
        info.setPublisher(expectedPublisher);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)info);
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
        PublicationInfo info = (PublicationInfo)this.buildXMLObject(PublicationInfo.DEFAULT_ELEMENT_NAME);
        info.setPublisher(expectedPublisher);
        info.setCreationInstant(expectedCreationInstant);
        info.setPublicationId(expectedPublicationId);
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)info);
    }

    @Test
    public void testChildElementsUnmarshall() {
        PublicationInfo info = (PublicationInfo)this.unmarshallElement(this.childElementsFile);
        Assert.assertEquals((String)info.getPublisher(), (String)expectedPublisher);
        UsagePolicy policy = (UsagePolicy)info.getUsagePolicies().get(0);
        Assert.assertEquals((String)policy.getXMLLang(), (String)langs[0]);
        Assert.assertEquals((String)policy.getValue(), (String)uris[0]);
        policy = (UsagePolicy)info.getUsagePolicies().get(1);
        Assert.assertEquals((String)policy.getXMLLang(), (String)langs[1]);
        Assert.assertEquals((String)policy.getValue(), (String)uris[1]);
    }

    @Test
    public void testChildElementsMarshall() {
        PublicationInfo info = (PublicationInfo)this.buildXMLObject(PublicationInfo.DEFAULT_ELEMENT_NAME);
        info.setPublisher(expectedPublisher);
        for (int i = 0; i < 2; ++i) {
            UsagePolicy policy = (UsagePolicy)this.buildXMLObject(UsagePolicy.DEFAULT_ELEMENT_NAME);
            policy.setValue(uris[i]);
            policy.setXMLLang(langs[i]);
            info.getUsagePolicies().add(policy);
        }
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)info);
    }
}

