/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.ext.saml2alg.impl;

import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.mock.SimpleXMLObject;
import org.opensaml.saml.ext.saml2alg.DigestMethod;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DigestMethodTest
extends XMLObjectProviderBaseTestCase {
    public DigestMethodTest() {
        this.singleElementFile = "/org/opensaml/saml/ext/saml2alg/impl/DigestMethod.xml";
        this.childElementsFile = "/org/opensaml/saml/ext/saml2alg/impl/DigestMethodChildElements.xml";
    }

    @Test
    public void testSingleElementUnmarshall() {
        DigestMethod digestMethod = (DigestMethod)this.unmarshallElement(this.singleElementFile);
        Assert.assertNotNull((Object)digestMethod);
        Assert.assertEquals((String)digestMethod.getAlgorithm(), (String)"http://www.w3.org/2001/04/xmlenc#sha256");
    }

    @Test
    public void testChildElementsUnmarshall() {
        DigestMethod digestMethod = (DigestMethod)this.unmarshallElement(this.childElementsFile);
        Assert.assertNotNull((Object)digestMethod);
        Assert.assertEquals((String)digestMethod.getAlgorithm(), (String)"http://www.w3.org/2001/04/xmlenc#sha256");
        Assert.assertEquals((int)digestMethod.getUnknownXMLObjects().size(), (int)3);
    }

    @Test
    public void testSingleElementMarshall() {
        DigestMethod digestMethod = (DigestMethod)this.buildXMLObject(DigestMethod.DEFAULT_ELEMENT_NAME);
        digestMethod.setAlgorithm("http://www.w3.org/2001/04/xmlenc#sha256");
        this.assertXMLEquals(this.expectedDOM, (XMLObject)digestMethod);
    }

    @Test
    public void testChildElementsMarshall() {
        DigestMethod digestMethod = (DigestMethod)this.buildXMLObject(DigestMethod.DEFAULT_ELEMENT_NAME);
        digestMethod.setAlgorithm("http://www.w3.org/2001/04/xmlenc#sha256");
        digestMethod.getUnknownXMLObjects().add(this.buildXMLObject(SimpleXMLObject.ELEMENT_NAME));
        digestMethod.getUnknownXMLObjects().add(this.buildXMLObject(SimpleXMLObject.ELEMENT_NAME));
        digestMethod.getUnknownXMLObjects().add(this.buildXMLObject(SimpleXMLObject.ELEMENT_NAME));
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)digestMethod);
    }
}

