/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.ext.reqattr.impl;

import javax.xml.namespace.QName;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.saml.ext.reqattr.RequestedAttributes;
import org.opensaml.saml.ext.reqattr.impl.RequestedAttributesBuilder;
import org.opensaml.saml.saml2.metadata.RequestedAttribute;
import org.opensaml.saml.saml2.metadata.impl.RequestedAttributeBuilder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class RequestedAttributesTest
extends XMLObjectProviderBaseTestCase {
    protected final String[] expectedNames = new String[]{"attribName1", "attribName2", "attribName3"};

    public RequestedAttributesTest() {
        this.singleElementFile = "/org/opensaml/saml/ext/reqattr/impl/RequestedAttributes.xml";
        this.childElementsFile = "/org/opensaml/saml/ext/reqattr/impl/RequestedAttributesChildElements.xml";
    }

    @Test
    public void testSingleElementUnmarshall() {
        RequestedAttributes requestedAttributes = (RequestedAttributes)this.unmarshallElement(this.singleElementFile);
        Assert.assertNotNull((Object)requestedAttributes, (String)"Requested Attribute Simple parse");
    }

    @Test
    public void testChildElementsUnmarshall() {
        RequestedAttributes requestedAttributes = (RequestedAttributes)this.unmarshallElement(this.childElementsFile);
        Assert.assertEquals((int)requestedAttributes.getRequestedAttributes().size(), (int)this.expectedNames.length);
        for (int i = 0; i < this.expectedNames.length; ++i) {
            Assert.assertEquals((String)((RequestedAttribute)requestedAttributes.getRequestedAttributes().get(i)).getName(), (String)this.expectedNames[i]);
        }
    }

    @Test
    public void testSingleElementMarshall() {
        QName qname = new QName("urn:oasis:names:tc:SAML:protocol:ext:req-attr", "RequestedAttributes", "req-attr");
        RequestedAttributes requestedAttributes = (RequestedAttributes)this.buildXMLObject(qname);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)requestedAttributes);
    }

    @Test
    public void testChildElementsMarshall() {
        RequestedAttributes requestedAttributes = new RequestedAttributesBuilder().buildObject();
        RequestedAttributeBuilder childBuilder = new RequestedAttributeBuilder();
        for (int i = 0; i < this.expectedNames.length; ++i) {
            RequestedAttribute ra = childBuilder.buildObject();
            ra.setName(this.expectedNames[i]);
            requestedAttributes.getRequestedAttributes().add(ra);
        }
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)requestedAttributes);
    }
}

