/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.common.profile.logic;

import java.util.Collections;
import java.util.regex.Pattern;
import net.shibboleth.ext.spring.resource.ResourceHelper;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.core.xml.XMLObjectBaseTestCase;
import org.opensaml.saml.common.profile.logic.EntityAttributesPredicate;
import org.opensaml.saml.metadata.resolver.impl.ResourceBackedMetadataResolver;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class EntityAttributesPredicateTest
extends XMLObjectBaseTestCase {
    private ResourceBackedMetadataResolver metadataProvider;

    @BeforeMethod
    protected void setUp() throws Exception {
        ClassPathResource resource = new ClassPathResource("/org/opensaml/saml/metadata/resolver/filter/impl/EntitiesDescriptor-Name-metadata.xml");
        this.metadataProvider = new ResourceBackedMetadataResolver(null, ResourceHelper.of((Resource)resource));
        this.metadataProvider.setId("test");
        this.metadataProvider.setParserPool(parserPool);
        this.metadataProvider.initialize();
    }

    @Test
    public void testWrongName() throws Exception {
        EntityAttributesPredicate.Candidate candidate = new EntityAttributesPredicate.Candidate("urn:foo:bar", "urn:oasis:names:tc:SAML:2.0:attrname-format:uri");
        candidate.setValues(Collections.singletonList("bar"));
        EntityAttributesPredicate condition = new EntityAttributesPredicate(Collections.singletonList(candidate), false);
        EntityDescriptor entity = this.metadataProvider.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion("https://idp-top.example.org")}));
        Assert.assertNotNull((Object)entity);
        Assert.assertFalse((boolean)condition.apply(entity));
    }

    @Test
    public void testWrongNameFormat() throws Exception {
        EntityAttributesPredicate.Candidate candidate = new EntityAttributesPredicate.Candidate("urn:foo", "urn:oasis:names:tc:SAML:2.0:attrname-format:basic");
        candidate.setValues(Collections.singletonList("bar"));
        EntityAttributesPredicate condition = new EntityAttributesPredicate(Collections.singletonList(candidate), false);
        EntityDescriptor entity = this.metadataProvider.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion("https://idp-top.example.org")}));
        Assert.assertNotNull((Object)entity);
        Assert.assertFalse((boolean)condition.apply(entity));
    }

    @Test
    public void testGroupUnspecified() throws Exception {
        EntityAttributesPredicate.Candidate candidate = new EntityAttributesPredicate.Candidate("urn:foo", null);
        candidate.setValues(Collections.singletonList("bar"));
        EntityAttributesPredicate condition = new EntityAttributesPredicate(Collections.singletonList(candidate), false);
        EntityDescriptor entity = this.metadataProvider.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion("https://idp-top.example.org")}));
        Assert.assertNotNull((Object)entity);
        Assert.assertTrue((boolean)condition.apply(entity));
    }

    @Test
    public void testGroupExact() throws Exception {
        EntityAttributesPredicate.Candidate candidate = new EntityAttributesPredicate.Candidate("urn:foo", "urn:oasis:names:tc:SAML:2.0:attrname-format:uri");
        candidate.setValues(Collections.singletonList("bar"));
        EntityAttributesPredicate condition = new EntityAttributesPredicate(Collections.singletonList(candidate), false);
        EntityDescriptor entity = this.metadataProvider.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion("https://idp-top.example.org")}));
        Assert.assertNotNull((Object)entity);
        Assert.assertTrue((boolean)condition.apply(entity));
    }

    @Test
    public void testGroupAdditional() throws Exception {
        EntityAttributesPredicate.Candidate candidate = new EntityAttributesPredicate.Candidate("urn:foo", "urn:oasis:names:tc:SAML:2.0:attrname-format:uri");
        candidate.setValues(Collections.singletonList("bar"));
        candidate.setRegexps(Collections.singletonList(Pattern.compile("baz")));
        EntityAttributesPredicate condition = new EntityAttributesPredicate(Collections.singletonList(candidate), false);
        EntityDescriptor entity = this.metadataProvider.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion("https://idp-top.example.org")}));
        Assert.assertNotNull((Object)entity);
        Assert.assertFalse((boolean)condition.apply(entity));
        EntityDescriptor entity2 = this.metadataProvider.resolveSingle(new CriteriaSet(new Criterion[]{new EntityIdCriterion("https://idp-sub1.example.org")}));
        Assert.assertNotNull((Object)entity2);
        Assert.assertTrue((boolean)condition.apply(entity2));
    }
}

