/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.common.profile.impl;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import java.util.Collections;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.core.OpenSAMLInitBaseTestCase;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.RequestContextBuilder;
import org.opensaml.profile.action.ActionTestingSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.OutboundMessageContextLookup;
import org.opensaml.saml.common.profile.impl.PopulateSignatureSigningParameters;
import org.opensaml.xmlsec.SignatureSigningParameters;
import org.opensaml.xmlsec.SignatureSigningParametersResolver;
import org.opensaml.xmlsec.context.SecurityParametersContext;
import org.opensaml.xmlsec.criterion.SignatureSigningConfigurationCriterion;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class PopulateSignatureSigningParametersTest
extends OpenSAMLInitBaseTestCase {
    private ProfileRequestContext prc;
    private PopulateSignatureSigningParameters action;

    @BeforeMethod
    public void setUp() {
        this.prc = new RequestContextBuilder().buildProfileRequestContext();
        this.action = new PopulateSignatureSigningParameters();
    }

    @Test(expectedExceptions={ComponentInitializationException.class})
    public void testConfig() throws ComponentInitializationException {
        this.action.initialize();
    }

    @Test
    public void testNoContext() throws Exception {
        this.action.setSignatureSigningParametersResolver((SignatureSigningParametersResolver)new MockResolver(false));
        this.action.initialize();
        this.prc.setOutboundMessageContext(null);
        this.action.execute(this.prc);
        ActionTestingSupport.assertEvent((ProfileRequestContext)this.prc, (Object)"InvalidMessageContext");
    }

    @Test
    public void testResolverError() throws Exception {
        this.action.setSignatureSigningParametersResolver((SignatureSigningParametersResolver)new MockResolver(true));
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertEvent((ProfileRequestContext)this.prc, (Object)"InvalidSecurityConfiguration");
    }

    @Test
    public void testSuccess() throws Exception {
        this.action.setSignatureSigningParametersResolver((SignatureSigningParametersResolver)new MockResolver(false));
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.prc);
        Assert.assertNotNull((Object)((SecurityParametersContext)this.prc.getOutboundMessageContext().getSubcontext(SecurityParametersContext.class)).getSignatureSigningParameters());
    }

    @Test
    public void testCopy() throws Exception {
        this.action.setSignatureSigningParametersResolver((SignatureSigningParametersResolver)new MockResolver(true));
        this.action.setExistingParametersContextLookupStrategy((Function)new ChildContextLookup(SecurityParametersContext.class));
        this.action.setSecurityParametersContextLookupStrategy(Functions.compose((Function)new ChildContextLookup(SecurityParametersContext.class, true), (Function)new OutboundMessageContextLookup()));
        this.action.initialize();
        ((SecurityParametersContext)this.prc.getSubcontext(SecurityParametersContext.class, true)).setSignatureSigningParameters(new SignatureSigningParameters());
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.prc);
        Assert.assertSame((Object)((SecurityParametersContext)this.prc.getSubcontext(SecurityParametersContext.class)).getSignatureSigningParameters(), (Object)((SecurityParametersContext)this.prc.getOutboundMessageContext().getSubcontext(SecurityParametersContext.class)).getSignatureSigningParameters());
    }

    private class MockResolver
    implements SignatureSigningParametersResolver {
        private boolean throwException;

        public MockResolver(boolean shouldThrow) {
            this.throwException = shouldThrow;
        }

        public Iterable<SignatureSigningParameters> resolve(CriteriaSet criteria) throws ResolverException {
            return Collections.singletonList(this.resolveSingle(criteria));
        }

        public SignatureSigningParameters resolveSingle(CriteriaSet criteria) throws ResolverException {
            if (this.throwException) {
                throw new ResolverException();
            }
            Constraint.isNotNull((Object)criteria.get(SignatureSigningConfigurationCriterion.class), (String)"Criterion was null");
            return new SignatureSigningParameters();
        }
    }
}

