/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.common.profile.impl;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.core.OpenSAMLInitBaseTestCase;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.profile.RequestContextBuilder;
import org.opensaml.profile.action.ActionTestingSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.common.profile.impl.AddAudienceRestrictionToAssertions;
import org.opensaml.saml.saml1.core.Assertion;
import org.opensaml.saml.saml1.core.AudienceRestrictionCondition;
import org.opensaml.saml.saml1.core.Conditions;
import org.opensaml.saml.saml1.core.Response;
import org.opensaml.saml.saml1.profile.SAML1ActionTestingSupport;
import org.opensaml.saml.saml2.core.Audience;
import org.opensaml.saml.saml2.core.AudienceRestriction;
import org.opensaml.saml.saml2.profile.SAML2ActionTestingSupport;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AddAudienceRestrictionToAssertionsTest
extends OpenSAMLInitBaseTestCase {
    private static final String AUDIENCE1 = "foo";
    private static final String AUDIENCE2 = "foo2";
    private AddAudienceRestrictionToAssertions action;

    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        this.action = new AddAudienceRestrictionToAssertions();
        this.action.setAudienceRestrictionsLookupStrategy((Function)new Function<ProfileRequestContext, Collection<String>>(){

            public Collection<String> apply(ProfileRequestContext input) {
                return ImmutableList.of((Object)AddAudienceRestrictionToAssertionsTest.AUDIENCE1, (Object)AddAudienceRestrictionToAssertionsTest.AUDIENCE2);
            }
        });
        this.action.initialize();
    }

    @Test
    public void testNoResponse() throws Exception {
        ProfileRequestContext prc = new RequestContextBuilder().buildProfileRequestContext();
        this.action.execute(prc);
        ActionTestingSupport.assertEvent((ProfileRequestContext)prc, (Object)"InvalidMessageContext");
    }

    @Test
    public void testNoAssertion() throws Exception {
        ProfileRequestContext prc = new RequestContextBuilder().setOutboundMessage((Object)SAML1ActionTestingSupport.buildResponse()).buildProfileRequestContext();
        this.action.execute(prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)prc);
    }

    @Test
    public void testSingleAssertion() throws Exception {
        Assertion assertion = SAML1ActionTestingSupport.buildAssertion();
        Response response = SAML1ActionTestingSupport.buildResponse();
        response.getAssertions().add(assertion);
        ProfileRequestContext prc = new RequestContextBuilder().setOutboundMessage((Object)response).buildProfileRequestContext();
        this.action.execute(prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)prc);
        Assert.assertNotNull((Object)response.getAssertions());
        Assert.assertEquals((int)response.getAssertions().size(), (int)1);
        Assert.assertNotNull((Object)assertion.getConditions());
        Assert.assertEquals((int)assertion.getConditions().getAudienceRestrictionConditions().size(), (int)1);
        AudienceRestrictionCondition audcond = (AudienceRestrictionCondition)assertion.getConditions().getAudienceRestrictionConditions().get(0);
        Assert.assertEquals((int)audcond.getAudiences().size(), (int)2);
        Assert.assertEquals((String)((org.opensaml.saml.saml1.core.Audience)audcond.getAudiences().get(0)).getUri(), (String)AUDIENCE1);
        Assert.assertEquals((String)((org.opensaml.saml.saml1.core.Audience)audcond.getAudiences().get(1)).getUri(), (String)AUDIENCE2);
    }

    @Test
    public void testSingleAssertionWithExistingCondition() throws Exception {
        SAMLObjectBuilder conditionsBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(Conditions.DEFAULT_ELEMENT_NAME);
        Conditions conditions = (Conditions)conditionsBuilder.buildObject();
        Assertion assertion = SAML1ActionTestingSupport.buildAssertion();
        assertion.setConditions(conditions);
        Response response = SAML1ActionTestingSupport.buildResponse();
        response.getAssertions().add(assertion);
        ProfileRequestContext prc = new RequestContextBuilder().setOutboundMessage((Object)response).buildProfileRequestContext();
        this.action.execute(prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)prc);
        Assert.assertNotNull((Object)assertion.getConditions());
        Assert.assertEquals((int)assertion.getConditions().getAudienceRestrictionConditions().size(), (int)1);
        AudienceRestrictionCondition audcond = (AudienceRestrictionCondition)assertion.getConditions().getAudienceRestrictionConditions().get(0);
        Assert.assertEquals((int)audcond.getAudiences().size(), (int)2);
        Assert.assertEquals((String)((org.opensaml.saml.saml1.core.Audience)audcond.getAudiences().get(0)).getUri(), (String)AUDIENCE1);
        Assert.assertEquals((String)((org.opensaml.saml.saml1.core.Audience)audcond.getAudiences().get(1)).getUri(), (String)AUDIENCE2);
    }

    @Test
    public void testSingleAssertionWithExistingAudienceCondition() throws Exception {
        SAMLObjectBuilder conditionBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(AudienceRestrictionCondition.DEFAULT_ELEMENT_NAME);
        AudienceRestrictionCondition condition = (AudienceRestrictionCondition)conditionBuilder.buildObject();
        SAMLObjectBuilder conditionsBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(Conditions.DEFAULT_ELEMENT_NAME);
        Conditions conditions = (Conditions)conditionsBuilder.buildObject();
        conditions.getAudienceRestrictionConditions().add(condition);
        Assertion assertion = SAML1ActionTestingSupport.buildAssertion();
        assertion.setConditions(conditions);
        Response response = SAML1ActionTestingSupport.buildResponse();
        response.getAssertions().add(assertion);
        ProfileRequestContext prc = new RequestContextBuilder().setOutboundMessage((Object)response).buildProfileRequestContext();
        this.action.execute(prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)prc);
        Assert.assertNotNull((Object)assertion.getConditions());
        Assert.assertEquals((int)assertion.getConditions().getAudienceRestrictionConditions().size(), (int)1);
        AudienceRestrictionCondition audcond = (AudienceRestrictionCondition)assertion.getConditions().getAudienceRestrictionConditions().get(0);
        Assert.assertEquals((int)audcond.getAudiences().size(), (int)2);
        Assert.assertEquals((String)((org.opensaml.saml.saml1.core.Audience)audcond.getAudiences().get(0)).getUri(), (String)AUDIENCE1);
        Assert.assertEquals((String)((org.opensaml.saml.saml1.core.Audience)audcond.getAudiences().get(1)).getUri(), (String)AUDIENCE2);
    }

    @Test
    public void testMultipleAssertion() throws Exception {
        Response response = SAML1ActionTestingSupport.buildResponse();
        response.getAssertions().add(SAML1ActionTestingSupport.buildAssertion());
        response.getAssertions().add(SAML1ActionTestingSupport.buildAssertion());
        response.getAssertions().add(SAML1ActionTestingSupport.buildAssertion());
        ProfileRequestContext prc = new RequestContextBuilder().setOutboundMessage((Object)response).buildProfileRequestContext();
        this.action.execute(prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)prc);
        Assert.assertNotNull((Object)response.getAssertions());
        Assert.assertEquals((int)response.getAssertions().size(), (int)3);
        for (Assertion assertion : response.getAssertions()) {
            Assert.assertNotNull((Object)assertion.getConditions());
            Assert.assertEquals((int)assertion.getConditions().getAudienceRestrictionConditions().size(), (int)1);
            AudienceRestrictionCondition audcond = (AudienceRestrictionCondition)assertion.getConditions().getAudienceRestrictionConditions().get(0);
            Assert.assertEquals((int)audcond.getAudiences().size(), (int)2);
            Assert.assertEquals((String)((org.opensaml.saml.saml1.core.Audience)audcond.getAudiences().get(0)).getUri(), (String)AUDIENCE1);
            Assert.assertEquals((String)((org.opensaml.saml.saml1.core.Audience)audcond.getAudiences().get(1)).getUri(), (String)AUDIENCE2);
        }
    }

    @Test
    public void testSAML2Assertion() throws Exception {
        org.opensaml.saml.saml2.core.Assertion assertion = SAML2ActionTestingSupport.buildAssertion();
        org.opensaml.saml.saml2.core.Response response = SAML2ActionTestingSupport.buildResponse();
        response.getAssertions().add(assertion);
        ProfileRequestContext prc = new RequestContextBuilder().setOutboundMessage((Object)response).buildProfileRequestContext();
        this.action.execute(prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)prc);
        Assert.assertNotNull((Object)response.getAssertions());
        Assert.assertEquals((int)response.getAssertions().size(), (int)1);
        Assert.assertNotNull((Object)assertion.getConditions());
        Assert.assertEquals((int)assertion.getConditions().getAudienceRestrictions().size(), (int)1);
        AudienceRestriction audcond = (AudienceRestriction)assertion.getConditions().getAudienceRestrictions().get(0);
        Assert.assertEquals((int)audcond.getAudiences().size(), (int)2);
        Assert.assertEquals((String)((Audience)audcond.getAudiences().get(0)).getAudienceURI(), (String)AUDIENCE1);
        Assert.assertEquals((String)((Audience)audcond.getAudiences().get(1)).getAudienceURI(), (String)AUDIENCE2);
    }
}

