/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.common.binding.impl;

import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.messaging.context.InOutOperationContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ContextDataLookupFunction;
import org.opensaml.messaging.context.navigate.RecursiveTypedParentContextLookup;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.binding.impl.SAMLProtocolAndRoleHandler;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.common.messaging.context.SAMLPresenterEntityContext;
import org.opensaml.saml.common.messaging.context.SAMLProtocolContext;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class SAMLProtocolAndRoleHandlerTest {
    private SAMLProtocolAndRoleHandler handler;
    private MessageContext<SAMLObject> messageContext;

    @BeforeMethod
    public void setup() {
        this.handler = new SAMLProtocolAndRoleHandler();
        this.messageContext = new MessageContext();
    }

    @Test
    public void testSetters() throws ComponentInitializationException, MessageHandlerException {
        this.handler.setProtocol("urn:oasis:names:tc:SAML:2.0:protocol");
        this.handler.setRole(SPSSODescriptor.DEFAULT_ELEMENT_NAME);
        this.handler.initialize();
        this.handler.invoke(this.messageContext);
        Assert.assertNotNull((Object)this.messageContext.getSubcontext(SAMLProtocolContext.class));
        Assert.assertEquals((String)((SAMLProtocolContext)this.messageContext.getSubcontext(SAMLProtocolContext.class)).getProtocol(), (String)"urn:oasis:names:tc:SAML:2.0:protocol");
        Assert.assertNotNull((Object)this.messageContext.getSubcontext(SAMLPeerEntityContext.class));
        Assert.assertEquals((Object)((SAMLPeerEntityContext)this.messageContext.getSubcontext(SAMLPeerEntityContext.class)).getRole(), (Object)SPSSODescriptor.DEFAULT_ELEMENT_NAME);
    }

    @Test
    public void testSettersWithEntityClass() throws ComponentInitializationException, MessageHandlerException {
        this.handler.setProtocol("urn:oasis:names:tc:SAML:2.0:protocol");
        this.handler.setRole(SPSSODescriptor.DEFAULT_ELEMENT_NAME);
        this.handler.setEntityContextClass(SAMLPresenterEntityContext.class);
        this.handler.initialize();
        this.handler.invoke(this.messageContext);
        Assert.assertNotNull((Object)this.messageContext.getSubcontext(SAMLProtocolContext.class));
        Assert.assertEquals((String)((SAMLProtocolContext)this.messageContext.getSubcontext(SAMLProtocolContext.class)).getProtocol(), (String)"urn:oasis:names:tc:SAML:2.0:protocol");
        Assert.assertNotNull((Object)this.messageContext.getSubcontext(SAMLPresenterEntityContext.class));
        Assert.assertEquals((Object)((SAMLPresenterEntityContext)this.messageContext.getSubcontext(SAMLPresenterEntityContext.class)).getRole(), (Object)SPSSODescriptor.DEFAULT_ELEMENT_NAME);
    }

    @Test
    public void testCopySource() throws ComponentInitializationException, MessageHandlerException {
        this.handler.setCopyContextLookup((ContextDataLookupFunction)new RecursiveTypedParentContextLookup(InOutOperationContext.class));
        this.handler.initialize();
        InOutOperationContext opContext = new InOutOperationContext(this.messageContext, new MessageContext());
        ((SAMLProtocolContext)opContext.getSubcontext(SAMLProtocolContext.class, true)).setProtocol("urn:oasis:names:tc:SAML:2.0:protocol");
        ((SAMLPeerEntityContext)opContext.getSubcontext(SAMLPeerEntityContext.class, true)).setRole(SPSSODescriptor.DEFAULT_ELEMENT_NAME);
        this.handler.invoke(this.messageContext);
        Assert.assertNotNull((Object)this.messageContext.getSubcontext(SAMLProtocolContext.class));
        Assert.assertEquals((String)((SAMLProtocolContext)this.messageContext.getSubcontext(SAMLProtocolContext.class)).getProtocol(), (String)"urn:oasis:names:tc:SAML:2.0:protocol");
        Assert.assertNotNull((Object)this.messageContext.getSubcontext(SAMLPeerEntityContext.class));
        Assert.assertEquals((Object)((SAMLPeerEntityContext)this.messageContext.getSubcontext(SAMLPeerEntityContext.class)).getRole(), (Object)SPSSODescriptor.DEFAULT_ELEMENT_NAME);
    }

    @Test
    public void testCopySourceWithEntityClass() throws ComponentInitializationException, MessageHandlerException {
        this.handler.setCopyContextLookup((ContextDataLookupFunction)new RecursiveTypedParentContextLookup(InOutOperationContext.class));
        this.handler.setEntityContextClass(SAMLPresenterEntityContext.class);
        this.handler.initialize();
        InOutOperationContext opContext = new InOutOperationContext(this.messageContext, new MessageContext());
        ((SAMLProtocolContext)opContext.getSubcontext(SAMLProtocolContext.class, true)).setProtocol("urn:oasis:names:tc:SAML:2.0:protocol");
        ((SAMLPresenterEntityContext)opContext.getSubcontext(SAMLPresenterEntityContext.class, true)).setRole(SPSSODescriptor.DEFAULT_ELEMENT_NAME);
        this.handler.invoke(this.messageContext);
        Assert.assertNotNull((Object)this.messageContext.getSubcontext(SAMLProtocolContext.class));
        Assert.assertEquals((String)((SAMLProtocolContext)this.messageContext.getSubcontext(SAMLProtocolContext.class)).getProtocol(), (String)"urn:oasis:names:tc:SAML:2.0:protocol");
        Assert.assertNotNull((Object)this.messageContext.getSubcontext(SAMLPresenterEntityContext.class));
        Assert.assertEquals((Object)((SAMLPresenterEntityContext)this.messageContext.getSubcontext(SAMLPresenterEntityContext.class)).getRole(), (Object)SPSSODescriptor.DEFAULT_ELEMENT_NAME);
    }

    @Test(expectedExceptions={ComponentInitializationException.class})
    public void testMissingConfiguredProtocol() throws ComponentInitializationException, MessageHandlerException {
        this.handler.setRole(SPSSODescriptor.DEFAULT_ELEMENT_NAME);
        this.handler.setEntityContextClass(SAMLPresenterEntityContext.class);
        this.handler.initialize();
    }

    @Test(expectedExceptions={ComponentInitializationException.class})
    public void testMissingConfiguredRole() throws ComponentInitializationException, MessageHandlerException {
        this.handler.setProtocol("urn:oasis:names:tc:SAML:2.0:protocol");
        this.handler.setEntityContextClass(SAMLPresenterEntityContext.class);
        this.handler.initialize();
    }

    @Test(expectedExceptions={MessageHandlerException.class})
    public void testResolverWithNoCopySource() throws ComponentInitializationException, MessageHandlerException {
        this.handler.setCopyContextLookup((ContextDataLookupFunction)new RecursiveTypedParentContextLookup(InOutOperationContext.class));
        this.handler.initialize();
        this.handler.invoke(this.messageContext);
    }
}

