/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.common.binding.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.opensaml.core.xml.XMLObjectBaseTestCase;
import org.opensaml.core.xml.io.Unmarshaller;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.saml.common.binding.impl.DefaultEndpointResolver;
import org.opensaml.saml.criterion.BindingCriterion;
import org.opensaml.saml.criterion.EndpointCriterion;
import org.opensaml.saml.criterion.RoleDescriptorCriterion;
import org.opensaml.saml.saml2.metadata.AssertionConsumerService;
import org.opensaml.saml.saml2.metadata.Endpoint;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import org.w3c.dom.Document;

public class DefaultEndpointResolverTest
extends XMLObjectBaseTestCase {
    private static final String LOCATION = "https://sp.example.org/ACS";
    private static final String LOCATION_POST = "https://sp.example.org/POST2";
    private static final String LOCATION_ART = "https://sp.example.org/Art2";
    private DefaultEndpointResolver<AssertionConsumerService> resolver;
    private EndpointCriterion<AssertionConsumerService> endpointCrit;

    @BeforeClass
    public void classSetUp() throws ComponentInitializationException {
        this.resolver = new DefaultEndpointResolver();
        this.resolver.initialize();
    }

    @BeforeMethod
    public void setUp() {
        AssertionConsumerService ep = (AssertionConsumerService)builderFactory.getBuilderOrThrow(AssertionConsumerService.DEFAULT_ELEMENT_NAME).buildObject(AssertionConsumerService.DEFAULT_ELEMENT_NAME);
        ep.setBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        ep.setLocation(LOCATION);
        this.endpointCrit = new EndpointCriterion((Endpoint)ep, false);
    }

    @Test(expectedExceptions={ResolverException.class})
    public void testNoCriteria() throws ResolverException {
        this.resolver.resolveSingle(new CriteriaSet());
    }

    @Test
    public void testNoMetadata() throws ResolverException {
        AssertionConsumerService ep = (AssertionConsumerService)this.resolver.resolveSingle(new CriteriaSet(new Criterion[]{this.endpointCrit}));
        Assert.assertNull((Object)ep);
    }

    @Test
    public void testSignedRequest() throws ResolverException {
        CriteriaSet crits = new CriteriaSet(new Criterion[]{new EndpointCriterion(this.endpointCrit.getEndpoint(), true)});
        AssertionConsumerService ep = (AssertionConsumerService)this.resolver.resolveSingle(crits);
        Assert.assertNotNull((Object)ep);
        Assert.assertSame((Object)ep, (Object)this.endpointCrit.getEndpoint());
    }

    @Test
    public void testSignedRequestBadBinding() throws ResolverException {
        CriteriaSet crits = new CriteriaSet(new Criterion[]{new EndpointCriterion(this.endpointCrit.getEndpoint(), true), new BindingCriterion(Collections.emptyList())});
        AssertionConsumerService ep = (AssertionConsumerService)this.resolver.resolveSingle(crits);
        Assert.assertNull((Object)ep);
    }

    @Test
    public void testNoEndpoints() throws UnmarshallingException, ResolverException {
        RoleDescriptorCriterion roleCrit = new RoleDescriptorCriterion((RoleDescriptor)this.loadMetadata("/org/opensaml/saml/common/binding/SPNoEndpoints.xml"));
        AssertionConsumerService ep = (AssertionConsumerService)this.resolver.resolveSingle(new CriteriaSet(new Criterion[]{this.endpointCrit, roleCrit}));
        Assert.assertNull((Object)ep);
    }

    @Test
    public void testBadLocation() throws UnmarshallingException, ResolverException {
        RoleDescriptorCriterion roleCrit = new RoleDescriptorCriterion((RoleDescriptor)this.loadMetadata("/org/opensaml/saml/common/binding/SPWithEndpoints.xml"));
        CriteriaSet crits = new CriteriaSet(new Criterion[]{this.endpointCrit, roleCrit});
        AssertionConsumerService ep = (AssertionConsumerService)this.resolver.resolveSingle(crits);
        Assert.assertNull((Object)ep);
    }

    @Test
    public void testBadBinding() throws UnmarshallingException, ResolverException {
        ((AssertionConsumerService)this.endpointCrit.getEndpoint()).setLocation(LOCATION_POST);
        ((AssertionConsumerService)this.endpointCrit.getEndpoint()).setBinding("urn:oasis:names:tc:SAML:2.0:bindings:SOAP");
        RoleDescriptorCriterion roleCrit = new RoleDescriptorCriterion((RoleDescriptor)this.loadMetadata("/org/opensaml/saml/common/binding/SPWithEndpoints.xml"));
        CriteriaSet crits = new CriteriaSet(new Criterion[]{this.endpointCrit, roleCrit});
        AssertionConsumerService ep = (AssertionConsumerService)this.resolver.resolveSingle(crits);
        Assert.assertNull((Object)ep);
    }

    @Test
    public void testUnsupportedBinding() throws UnmarshallingException, ResolverException {
        ((AssertionConsumerService)this.endpointCrit.getEndpoint()).setLocation(LOCATION_POST);
        RoleDescriptorCriterion roleCrit = new RoleDescriptorCriterion((RoleDescriptor)this.loadMetadata("/org/opensaml/saml/common/binding/SPWithEndpoints.xml"));
        CriteriaSet crits = new CriteriaSet(new Criterion[]{this.endpointCrit, roleCrit, new BindingCriterion(Collections.singletonList("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact"))});
        AssertionConsumerService ep = (AssertionConsumerService)this.resolver.resolveSingle(crits);
        Assert.assertNull((Object)ep);
    }

    @Test
    public void testBadIndex() throws UnmarshallingException, ResolverException {
        ((AssertionConsumerService)this.endpointCrit.getEndpoint()).setLocation(null);
        ((AssertionConsumerService)this.endpointCrit.getEndpoint()).setBinding(null);
        ((AssertionConsumerService)this.endpointCrit.getEndpoint()).setIndex(Integer.valueOf(5));
        RoleDescriptorCriterion roleCrit = new RoleDescriptorCriterion((RoleDescriptor)this.loadMetadata("/org/opensaml/saml/common/binding/SPWithEndpoints.xml"));
        CriteriaSet crits = new CriteriaSet(new Criterion[]{this.endpointCrit, roleCrit});
        AssertionConsumerService ep = (AssertionConsumerService)this.resolver.resolveSingle(crits);
        Assert.assertNull((Object)ep);
    }

    @Test
    public void testInMetadata() throws UnmarshallingException, ResolverException {
        ((AssertionConsumerService)this.endpointCrit.getEndpoint()).setLocation(LOCATION_POST);
        RoleDescriptorCriterion roleCrit = new RoleDescriptorCriterion((RoleDescriptor)this.loadMetadata("/org/opensaml/saml/common/binding/SPWithEndpoints.xml"));
        CriteriaSet crits = new CriteriaSet(new Criterion[]{this.endpointCrit, roleCrit});
        AssertionConsumerService ep = (AssertionConsumerService)this.resolver.resolveSingle(crits);
        Assert.assertNotNull((Object)ep);
        Assert.assertEquals((String)ep.getBinding(), (String)"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        Assert.assertEquals((String)ep.getLocation(), (String)LOCATION_POST);
        Assert.assertEquals((Object)ep.getIndex(), (Object)2);
    }

    @Test
    public void testDefault() throws UnmarshallingException, ResolverException {
        ((AssertionConsumerService)this.endpointCrit.getEndpoint()).setLocation(null);
        ((AssertionConsumerService)this.endpointCrit.getEndpoint()).setBinding(null);
        RoleDescriptorCriterion roleCrit = new RoleDescriptorCriterion((RoleDescriptor)this.loadMetadata("/org/opensaml/saml/common/binding/SPWithEndpoints.xml"));
        CriteriaSet crits = new CriteriaSet(new Criterion[]{this.endpointCrit, roleCrit});
        AssertionConsumerService ep = (AssertionConsumerService)this.resolver.resolveSingle(crits);
        Assert.assertNotNull((Object)ep);
        Assert.assertEquals((String)ep.getBinding(), (String)"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact");
        Assert.assertEquals((String)ep.getLocation(), (String)LOCATION_ART);
        Assert.assertEquals((Object)ep.getIndex(), (Object)4);
    }

    @Test
    public void testDefaultForBinding() throws UnmarshallingException, ResolverException {
        ((AssertionConsumerService)this.endpointCrit.getEndpoint()).setLocation(null);
        ((AssertionConsumerService)this.endpointCrit.getEndpoint()).setBinding(null);
        RoleDescriptorCriterion roleCrit = new RoleDescriptorCriterion((RoleDescriptor)this.loadMetadata("/org/opensaml/saml/common/binding/SPWithEndpoints.xml"));
        CriteriaSet crits = new CriteriaSet(new Criterion[]{this.endpointCrit, roleCrit, new BindingCriterion(Collections.singletonList("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST"))});
        AssertionConsumerService ep = (AssertionConsumerService)this.resolver.resolveSingle(crits);
        Assert.assertNotNull((Object)ep);
        Assert.assertEquals((String)ep.getBinding(), (String)"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        Assert.assertEquals((String)ep.getLocation(), (String)LOCATION_POST.replace("POST2", "POST"));
        Assert.assertEquals((Object)ep.getIndex(), (Object)1);
    }

    @Test
    public void testMultiple() throws UnmarshallingException, ResolverException {
        ((AssertionConsumerService)this.endpointCrit.getEndpoint()).setLocation(null);
        ((AssertionConsumerService)this.endpointCrit.getEndpoint()).setBinding(null);
        RoleDescriptorCriterion roleCrit = new RoleDescriptorCriterion((RoleDescriptor)this.loadMetadata("/org/opensaml/saml/common/binding/SPWithEndpoints.xml"));
        CriteriaSet crits = new CriteriaSet(new Criterion[]{this.endpointCrit, roleCrit});
        ArrayList<AssertionConsumerService> eps = new ArrayList<AssertionConsumerService>();
        for (AssertionConsumerService ep : this.resolver.resolve(crits)) {
            eps.add(ep);
        }
        Assert.assertEquals((int)eps.size(), (int)4);
    }

    @Test
    public void testMultipleWithBinding() throws UnmarshallingException, ResolverException {
        ((AssertionConsumerService)this.endpointCrit.getEndpoint()).setLocation(null);
        RoleDescriptorCriterion roleCrit = new RoleDescriptorCriterion((RoleDescriptor)this.loadMetadata("/org/opensaml/saml/common/binding/SPWithEndpoints.xml"));
        CriteriaSet crits = new CriteriaSet(new Criterion[]{this.endpointCrit, roleCrit});
        ArrayList<AssertionConsumerService> eps = new ArrayList<AssertionConsumerService>();
        for (AssertionConsumerService ep : this.resolver.resolve(crits)) {
            eps.add(ep);
        }
        Assert.assertEquals((int)eps.size(), (int)2);
    }

    @Nonnull
    private SPSSODescriptor loadMetadata(@Nonnull @NotEmpty String path) throws UnmarshallingException {
        try {
            URL url = ((Object)((Object)this)).getClass().getResource(path);
            Document doc = parserPool.parse((InputStream)new FileInputStream(new File(url.toURI())));
            Unmarshaller unmarshaller = unmarshallerFactory.getUnmarshaller(doc.getDocumentElement());
            return (SPSSODescriptor)unmarshaller.unmarshall(doc.getDocumentElement());
        }
        catch (FileNotFoundException | URISyntaxException | XMLParserException e) {
            throw new UnmarshallingException((Exception)e);
        }
    }
}

