/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.common.binding.impl;

import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.core.OpenSAMLInitBaseTestCase;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.common.binding.impl.CheckMessageVersionHandler;
import org.opensaml.saml.saml1.core.RequestAbstractType;
import org.opensaml.saml.saml1.profile.SAML1ActionTestingSupport;
import org.opensaml.saml.saml2.core.AttributeQuery;
import org.opensaml.saml.saml2.profile.SAML2ActionTestingSupport;
import org.testng.annotations.Test;

public class CheckMessageVersionHandlerTest
extends OpenSAMLInitBaseTestCase {
    @Test(expectedExceptions={MessageHandlerException.class})
    public void testNoMessageThrows() throws ComponentInitializationException, MessageHandlerException {
        MessageContext messageCtx = new MessageContext();
        CheckMessageVersionHandler handler = new CheckMessageVersionHandler();
        handler.initialize();
        handler.invoke(messageCtx);
    }

    @Test
    public void testNoMessageSilent() throws ComponentInitializationException, MessageHandlerException {
        MessageContext messageCtx = new MessageContext();
        CheckMessageVersionHandler handler = new CheckMessageVersionHandler();
        handler.setIgnoreMissingOrUnrecognized(true);
        handler.initialize();
        handler.invoke(messageCtx);
    }

    @Test(expectedExceptions={MessageHandlerException.class})
    public void testBadMessageThrows() throws ComponentInitializationException, MessageHandlerException {
        MessageContext messageCtx = new MessageContext();
        messageCtx.setMessage((Object)SAML1ActionTestingSupport.buildAssertion());
        CheckMessageVersionHandler handler = new CheckMessageVersionHandler();
        handler.initialize();
        handler.invoke(messageCtx);
    }

    @Test
    public void testBadMessageSilent() throws ComponentInitializationException, MessageHandlerException {
        MessageContext messageCtx = new MessageContext();
        messageCtx.setMessage((Object)SAML1ActionTestingSupport.buildAssertion());
        CheckMessageVersionHandler handler = new CheckMessageVersionHandler();
        handler.setIgnoreMissingOrUnrecognized(true);
        handler.initialize();
        handler.invoke(messageCtx);
    }

    @Test
    public void testSaml1Message() throws MessageHandlerException, ComponentInitializationException {
        MessageContext messageCtx = new MessageContext();
        messageCtx.setMessage((Object)SAML1ActionTestingSupport.buildAttributeQueryRequest(null));
        CheckMessageVersionHandler handler = new CheckMessageVersionHandler();
        handler.initialize();
        handler.invoke(messageCtx);
    }

    @Test(expectedExceptions={MessageHandlerException.class})
    public void testSaml2MessageFail() throws MessageHandlerException, ComponentInitializationException {
        MessageContext messageCtx = new MessageContext();
        messageCtx.setMessage((Object)SAML1ActionTestingSupport.buildAttributeQueryRequest(null));
        ((RequestAbstractType)messageCtx.getMessage()).setVersion(SAMLVersion.VERSION_20);
        CheckMessageVersionHandler handler = new CheckMessageVersionHandler();
        handler.initialize();
        handler.invoke(messageCtx);
    }

    @Test
    public void testSaml2Message() throws MessageHandlerException, ComponentInitializationException {
        MessageContext messageCtx = new MessageContext();
        messageCtx.setMessage((Object)SAML2ActionTestingSupport.buildAttributeQueryRequest(null));
        CheckMessageVersionHandler handler = new CheckMessageVersionHandler();
        handler.initialize();
        handler.invoke(messageCtx);
    }

    @Test(expectedExceptions={MessageHandlerException.class})
    public void testSaml1MessageFail() throws MessageHandlerException, ComponentInitializationException {
        MessageContext messageCtx = new MessageContext();
        messageCtx.setMessage((Object)SAML2ActionTestingSupport.buildAttributeQueryRequest(null));
        ((AttributeQuery)messageCtx.getMessage()).setVersion(SAMLVersion.VERSION_11);
        CheckMessageVersionHandler handler = new CheckMessageVersionHandler();
        handler.initialize();
        handler.invoke(messageCtx);
    }
}

