/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.common.binding.artifact.impl;

import java.io.IOException;
import net.shibboleth.utilities.java.support.xml.XMLAssertTestNG;
import org.custommonkey.xmlunit.Diff;
import org.opensaml.core.xml.XMLObjectBaseTestCase;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.binding.artifact.BasicSAMLArtifactMapEntry;
import org.opensaml.saml.common.binding.artifact.SAMLArtifactMap;
import org.opensaml.saml.common.binding.artifact.impl.StorageServiceSAMLArtifactMap;
import org.opensaml.saml.common.binding.artifact.impl.StorageServiceSAMLArtifactMapEntryFactory;
import org.opensaml.saml.saml1.core.Assertion;
import org.opensaml.saml.saml1.core.Response;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import org.w3c.dom.Document;

public class StorageServiceSAMLArtifactMapEntryFactoryTest
extends XMLObjectBaseTestCase {
    private String artifact = "the-artifact";
    private String issuerId = "urn:test:issuer";
    private String rpId = "urn:test:rp";
    private StorageServiceSAMLArtifactMapEntryFactory factory;
    private SAMLObject samlObject;

    @BeforeMethod
    protected void setUp() throws Exception {
        this.factory = new StorageServiceSAMLArtifactMapEntryFactory();
        this.samlObject = (SAMLObject)this.unmarshallElement("/org/opensaml/saml/saml1/core/SignedAssertion.xml");
    }

    @Test
    public void testNoParent() {
        SAMLArtifactMap.SAMLArtifactMapEntry entry = this.factory.newEntry(this.artifact, this.issuerId, this.rpId, this.samlObject);
        Assert.assertTrue((this.samlObject == entry.getSamlMessage() ? 1 : 0) != 0, (String)"Parent-less SAMLObject resulted in different object in entry");
    }

    @Test
    public void testWithParent() {
        Response response = (Response)this.buildXMLObject(Response.DEFAULT_ELEMENT_NAME);
        response.getAssertions().add((Assertion)this.samlObject);
        Assert.assertTrue((boolean)this.samlObject.hasParent());
        SAMLArtifactMap.SAMLArtifactMapEntry entry = this.factory.newEntry(this.artifact, this.issuerId, this.rpId, this.samlObject);
        Assert.assertFalse((this.samlObject == entry.getSamlMessage() ? 1 : 0) != 0, (String)"Parent-ed SAMLObject resulted in the same object in entry");
    }

    @Test
    public void testWithSerialization() throws IOException, MarshallingException {
        SAMLArtifactMap.SAMLArtifactMapEntry entry = this.factory.newEntry(this.artifact, this.issuerId, this.rpId, this.samlObject);
        BasicSAMLArtifactMapEntry basicEntry = (BasicSAMLArtifactMapEntry)entry;
        String s = this.factory.serialize((SAMLArtifactMap.SAMLArtifactMapEntry)basicEntry);
        BasicSAMLArtifactMapEntry newEntry = (BasicSAMLArtifactMapEntry)this.factory.deserialize(1L, StorageServiceSAMLArtifactMap.STORAGE_CONTEXT, basicEntry.getArtifact(), s, null);
        Assert.assertEquals((String)basicEntry.getArtifact(), (String)newEntry.getArtifact());
        Assert.assertEquals((String)basicEntry.getIssuerId(), (String)newEntry.getIssuerId());
        Assert.assertEquals((String)basicEntry.getRelyingPartyId(), (String)newEntry.getRelyingPartyId());
        Document origDocument = this.samlObject.getDOM().getOwnerDocument();
        origDocument.appendChild(this.samlObject.getDOM());
        Document newDocument = newEntry.getSamlMessage().getDOM().getOwnerDocument();
        XMLAssertTestNG.assertXMLIdentical((Diff)new Diff(origDocument, newDocument), (boolean)true);
    }
}

