/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.common;

import net.shibboleth.utilities.java.support.xml.XMLAssertTestNG;
import org.custommonkey.xmlunit.Diff;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBaseTestCase;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.Marshaller;
import org.opensaml.core.xml.io.MarshallerFactory;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.Unmarshaller;
import org.opensaml.core.xml.io.UnmarshallerFactory;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.saml2.metadata.Organization;
import org.opensaml.saml.saml2.metadata.OrganizationDisplayName;
import org.opensaml.saml.saml2.metadata.OrganizationName;
import org.opensaml.saml.saml2.metadata.OrganizationURL;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import org.w3c.dom.Element;

public class RoundTripTest
extends XMLObjectBaseTestCase {
    private Organization organization;
    private Marshaller orgMarshaller;
    private Unmarshaller orgUnmarshaller;

    @BeforeMethod
    protected void setUp() throws Exception {
        SAMLObjectBuilder orgBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(Organization.DEFAULT_ELEMENT_NAME);
        this.organization = (Organization)orgBuilder.buildObject();
        SAMLObjectBuilder orgNameBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(OrganizationName.DEFAULT_ELEMENT_NAME);
        OrganizationName newOrgName = (OrganizationName)orgNameBuilder.buildObject();
        newOrgName.setValue("OrgFullName");
        newOrgName.setXMLLang("en");
        this.organization.getOrganizationNames().add(newOrgName);
        SAMLObjectBuilder orgDisplayNameBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(OrganizationDisplayName.DEFAULT_ELEMENT_NAME);
        OrganizationDisplayName newOrgDisplayName = (OrganizationDisplayName)orgDisplayNameBuilder.buildObject();
        newOrgDisplayName.setValue("OrgDisplayName");
        newOrgDisplayName.setXMLLang("en");
        this.organization.getDisplayNames().add(newOrgDisplayName);
        SAMLObjectBuilder orgURLBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(OrganizationURL.DEFAULT_ELEMENT_NAME);
        OrganizationURL newOrgURL = (OrganizationURL)orgURLBuilder.buildObject();
        newOrgURL.setValue("http://org.url.edu");
        newOrgURL.setXMLLang("en");
        this.organization.getURLs().add(newOrgURL);
        MarshallerFactory marshallerFactory = XMLObjectProviderRegistrySupport.getMarshallerFactory();
        this.orgMarshaller = marshallerFactory.getMarshaller((XMLObject)this.organization);
        UnmarshallerFactory unmarshallerFactory = XMLObjectProviderRegistrySupport.getUnmarshallerFactory();
        this.orgUnmarshaller = unmarshallerFactory.getUnmarshaller(this.organization.getElementQName());
    }

    @Test
    public void testRoundTrip() throws MarshallingException, UnmarshallingException {
        Element orgElement1 = this.orgMarshaller.marshall((XMLObject)this.organization);
        Organization org2 = (Organization)this.orgUnmarshaller.unmarshall(orgElement1);
        org2.releaseDOM();
        org2.releaseChildrenDOM(true);
        Element orgElement2 = this.orgMarshaller.marshall((XMLObject)org2);
        XMLAssertTestNG.assertXMLIdentical((Diff)new Diff(orgElement1.getOwnerDocument(), orgElement2.getOwnerDocument()), (boolean)true);
        Organization org3 = (Organization)this.orgUnmarshaller.unmarshall(orgElement2);
        org3.releaseDOM();
        org3.releaseChildrenDOM(true);
        Element orgElement3 = this.orgMarshaller.marshall((XMLObject)org3);
        XMLAssertTestNG.assertXMLIdentical((Diff)new Diff(orgElement1.getOwnerDocument(), orgElement3.getOwnerDocument()), (boolean)true);
    }
}

