/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.impl;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.resolver.RefreshableMetadataResolver;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilter;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChainingMetadataResolver
extends AbstractIdentifiableInitializableComponent
implements MetadataResolver,
RefreshableMetadataResolver {
    private final Logger log = LoggerFactory.getLogger(ChainingMetadataResolver.class);
    private List<MetadataResolver> resolvers = Collections.EMPTY_LIST;

    public List<MetadataResolver> getResolvers() {
        return this.resolvers;
    }

    public void setResolvers(List<MetadataResolver> newResolvers) throws ResolverException {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        if (newResolvers == null || newResolvers.isEmpty()) {
            this.resolvers = Collections.emptyList();
            return;
        }
        this.resolvers = Collections.unmodifiableList(newResolvers);
    }

    public boolean isRequireValidMetadata() {
        this.log.warn("Attempt to access unsupported requireValidMetadata property on ChainingMetadataResolver");
        return false;
    }

    public void setRequireValidMetadata(boolean requireValidMetadata) {
        throw new UnsupportedOperationException("Setting require valid metadata is not supported on chaining resolver");
    }

    public MetadataFilter getMetadataFilter() {
        this.log.warn("Attempt to access unsupported MetadataFilter property on ChainingMetadataResolver");
        return null;
    }

    public void setMetadataFilter(MetadataFilter newFilter) {
        throw new UnsupportedOperationException("Metadata filters are not supported on ChainingMetadataResolver");
    }

    @Nullable
    public EntityDescriptor resolveSingle(CriteriaSet criteria) throws ResolverException {
        Iterator<EntityDescriptor> iterator;
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        Iterable<EntityDescriptor> iterable = this.resolve(criteria);
        if (iterable != null && (iterator = iterable.iterator()) != null && iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    @Nonnull
    public Iterable<EntityDescriptor> resolve(CriteriaSet criteria) throws ResolverException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        for (MetadataResolver resolver : this.resolvers) {
            try {
                Iterable descriptors = resolver.resolve((Object)criteria);
                if (descriptors == null || !descriptors.iterator().hasNext()) continue;
                return descriptors;
            }
            catch (ResolverException e) {
                this.log.warn("Error retrieving metadata from resolver of type {}, proceeding to next resolver", (Object)resolver.getClass().getName(), (Object)e);
            }
        }
        return Collections.emptyList();
    }

    public void refresh() throws ResolverException {
        for (MetadataResolver resolver : this.resolvers) {
            if (!(resolver instanceof RefreshableMetadataResolver)) continue;
            ((RefreshableMetadataResolver)resolver).refresh();
        }
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.resolvers == null) {
            this.log.warn("ChainingMetadataResolver was not configured with any member MetadataResolvers");
            this.resolvers = Collections.emptyList();
        }
    }

    protected void doDestroy() {
        super.doDestroy();
        this.resolvers = Collections.emptyList();
    }
}

